/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.operators.ARGOperatorFailedException;
import dr.evomodel.operators.ExchangeOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class ARGExchangeOperator
extends SimpleMCMCOperator {
    public static final String NARROW_EXCHANGE = "argNarrowExchange";
    public static final String WIDE_EXCHANGE = "argWideExchange";
    public static final int NARROW = 0;
    public static final int WIDE = 1;
    private static final int MAX_TRIES = 10000;
    private int mode = 0;
    private ARGModel tree;
    public static XMLObjectParser NARROW_EXCHANGE_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ARGExchangeOperator.NARROW_EXCHANGE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            int n = xMLObject.getIntegerAttribute("weight");
            return new ARGExchangeOperator(0, aRGModel, n);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a narrow exchange operator. This operator swaps a random subtree with its uncle.";
        }

        @Override
        public Class getReturnType() {
            return ExchangeOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    public static XMLObjectParser WIDE_EXCHANGE_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ARGExchangeOperator.WIDE_EXCHANGE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            int n = xMLObject.getIntegerAttribute("weight");
            return new ARGExchangeOperator(1, aRGModel, n);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a wide exchange operator. This operator swaps two random subtrees.";
        }

        @Override
        public Class getReturnType() {
            return ExchangeOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ARGExchangeOperator(int n, ARGModel aRGModel, int n2) {
        this.mode = n;
        this.tree = aRGModel;
        this.setWeight(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double doOperation() {
        double d = 0.0;
        int n = this.tree.getExternalNodeCount();
        if (this.mode == 0) {
            if (this.tree.getReassortmentNodeCount() >= 2) return 0.0;
            d = this.narrow();
        } else {
            d = this.wide();
        }
        if (this.tree.getExternalNodeCount() != n) {
            throw new RuntimeException("Lost some tips in " + (this.mode == 0 ? "NARROW mode." : "WIDE mode."));
        }
        assert (!Double.isInfinite(d) && !Double.isNaN(d));
        return d;
    }

    public int getAllValidNarrowMoves() {
        NodeRef nodeRef = null;
        NodeRef nodeRef2 = null;
        NodeRef nodeRef3 = null;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(this.tree.getNodeCount());
        ArrayList<NarrowMove> arrayList2 = new ArrayList<NarrowMove>(this.tree.getNodeCount());
        int n = this.tree.getNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef4 = this.tree.getNode(i);
            if (this.tree.isRoot(nodeRef4) || this.tree.isRoot(this.tree.getParent(nodeRef4, 0)) || this.tree.isRoot(this.tree.getParent(nodeRef4, 1))) continue;
            arrayList.add(nodeRef4);
        }
        for (NodeRef nodeRef4 : arrayList) {
            for (int i = 0; i < 2; ++i) {
                nodeRef = this.tree.getParent(nodeRef4, i);
                for (int j = 0; j < 2; ++j) {
                    nodeRef3 = this.tree.getParent(nodeRef, j);
                    nodeRef2 = this.tree.getOtherChild(nodeRef3, nodeRef);
                    NarrowMove narrowMove = new NarrowMove(nodeRef4, nodeRef, nodeRef2, nodeRef3);
                    if (!this.validMove(narrowMove) || arrayList2.contains(narrowMove)) continue;
                    arrayList2.add(narrowMove);
                }
            }
        }
        assert (arrayList2.size() > 0);
        return arrayList2.size();
    }

    private boolean validMove(NarrowMove narrowMove) {
        return narrowMove.j != narrowMove.iP && narrowMove.i != narrowMove.j && this.tree.getNodeHeight(narrowMove.j) < this.tree.getNodeHeight(narrowMove.iP) && this.tree.getNodeHeight(narrowMove.i) < this.tree.getNodeHeight(narrowMove.jP);
    }

    public double narrow() {
        int n;
        NodeRef nodeRef = null;
        NodeRef nodeRef2 = null;
        NodeRef nodeRef3 = null;
        NodeRef nodeRef4 = null;
        int n2 = this.getAllValidNarrowMoves();
        for (n = 0; n < 10000; ++n) {
            nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            while (this.tree.getRoot() == nodeRef || this.tree.getParent(nodeRef, 0) == this.tree.getRoot() || this.tree.getParent(nodeRef, 1) == this.tree.getRoot()) {
                nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            }
            nodeRef2 = this.tree.getParent(nodeRef, 0);
            if (this.tree.isReassortment(nodeRef) && MathUtils.nextBoolean()) {
                nodeRef2 = this.tree.getParent(nodeRef, 1);
            }
            nodeRef4 = this.tree.getParent(nodeRef2, 0);
            if (this.tree.isReassortment(nodeRef2) && MathUtils.nextBoolean()) {
                nodeRef4 = this.tree.getParent(nodeRef2, 1);
            }
            if ((nodeRef3 = this.tree.getChild(nodeRef4, 0)) == nodeRef2) {
                nodeRef3 = this.tree.getChild(nodeRef4, 1);
            }
            if (nodeRef3 != nodeRef2 && nodeRef != nodeRef3 && this.tree.getNodeHeight(nodeRef3) < this.tree.getNodeHeight(nodeRef2) && this.tree.getNodeHeight(nodeRef) < this.tree.getNodeHeight(nodeRef4)) break;
        }
        if (n < 10000) {
            try {
                this.eupdateARG(nodeRef, nodeRef3, nodeRef2, nodeRef4);
            }
            catch (ARGOperatorFailedException aRGOperatorFailedException) {
                return Double.NEGATIVE_INFINITY;
            }
        } else {
            return Double.NEGATIVE_INFINITY;
        }
        this.tree.pushTreeChangedEvent(nodeRef2);
        this.tree.pushTreeChangedEvent(nodeRef4);
        return Math.log((double)n2 / (double)this.getAllValidNarrowMoves());
    }

    public double wide() {
        int n;
        NodeRef nodeRef = null;
        NodeRef nodeRef2 = null;
        NodeRef nodeRef3 = null;
        NodeRef nodeRef4 = null;
        for (n = 0; n < 10000; ++n) {
            nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            while (this.tree.getRoot() == nodeRef) {
                nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            }
            nodeRef3 = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            while (nodeRef3 == nodeRef || nodeRef3 == this.tree.getRoot()) {
                nodeRef3 = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()));
            }
            nodeRef2 = this.tree.getParent(nodeRef);
            if (nodeRef2 != (nodeRef4 = this.tree.getParent(nodeRef3)) && nodeRef != nodeRef4 && nodeRef3 != nodeRef2 && this.tree.getNodeHeight(nodeRef3) < this.tree.getNodeHeight(nodeRef2) && this.tree.getNodeHeight(nodeRef) < this.tree.getNodeHeight(nodeRef4)) break;
        }
        if (n < 10000) {
            try {
                this.eupdateARG(nodeRef, nodeRef3, nodeRef2, nodeRef4);
            }
            catch (ARGOperatorFailedException aRGOperatorFailedException) {
                return Double.NEGATIVE_INFINITY;
            }
        } else {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public String getOperatorName() {
        return (this.mode == 0 ? "Narrow" : "Wide") + " Exchange";
    }

    private void eupdateARG(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) throws ARGOperatorFailedException {
        this.tree.beginTreeEdit();
        boolean bl = this.tree.isBifurcation(nodeRef);
        boolean bl2 = this.tree.isBifurcation(nodeRef2);
        if (bl && bl2) {
            this.tree.removeChild(nodeRef3, nodeRef);
            this.tree.removeChild(nodeRef4, nodeRef2);
            this.tree.addChild(nodeRef4, nodeRef);
            this.tree.addChild(nodeRef3, nodeRef2);
        } else if ((bl || bl2) && bl2) {
            NodeRef nodeRef5 = nodeRef;
            NodeRef nodeRef6 = nodeRef3;
            nodeRef = nodeRef2;
            nodeRef3 = nodeRef4;
            nodeRef2 = nodeRef5;
            nodeRef4 = nodeRef6;
        }
        this.tree.endTreeEdit();
        try {
            this.tree.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new ARGOperatorFailedException(invalidTreeException.toString());
        }
    }

    public double getMinimumAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    public double getMinimumGoodAcceptanceLevel() {
        if (this.mode == 0) {
            return 0.05;
        }
        return 0.01;
    }

    private class NarrowMove {
        public NodeRef i;
        public NodeRef j;
        public NodeRef iP;
        public NodeRef jP;

        public NarrowMove(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) {
            this.i = nodeRef;
            this.j = nodeRef3;
            this.iP = nodeRef2;
            this.jP = nodeRef4;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NarrowMove)) {
                return false;
            }
            NarrowMove narrowMove = (NarrowMove)object;
            if (this.i == narrowMove.i && this.j == narrowMove.j && this.iP == narrowMove.iP && this.jP == narrowMove.jP) {
                return true;
            }
            return this.i == narrowMove.j && this.j == narrowMove.i && this.iP == narrowMove.jP && this.jP == narrowMove.iP;
        }

        public String toString() {
            return "(" + this.i.toString() + ", " + this.iP.toString() + ", " + this.jP.toString() + ", " + this.j.toString() + ")";
        }
    }
}

