/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.evomodel.treelikelihood.MarkovJumpsTraitProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public interface CountableBranchCategoryProvider
extends TreeTrait<Double> {
    public int getBranchCategory(Tree var1, NodeRef var2);

    public void setCategoryCount(int var1);

    public int getCategoryCount();

    public static class CladeBranchCategoryModel
    extends BranchCategoryModel {
        private boolean cladesChanged = false;
        private List<CladeContainer> leafSetList = null;
        private List<CladeContainer> trunkSetList = null;

        public CladeBranchCategoryModel(TreeModel treeModel, Parameter parameter) {
            super(treeModel, parameter);
        }

        @Override
        public void handleModelChangedEvent(Model model, Object object, int n) {
            if (model != this.treeModel) {
                throw new IllegalArgumentException("Unknown model component!");
            }
            this.cladesChanged = true;
            this.fireModelChanged();
        }

        private void recurseDownClade(NodeRef nodeRef, MutableTreeModel mutableTreeModel, CladeContainer cladeContainer, boolean bl) {
            if (bl && !mutableTreeModel.isRoot(nodeRef)) {
                this.setNodeValue(mutableTreeModel, nodeRef, cladeContainer.getRateCategory());
            }
            if (!mutableTreeModel.isExternal(nodeRef)) {
                for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                    NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
                    this.recurseDownClade(nodeRef2, mutableTreeModel, cladeContainer, true);
                }
            }
        }

        private void updateCladeRateCategories() {
            if (this.leafSetList != null) {
                for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                    NodeRef object2 = this.treeModel.getNode(i);
                    if (object2 == this.treeModel.getRoot()) continue;
                    this.setNodeValue(this.treeModel, object2, 0.0);
                }
                for (CladeContainer cladeContainer : this.leafSetList) {
                    NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.treeModel, cladeContainer.getLeafSet());
                    if (nodeRef != this.treeModel.getRoot() && cladeContainer.getIncludeStem()) {
                        this.setNodeValue(this.treeModel, nodeRef, cladeContainer.getRateCategory());
                    }
                    if (cladeContainer.getExcludeClade()) continue;
                    this.recurseDownClade(nodeRef, this.treeModel, cladeContainer, cladeContainer.getIncludeStem());
                }
            }
            if (this.trunkSetList != null) {
                if (this.leafSetList == null) {
                    for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                        NodeRef nodeRef = this.treeModel.getNode(i);
                        if (nodeRef == this.treeModel.getRoot()) continue;
                        this.setNodeValue(this.treeModel, nodeRef, 0.0);
                    }
                }
                for (CladeContainer cladeContainer : this.trunkSetList) {
                    for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                        NodeRef nodeRef = this.treeModel.getNode(i);
                        if (!this.onAncestralPath(this.treeModel, nodeRef, cladeContainer.getLeafSet(), cladeContainer.getExcludeClade(), false) || nodeRef == this.treeModel.getRoot()) continue;
                        this.setNodeValue(this.treeModel, nodeRef, cladeContainer.getRateCategory());
                    }
                }
            }
        }

        private boolean onAncestralPath(Tree tree, NodeRef nodeRef, Set set, boolean bl, boolean bl2) {
            if (bl2 && tree.isExternal(nodeRef)) {
                return false;
            }
            Set<String> set2 = TreeUtils.getDescendantLeaves(tree, nodeRef);
            int n = set2.size();
            set2.retainAll(set);
            if (set2.size() > 0) {
                if (bl) {
                    if (set2.size() == n) {
                        Set<String> set3 = TreeUtils.getDescendantLeaves(tree, tree.getParent(nodeRef));
                        set3.removeAll(set);
                        return set3.size() > 0;
                    }
                    return true;
                }
                return set2.size() > 0;
            }
            return false;
        }

        public void setClade(TaxonList taxonList, int n, boolean bl, boolean bl2, boolean bl3) throws TreeUtils.MissingTaxonException {
            Set<String> set = TreeUtils.getLeavesForTaxa(this.treeModel, taxonList);
            if (!bl3) {
                if (this.leafSetList == null) {
                    this.leafSetList = new ArrayList<CladeContainer>();
                }
                this.leafSetList.add(new CladeContainer(set, n, bl, bl2));
                this.cladesChanged = true;
            } else {
                if (this.trunkSetList == null) {
                    this.trunkSetList = new ArrayList<CladeContainer>();
                }
                this.trunkSetList.add(new CladeContainer(set, n, bl, bl2));
                this.cladesChanged = true;
            }
            if (n >= this.categoryCount) {
                this.categoryCount = n + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBranchCategory(Tree tree, NodeRef nodeRef) {
            CladeBranchCategoryModel cladeBranchCategoryModel = this;
            synchronized (cladeBranchCategoryModel) {
                if (this.cladesChanged) {
                    this.updateCladeRateCategories();
                    this.cladesChanged = false;
                }
            }
            return super.getBranchCategory(tree, nodeRef);
        }

        private class CladeContainer {
            private Set<String> leafSet;
            private int rateCategory;
            boolean includeStem;
            boolean excludeClade;

            public CladeContainer(Set<String> set, int n, boolean bl, boolean bl2) {
                this.leafSet = set;
                this.rateCategory = n;
                this.includeStem = bl;
                this.excludeClade = bl2;
            }

            public Set<String> getLeafSet() {
                return this.leafSet;
            }

            public int getRateCategory() {
                return this.rateCategory;
            }

            public boolean getIncludeStem() {
                return this.includeStem;
            }

            public boolean getExcludeClade() {
                return this.excludeClade;
            }
        }
    }

    public static class MarkovJumpBranchCategoryModel
    extends BranchCategoryModel {
        private boolean traitsChanged = true;

        public MarkovJumpBranchCategoryModel(MarkovJumpsTraitProvider markovJumpsTraitProvider, Parameter parameter) {
            super(markovJumpsTraitProvider.getTreeModel(), parameter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBranchCategory(Tree tree, NodeRef nodeRef) {
            MarkovJumpBranchCategoryModel markovJumpBranchCategoryModel = this;
            synchronized (markovJumpBranchCategoryModel) {
                if (this.traitsChanged) {
                    this.updateTraitRateCategories();
                    this.traitsChanged = false;
                }
            }
            return super.getBranchCategory(tree, nodeRef);
        }

        private void updateTraitRateCategories() {
        }

        @Override
        public void handleModelChangedEvent(Model model, Object object, int n) {
            if (model != this.treeModel) {
                throw new IllegalArgumentException("Unknown model component!");
            }
            this.traitsChanged = true;
            this.fireModelChanged();
        }
    }

    public static class IndependentBranchCategoryModel
    extends BranchCategoryModel {
        public IndependentBranchCategoryModel(TreeModel treeModel, Parameter parameter) {
            super(treeModel, parameter);
        }

        public void randomize() {
            for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                NodeRef nodeRef = this.treeModel.getNode(i);
                if (nodeRef == this.treeModel.getRoot()) continue;
                int n = MathUtils.nextInt(this.categoryCount);
                this.setNodeValue(this.treeModel, nodeRef, n);
            }
        }
    }

    public static abstract class BranchCategoryModel
    extends TreeParameterModel
    implements CountableBranchCategoryProvider {
        protected int categoryCount;
        protected final Parameter categoryParameter;
        protected final MutableTreeModel treeModel;

        public BranchCategoryModel(MutableTreeModel mutableTreeModel, Parameter parameter) {
            super(mutableTreeModel, parameter, false, TreeTrait.Intent.BRANCH);
            this.categoryParameter = parameter;
            this.treeModel = mutableTreeModel;
            this.categoryCount = 1;
        }

        @Override
        public void setCategoryCount(int n) {
            this.categoryCount = n;
            Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(this.categoryCount - 1, 0.0, this.categoryParameter.getDimension());
            this.categoryParameter.addBounds(defaultBounds);
            for (int i = 0; i < this.categoryParameter.getDimension(); ++i) {
                if (!(this.categoryParameter.getParameterValue(i) >= (double)this.categoryCount)) continue;
                this.categoryParameter.setParameterValue(i, this.categoryCount - 1);
            }
        }

        @Override
        public int getBranchCategory(Tree tree, NodeRef nodeRef) {
            return (int)Math.round(this.getNodeValue(tree, nodeRef));
        }

        @Override
        public int getCategoryCount() {
            return this.categoryCount;
        }
    }

    public static class SingleBranchCategoryModel
    implements CountableBranchCategoryProvider {
        @Override
        public int getBranchCategory(Tree tree, NodeRef nodeRef) {
            return 0;
        }

        @Override
        public void setCategoryCount(int n) {
        }

        @Override
        public int getCategoryCount() {
            return 1;
        }

        @Override
        public String getTraitName() {
            return "categories";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.BRANCH;
        }

        @Override
        public Class getTraitClass() {
            return Integer.class;
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            return 1.0;
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return "1";
        }

        @Override
        public boolean getLoggable() {
            return true;
        }
    }
}

