/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.app.tools.NexusExporter;
import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.AbstractOutbreak;
import dr.evomodel.epidemiology.casetocase.BadPartitionException;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CategoryOutbreak;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.epidemiology.casetocase.periodpriors.AbstractPeriodPriorDistribution;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Median;

public abstract class CaseToCaseTreeLikelihood
extends AbstractTreeLikelihood
implements Loggable,
Citable,
TreeTraitProvider {
    protected static final boolean DEBUG = false;
    protected static double tolerance = 1.0E-10;
    protected int noTips;
    protected int noCases;
    private double estimatedLastSampleTime;
    protected TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    protected AbstractOutbreak outbreak;
    protected double[] infectionTimes;
    private double[] storedInfectionTimes;
    protected double[] infectiousPeriods;
    private double[] storedInfectiousPeriods;
    protected double[] infectiousTimes;
    private double[] storedInfectiousTimes;
    protected double[] latentPeriods;
    private double[] storedLatentPeriods;
    protected boolean[] recalculateCaseFlags;
    protected HashMap<AbstractCase, Treelet> elementsAsTrees;
    protected HashMap<AbstractCase, Treelet> storedElementsAsTrees;
    protected Parameter maxFirstInfToRoot;
    protected boolean hasLatentPeriods;
    public static final String CASE_TO_CASE_TREE_LIKELIHOOD = "caseToCaseTreeLikelihood";
    public static final String PARTITIONS_KEY = "partition";

    public CaseToCaseTreeLikelihood(PartitionedTreeModel partitionedTreeModel, AbstractOutbreak abstractOutbreak, Parameter parameter) throws TaxonList.MissingTaxonException {
        this(CASE_TO_CASE_TREE_LIKELIHOOD, partitionedTreeModel, abstractOutbreak, parameter);
    }

    public CaseToCaseTreeLikelihood(String string, PartitionedTreeModel partitionedTreeModel, AbstractOutbreak abstractOutbreak, Parameter parameter) {
        super(string, abstractOutbreak, partitionedTreeModel);
        if (this.stateCount != this.treeModel.getExternalNodeCount()) {
            throw new RuntimeException("There are duplicate tip outbreak.");
        }
        this.noTips = partitionedTreeModel.getExternalNodeCount();
        this.outbreak = abstractOutbreak;
        this.noCases = this.outbreak.getCases().size();
        this.addModel(this.outbreak);
        this.estimatedLastSampleTime = this.getLatestTaxonTime();
        this.addModel(partitionedTreeModel.getBranchMap());
        this.hasLatentPeriods = this.outbreak.hasLatentPeriods();
        this.infectionTimes = new double[this.outbreak.size()];
        this.infectiousPeriods = new double[this.outbreak.size()];
        if (this.hasLatentPeriods) {
            this.infectiousTimes = new double[this.outbreak.size()];
            this.latentPeriods = new double[this.outbreak.size()];
        }
        this.recalculateCaseFlags = new boolean[this.outbreak.size()];
        Arrays.fill(this.recalculateCaseFlags, true);
        this.maxFirstInfToRoot = parameter;
        this.treeTraits.addTrait(PARTITIONS_KEY, new TreeTrait.S(){

            @Override
            public String getTraitName() {
                return CaseToCaseTreeLikelihood.PARTITIONS_KEY;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public String getTrait(Tree tree, NodeRef nodeRef) {
                return CaseToCaseTreeLikelihood.this.getNodePartition(tree, nodeRef);
            }
        });
        this.likelihoodKnown = false;
    }

    public AbstractOutbreak getOutbreak() {
        return this.outbreak;
    }

    public boolean hasLatentPeriods() {
        return this.hasLatentPeriods;
    }

    private double getLatestTaxonTime() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            Taxon taxon = this.treeModel.getNodeTaxon(this.treeModel.getExternalNode(i));
            if (!(taxon.getDate().getTimeValue() > d)) continue;
            d = taxon.getDate().getTimeValue();
        }
        return d;
    }

    private NodeRef[] getChildren(NodeRef nodeRef) {
        NodeRef[] nodeRefArray = new NodeRef[this.treeModel.getChildCount(nodeRef)];
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            nodeRefArray[i] = this.treeModel.getChild(nodeRef, i);
        }
        return nodeRefArray;
    }

    protected void explodeTree() {
        for (int i = 0; i < this.outbreak.size(); ++i) {
            AbstractCase abstractCase = this.outbreak.getCase(i);
            if (!abstractCase.wasEverInfected() || this.elementsAsTrees.get(abstractCase) != null) continue;
            NodeRef nodeRef = ((PartitionedTreeModel)this.treeModel).getEarliestNodeInElement(abstractCase);
            double d = this.treeModel.isRoot(nodeRef) ? this.maxFirstInfToRoot.getParameterValue(0) * abstractCase.getInfectionBranchPosition().getParameterValue(0) : this.treeModel.getBranchLength(nodeRef) * abstractCase.getInfectionBranchPosition().getParameterValue(0);
            FlexibleNode flexibleNode = new FlexibleNode();
            FlexibleTree flexibleTree = new FlexibleTree(flexibleNode);
            flexibleTree.beginTreeEdit();
            if (!this.treeModel.isExternal(nodeRef)) {
                for (int j = 0; j < this.treeModel.getChildCount(nodeRef); ++j) {
                    this.copyElementToTreelet(flexibleTree, this.treeModel.getChild(nodeRef, j), flexibleNode, abstractCase);
                }
            }
            flexibleTree.endTreeEdit();
            flexibleTree.resolveTree();
            Treelet treelet = new Treelet(flexibleTree, flexibleTree.getRootHeight() + d);
            this.elementsAsTrees.put(abstractCase, treelet);
        }
    }

    private void copyElementToTreelet(FlexibleTree flexibleTree, NodeRef nodeRef, NodeRef nodeRef2, AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected()) {
            if (this.getBranchMap().get(nodeRef.getNumber()) == abstractCase) {
                if (this.treeModel.isExternal(nodeRef)) {
                    FlexibleNode flexibleNode = new FlexibleNode(new Taxon(this.treeModel.getNodeTaxon(nodeRef).getId()));
                    flexibleTree.addChild(nodeRef2, flexibleNode);
                    flexibleTree.setBranchLength(flexibleNode, this.treeModel.getBranchLength(nodeRef));
                } else {
                    FlexibleNode flexibleNode = new FlexibleNode();
                    flexibleTree.addChild(nodeRef2, flexibleNode);
                    flexibleTree.setBranchLength(flexibleNode, this.treeModel.getBranchLength(nodeRef));
                    for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
                        this.copyElementToTreelet(flexibleTree, this.treeModel.getChild(nodeRef, i), flexibleNode, abstractCase);
                    }
                }
            } else {
                FlexibleNode flexibleNode = new FlexibleNode(new Taxon("Transmission_" + this.getBranchMap().get(nodeRef.getNumber()).getName()));
                double d = this.getNodeTime(this.treeModel.getParent(nodeRef));
                double d2 = this.getInfectionTime(this.getBranchMap().get(nodeRef.getNumber()));
                flexibleTree.addChild(nodeRef2, flexibleNode);
                flexibleTree.setBranchLength(flexibleNode, d2 - d);
            }
        }
    }

    public HashSet<AbstractCase> descendantTipPartitions(NodeRef nodeRef, HashMap<Integer, HashSet<AbstractCase>> hashMap) {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>();
        if (this.treeModel.isExternal(nodeRef)) {
            hashSet.add(this.getBranchMap().get(nodeRef.getNumber()));
            if (hashMap != null) {
                hashMap.put(nodeRef.getNumber(), hashSet);
            }
            return hashSet;
        }
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            hashSet.addAll(this.descendantTipPartitions(this.treeModel.getChild(nodeRef, i), hashMap));
        }
        if (hashMap != null) {
            hashMap.put(nodeRef.getNumber(), hashSet);
        }
        return hashSet;
    }

    protected static void flagForDescendantRecalculation(TreeModel treeModel, NodeRef nodeRef, boolean[] blArray) {
        blArray[nodeRef.getNumber()] = true;
        for (int i = 0; i < treeModel.getChildCount(nodeRef); ++i) {
            blArray[treeModel.getChild((NodeRef)nodeRef, (int)i).getNumber()] = true;
        }
        NodeRef nodeRef2 = nodeRef;
        while (!treeModel.isRoot(nodeRef2) && !blArray[nodeRef2.getNumber()]) {
            nodeRef2 = treeModel.getParent(nodeRef2);
            blArray[nodeRef2.getNumber()] = true;
        }
    }

    public void flagForDescendantRecalculation(TreeModel treeModel, NodeRef nodeRef) {
        CaseToCaseTreeLikelihood.flagForDescendantRecalculation(treeModel, nodeRef, this.updateNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model instanceof AbstractPeriodPriorDistribution) return;
        if (model == this.treeModel) {
            if (object instanceof PartitionedTreeModel.PartitionsChangedEvent) {
                HashSet<AbstractCase> hashSet = ((PartitionedTreeModel.PartitionsChangedEvent)object).getCasesToRecalculate();
                for (AbstractCase abstractCase : hashSet) {
                    this.recalculateCase(abstractCase);
                }
            }
        } else if (model == this.getBranchMap()) {
            if (!(object instanceof ArrayList)) throw new RuntimeException("Unanticipated model changed event from BranchMapModel");
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                BranchMapModel.BranchMapChangedEvent branchMapChangedEvent = (BranchMapModel.BranchMapChangedEvent)((ArrayList)object).get(i);
                this.recalculateCase(branchMapChangedEvent.getOldCase());
                this.recalculateCase(branchMapChangedEvent.getNewCase());
                NodeRef nodeRef = this.treeModel.getNode(branchMapChangedEvent.getNodeToRecalculate());
                NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
                if (nodeRef2 == null) continue;
                this.recalculateCase(this.getBranchMap().get(nodeRef2.getNumber()));
            }
        } else if (model == this.outbreak) {
            if (object instanceof AbstractCase) {
                this.recalculateCase((AbstractCase)object);
            } else {
                for (AbstractCase abstractCase : this.outbreak.getCases()) {
                    this.recalculateCase(abstractCase);
                }
            }
        }
        this.fireModelChanged(model);
        this.likelihoodKnown = false;
    }

    protected void recalculateCase(int n) {
        this.recalculateCaseFlags[n] = true;
    }

    protected void recalculateCase(AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected()) {
            this.recalculateCase(this.outbreak.getCaseIndex(abstractCase));
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        super.storeState();
        this.storedInfectionTimes = Arrays.copyOf(this.infectionTimes, this.infectionTimes.length);
        this.storedInfectiousPeriods = Arrays.copyOf(this.infectiousPeriods, this.infectiousPeriods.length);
        if (this.hasLatentPeriods) {
            this.storedInfectiousTimes = Arrays.copyOf(this.infectiousTimes, this.infectionTimes.length);
            this.storedLatentPeriods = Arrays.copyOf(this.latentPeriods, this.latentPeriods.length);
        }
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        this.infectionTimes = this.storedInfectionTimes;
        this.infectiousPeriods = this.storedInfectiousPeriods;
        if (this.hasLatentPeriods) {
            this.infectiousTimes = this.storedInfectiousTimes;
            this.latentPeriods = this.storedLatentPeriods;
        }
    }

    @Override
    protected final void acceptState() {
    }

    public final BranchMapModel getBranchMap() {
        return ((PartitionedTreeModel)this.treeModel).getBranchMap();
    }

    @Override
    public final PartitionedTreeModel getTreeModel() {
        return (PartitionedTreeModel)this.treeModel;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        Arrays.fill(this.recalculateCaseFlags, true);
    }

    protected void prepareTimings() {
        this.infectionTimes = this.getInfectionTimes(true);
        if (this.hasLatentPeriods) {
            this.infectiousTimes = this.getInfectiousTimes(true);
        }
        this.infectiousPeriods = this.getInfectiousPeriods(true);
        if (this.hasLatentPeriods) {
            this.latentPeriods = this.getLatentPeriods(true);
        }
        Arrays.fill(this.recalculateCaseFlags, false);
    }

    @Override
    protected abstract double calculateLogLikelihood();

    protected boolean isAllowed() {
        return this.isAllowed(this.treeModel.getRoot());
    }

    private boolean isAllowed(NodeRef nodeRef) {
        double d;
        AbstractCase abstractCase;
        AbstractCase abstractCase2;
        if (!this.treeModel.isRoot(nodeRef) && (abstractCase2 = this.getBranchMap().get(nodeRef.getNumber())) != (abstractCase = this.getBranchMap().get(this.treeModel.getParent(nodeRef).getNumber())) && ((d = this.infectionTimes[this.outbreak.getCaseIndex(abstractCase2)]) > abstractCase.getEndTime() || this.hasLatentPeriods && d < this.infectiousTimes[this.outbreak.getCaseIndex(abstractCase)])) {
            return false;
        }
        return this.treeModel.isExternal(nodeRef) || this.isAllowed(this.treeModel.getChild(nodeRef, 0)) && this.isAllowed(this.treeModel.getChild(nodeRef, 1));
    }

    public double getNodeTime(NodeRef nodeRef) {
        double d = this.getHeight(nodeRef);
        return this.estimatedLastSampleTime - d;
    }

    public double heightToTime(double d) {
        return this.estimatedLastSampleTime - d;
    }

    public double timeToHeight(double d) {
        return this.estimatedLastSampleTime - d;
    }

    private double getHeight(NodeRef nodeRef) {
        return this.treeModel.getNodeHeight(nodeRef);
    }

    public double getInfectionTime(AbstractCase abstractCase) {
        if (!this.recalculateCaseFlags[this.outbreak.getCaseIndex(abstractCase)]) {
            return this.infectionTimes[this.outbreak.getCaseIndex(abstractCase)];
        }
        if (abstractCase.wasEverInfected()) {
            NodeRef nodeRef = ((PartitionedTreeModel)this.treeModel).getEarliestNodeInElement(abstractCase);
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            if (nodeRef2 != null) {
                double d = this.heightToTime(this.treeModel.getNodeHeight(nodeRef2));
                double d2 = this.heightToTime(this.treeModel.getNodeHeight(nodeRef));
                return this.getInfectionTime(d, d2, abstractCase);
            }
            return this.getRootInfectionTime(this.getBranchMap());
        }
        return Double.POSITIVE_INFINITY;
    }

    private double getInfectionTime(double d, double d2, AbstractCase abstractCase) {
        double d3 = d2 - d;
        return d + d3 * (1.0 - abstractCase.getInfectionBranchPosition().getParameterValue(0));
    }

    public double[] getInfectionTimes(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.noCases; ++i) {
                if (!this.recalculateCaseFlags[i]) continue;
                this.infectionTimes[i] = this.getInfectionTime(this.outbreak.getCase(i));
            }
        }
        return this.infectionTimes;
    }

    public void setInfectionTime(AbstractCase abstractCase, double d) {
        this.setInfectionHeight(abstractCase, this.timeToHeight(d));
    }

    public void setInfectionHeight(AbstractCase abstractCase, double d) {
        if (abstractCase.wasEverInfected()) {
            double d2;
            NodeRef nodeRef = ((PartitionedTreeModel)this.treeModel).getEarliestNodeInElement(abstractCase);
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            double d3 = this.treeModel.getNodeHeight(nodeRef);
            double d4 = d2 = nodeRef2 != null ? this.treeModel.getNodeHeight(nodeRef2) : d3 + this.maxFirstInfToRoot.getParameterValue(0);
            if (d < d3 || d > d2) {
                throw new RuntimeException("Trying to set an infection time outside the branch on which it must occur");
            }
            double d5 = (d - d3) / (d2 - d3);
            abstractCase.setInfectionBranchPosition(d5);
        }
    }

    public double getInfectiousTime(AbstractCase abstractCase) {
        if (!this.hasLatentPeriods) {
            return this.getInfectionTime(abstractCase);
        }
        if (this.recalculateCaseFlags[this.outbreak.getCaseIndex(abstractCase)]) {
            if (abstractCase.wasEverInfected()) {
                String string = ((CategoryOutbreak)this.outbreak).getLatentCategory(abstractCase);
                Parameter parameter = ((CategoryOutbreak)this.outbreak).getLatentPeriod(string);
                this.infectiousTimes[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = this.getInfectionTime(abstractCase) + parameter.getParameterValue(0);
            } else {
                this.infectiousTimes[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = Double.POSITIVE_INFINITY;
            }
        }
        return this.infectiousTimes[this.outbreak.getCaseIndex(abstractCase)];
    }

    public double[] getInfectiousTimes(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.noCases; ++i) {
                if (!this.recalculateCaseFlags[i]) continue;
                this.infectiousTimes[i] = this.getInfectiousTime(this.outbreak.getCase(i));
            }
        }
        return this.infectiousTimes;
    }

    public double getInfectiousPeriod(AbstractCase abstractCase) {
        if (this.recalculateCaseFlags[this.outbreak.getCaseIndex(abstractCase)]) {
            if (abstractCase.wasEverInfected()) {
                if (!this.hasLatentPeriods) {
                    double d = this.getInfectionTime(abstractCase);
                    double d2 = abstractCase.getEndTime();
                    this.infectiousPeriods[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = d2 - d;
                } else {
                    double d = this.getInfectiousTime(abstractCase);
                    double d3 = abstractCase.getEndTime();
                    this.infectiousPeriods[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = d3 - d;
                }
            } else {
                this.infectiousPeriods[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = 0.0;
            }
        }
        return this.infectiousPeriods[this.outbreak.getCaseIndex(abstractCase)];
    }

    public double[] getInfectiousPeriods(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.noCases; ++i) {
                if (!this.recalculateCaseFlags[i]) continue;
                this.infectiousPeriods[i] = this.getInfectiousPeriod(this.outbreak.getCase(i));
            }
        }
        return this.infectiousPeriods;
    }

    public Double[] getNonzeroInfectiousPeriods() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.noCases; ++i) {
            AbstractCase abstractCase = this.outbreak.getCase(i);
            if (!abstractCase.wasEverInfected()) continue;
            arrayList.add(this.getInfectiousPeriod(abstractCase));
        }
        return arrayList.toArray(new Double[arrayList.size()]);
    }

    public double getLatentPeriod(AbstractCase abstractCase) {
        if (!this.hasLatentPeriods || !abstractCase.wasEverInfected()) {
            return 0.0;
        }
        if (this.recalculateCaseFlags[this.outbreak.getCaseIndex(abstractCase)]) {
            this.latentPeriods[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = this.getInfectiousTime(abstractCase) - this.getInfectionTime(abstractCase);
        }
        return this.latentPeriods[this.outbreak.getCaseIndex(abstractCase)];
    }

    public double[] getLatentPeriods(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.noCases; ++i) {
                if (!this.recalculateCaseFlags[i]) continue;
                this.latentPeriods[i] = this.getLatentPeriod(this.outbreak.getCase(i));
            }
        }
        return this.latentPeriods;
    }

    public Double[] getNonzeroLatentPeriods() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.noCases; ++i) {
            AbstractCase abstractCase = this.outbreak.getCase(i);
            if (!abstractCase.wasEverInfected()) continue;
            arrayList.add(this.getLatentPeriod(abstractCase));
        }
        return arrayList.toArray(new Double[arrayList.size()]);
    }

    public double[] getInfectedPeriods(boolean bl) {
        if (!this.hasLatentPeriods) {
            return this.getInfectiousPeriods(bl);
        }
        double[] dArray = new double[this.noCases];
        for (int i = 0; i < this.noCases; ++i) {
            dArray[i] = this.getInfectedPeriod(this.outbreak.getCase(i));
        }
        return dArray;
    }

    public Double[] getNonzeroInfectedPeriods() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.noCases; ++i) {
            AbstractCase abstractCase = this.outbreak.getCase(i);
            if (!abstractCase.wasEverInfected()) continue;
            arrayList.add(this.getInfectedPeriod(abstractCase));
        }
        return arrayList.toArray(new Double[arrayList.size()]);
    }

    public double getInfectedPeriod(AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected) {
            return abstractCase.getEndTime() - this.getInfectionTime(abstractCase);
        }
        return 0.0;
    }

    public static Double[] getSummaryStatistics(Double[] doubleArray) {
        Double[] doubleArray2;
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        doubleArray2 = new Double[]{new Mean().evaluate(dArray), new Median().evaluate(dArray), new Variance().evaluate(dArray), Math.sqrt(doubleArray2[2])};
        return doubleArray2;
    }

    private double getRootInfectionTime(BranchMapModel branchMapModel) {
        NodeRef nodeRef = this.treeModel.getRoot();
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        double d = this.maxFirstInfToRoot.getParameterValue(0);
        return this.heightToTime(this.treeModel.getNodeHeight(nodeRef) + d * abstractCase.getInfectionBranchPosition().getParameterValue(0));
    }

    protected double getRootInfectionTime() {
        AbstractCase abstractCase = this.getBranchMap().get(this.treeModel.getRoot().getNumber());
        return this.getInfectionTime(abstractCase);
    }

    public void outputTreeToFile(String string, boolean bl) {
        this.outputTreeToFile(this.getBranchMap(), string, bl);
    }

    public void outputTreeToFile(BranchMapModel branchMapModel, String string, boolean bl) {
        try {
            FlexibleTree flexibleTree;
            if (!bl) {
                flexibleTree = new FlexibleTree(this.treeModel);
                for (int i = 0; i < flexibleTree.getNodeCount(); ++i) {
                    FlexibleNode flexibleNode = (FlexibleNode)flexibleTree.getNode(i);
                    flexibleNode.setAttribute("Number", flexibleNode.getNumber());
                    flexibleNode.setAttribute("Time", this.heightToTime(flexibleNode.getHeight()));
                    flexibleNode.setAttribute(PARTITIONS_KEY, branchMapModel.get(flexibleNode.getNumber()));
                }
            } else {
                flexibleTree = this.addTransmissionNodes(this.treeModel);
            }
            NexusExporter nexusExporter = new NexusExporter(new PrintStream(string));
            nexusExporter.exportTree((Tree)flexibleTree);
        }
        catch (IOException iOException) {
            System.out.println("IOException");
        }
    }

    public FlexibleTree addTransmissionNodes(Tree tree) {
        NodeRef nodeRef;
        this.prepareTimings();
        FlexibleTree flexibleTree = new FlexibleTree(tree, true);
        for (int i = 0; i < flexibleTree.getNodeCount(); ++i) {
            FlexibleNode serializable2 = (FlexibleNode)flexibleTree.getNode(i);
            serializable2.setAttribute("Number", serializable2.getNumber());
            serializable2.setAttribute("Time", this.heightToTime(serializable2.getHeight()));
            serializable2.setAttribute(PARTITIONS_KEY, this.getBranchMap().get(serializable2.getNumber()));
        }
        for (AbstractCase abstractCase : this.outbreak.getCases()) {
            FlexibleNode flexibleNode;
            if (!abstractCase.wasEverInfected()) continue;
            nodeRef = ((PartitionedTreeModel)this.treeModel).getEarliestNodeInElement(abstractCase);
            int n = nodeRef.getNumber();
            if (!this.treeModel.isRoot(nodeRef)) {
                NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
                double d = this.getNodeTime(nodeRef);
                double d2 = this.getInfectionTime(abstractCase);
                double d3 = this.getHeight(nodeRef) + (d - d2);
                flexibleNode = (FlexibleNode)flexibleTree.getNode(n);
                FlexibleNode flexibleNode2 = (FlexibleNode)flexibleTree.getParent(flexibleNode);
                flexibleTree.beginTreeEdit();
                flexibleTree.removeChild(flexibleNode2, flexibleNode);
                FlexibleNode flexibleNode3 = new FlexibleNode();
                flexibleNode3.setHeight(d3);
                flexibleNode3.setLength(flexibleNode2.getHeight() - d3);
                flexibleNode3.setAttribute(PARTITIONS_KEY, this.getNodePartition(this.treeModel, nodeRef2));
                flexibleNode3.setAttribute("Time", this.heightToTime(d3));
                flexibleNode.setLength(d - d2);
                flexibleTree.addChild(flexibleNode2, flexibleNode3);
                flexibleTree.addChild(flexibleNode3, flexibleNode);
                flexibleTree.endTreeEdit();
                continue;
            }
            double d = this.getNodeTime(nodeRef);
            double d4 = this.getInfectionTime(abstractCase);
            double d5 = this.getHeight(nodeRef) + (d - d4);
            FlexibleNode flexibleNode4 = (FlexibleNode)flexibleTree.getNode(n);
            flexibleTree.beginTreeEdit();
            flexibleNode = new FlexibleNode();
            flexibleNode.setHeight(d5);
            flexibleNode.setAttribute("Time", this.heightToTime(d5));
            flexibleNode.setAttribute(PARTITIONS_KEY, "Origin");
            flexibleTree.addChild(flexibleNode, flexibleNode4);
            flexibleNode4.setLength(d5 - this.getHeight(nodeRef));
            flexibleTree.setRoot(flexibleNode);
            flexibleTree.endTreeEdit();
        }
        flexibleTree = new FlexibleTree((FlexibleNode)flexibleTree.getRoot());
        for (int i = 0; i < flexibleTree.getNodeCount(); ++i) {
            NodeRef nodeRef3 = flexibleTree.getNode(i);
            nodeRef = flexibleTree.getParent(nodeRef3);
            if (nodeRef == null || !(flexibleTree.getNodeHeight(nodeRef3) > flexibleTree.getNodeHeight(nodeRef))) continue;
            try {
                NexusExporter nexusExporter = new NexusExporter(new PrintStream("fancyProblem.nex"));
                nexusExporter.exportTree((Tree)flexibleTree);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                ((PartitionedTreeModel)this.treeModel).checkPartitions();
            }
            catch (BadPartitionException badPartitionException) {
                System.out.print("Rewiring messed up because of partition problem.");
            }
            throw new RuntimeException("Rewiring messed up; investigate");
        }
        return flexibleTree;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.outbreak.infectedSize()];
        int n = 0;
        for (int i = 0; i < this.outbreak.size(); ++i) {
            final AbstractCase abstractCase = this.outbreak.getCase(i);
            if (!abstractCase.wasEverInfected()) continue;
            logColumnArray[n] = new LogColumn.Abstract(abstractCase.toString() + "_infector"){

                @Override
                protected String getFormattedValue() {
                    if (((PartitionedTreeModel)CaseToCaseTreeLikelihood.this.treeModel).getInfector(abstractCase) == null) {
                        return "{Start}";
                    }
                    return "{" + ((PartitionedTreeModel)CaseToCaseTreeLikelihood.this.treeModel).getInfector(abstractCase).toString() + "}";
                }
            };
            ++n;
        }
        return logColumnArray;
    }

    public LogColumn[] passColumns() {
        AbstractCase abstractCase;
        int n;
        ArrayList<LogColumn.Abstract> arrayList = new ArrayList<LogColumn.Abstract>();
        for (n = 0; n < this.outbreak.size(); ++n) {
            abstractCase = this.outbreak.getCase(n);
            if (!abstractCase.wasEverInfected()) continue;
            arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_infection_date"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.this.getInfectionTime(abstractCase));
                }
            });
        }
        if (this.hasLatentPeriods) {
            for (n = 0; n < this.outbreak.size(); ++n) {
                abstractCase = this.outbreak.getCase(n);
                if (!abstractCase.wasEverInfected()) continue;
                arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_infectious_date"){

                    @Override
                    protected String getFormattedValue() {
                        return String.valueOf(CaseToCaseTreeLikelihood.this.getInfectiousTime(abstractCase));
                    }
                });
            }
            for (n = 0; n < this.outbreak.size(); ++n) {
                abstractCase = this.outbreak.getCase(n);
                if (!abstractCase.wasEverInfected()) continue;
                arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_latent_period"){

                    @Override
                    protected String getFormattedValue() {
                        return String.valueOf(CaseToCaseTreeLikelihood.this.getLatentPeriod(abstractCase));
                    }
                });
            }
        }
        for (n = 0; n < this.outbreak.size(); ++n) {
            abstractCase = this.outbreak.getCase(n);
            if (!abstractCase.wasEverInfected()) continue;
            arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_infectious_period"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.this.getInfectiousPeriod(abstractCase));
                }
            });
        }
        if (this.hasLatentPeriods) {
            for (n = 0; n < this.outbreak.size(); ++n) {
                abstractCase = this.outbreak.getCase(n);
                if (!abstractCase.wasEverInfected()) continue;
                arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_infected_period"){

                    @Override
                    protected String getFormattedValue() {
                        return String.valueOf(CaseToCaseTreeLikelihood.this.getInfectiousPeriod(abstractCase) + CaseToCaseTreeLikelihood.this.getLatentPeriod(abstractCase));
                    }
                });
            }
        }
        arrayList.add(new LogColumn.Abstract("infectious_period.mean"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectiousPeriods())[0]);
            }
        });
        arrayList.add(new LogColumn.Abstract("infectious_period.median"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectiousPeriods())[1]);
            }
        });
        arrayList.add(new LogColumn.Abstract("infectious_period.var"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectiousPeriods())[2]);
            }
        });
        arrayList.add(new LogColumn.Abstract("infectious_period.stdev"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectiousPeriods())[3]);
            }
        });
        if (this.hasLatentPeriods) {
            arrayList.add(new LogColumn.Abstract("latent_period.mean"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroLatentPeriods())[0]);
                }
            });
            arrayList.add(new LogColumn.Abstract("latent_period.median"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroLatentPeriods())[1]);
                }
            });
            arrayList.add(new LogColumn.Abstract("latent_period.var"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroLatentPeriods())[2]);
                }
            });
            arrayList.add(new LogColumn.Abstract("latent_period.stdev"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroLatentPeriods())[3]);
                }
            });
            arrayList.add(new LogColumn.Abstract("infected_period.mean"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectedPeriods())[0]);
                }
            });
            arrayList.add(new LogColumn.Abstract("infected_period.median"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectedPeriods())[1]);
                }
            });
            arrayList.add(new LogColumn.Abstract("infected_period.var"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectedPeriods())[2]);
                }
            });
            arrayList.add(new LogColumn.Abstract("infected_period.stdev"){

                @Override
                protected String getFormattedValue() {
                    return String.valueOf(CaseToCaseTreeLikelihood.getSummaryStatistics(CaseToCaseTreeLikelihood.this.getNonzeroInfectedPeriods())[3]);
                }
            });
            for (n = 0; n < this.outbreak.size(); ++n) {
                abstractCase = this.outbreak.getCase(n);
                if (!abstractCase.wasEverInfected()) continue;
                arrayList.add(new LogColumn.Abstract(abstractCase.toString() + "_ibp"){

                    @Override
                    protected String getFormattedValue() {
                        return String.valueOf(abstractCase.getInfectionBranchPosition().getParameterValue(0));
                    }
                });
            }
        }
        return arrayList.toArray(new LogColumn[arrayList.size()]);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Case to Case Transmission Tree model";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("M", "Hall"), new Author("M", "Woolhouse"), new Author("A", "Rambaut")}, "Epidemic Reconstruction in a Phylogenetics Framework: Transmission Trees as Partitions of the Node Set", 2016, "PLOS Comput Biol", 11, 0, 0, "10.1371/journal.pcbi.1004613", Citation.Status.PUBLISHED));
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    public String getNodePartition(Tree tree, NodeRef nodeRef) {
        if (tree != this.treeModel) {
            try {
                NodeRef nodeRef2 = this.treeModel.getNode((Integer)tree.getNodeAttribute(nodeRef, "Number"));
                if (this.treeModel.getNodeHeight(nodeRef2) != tree.getNodeHeight(nodeRef)) {
                    throw new RuntimeException("Can only reconstruct states on treeModel given to constructor or a partitioned tree derived from it");
                }
                return this.getBranchMap().get(nodeRef2.getNumber()).toString();
            }
            catch (NullPointerException nullPointerException) {
                if (tree.isRoot(nodeRef)) {
                    return "Start";
                }
                NodeRef nodeRef3 = tree.getParent(nodeRef);
                int n = (Integer)tree.getNodeAttribute(nodeRef3, "Number");
                return this.getBranchMap().get(n).toString();
            }
        }
        return this.getBranchMap().get(nodeRef.getNumber()).toString();
    }

    public Integer[] getParentsArray() {
        Integer[] integerArray = new Integer[this.outbreak.size()];
        for (AbstractCase abstractCase : this.outbreak.getCases()) {
            if (abstractCase.wasEverInfected()) {
                integerArray[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = this.outbreak.getCaseIndex(((PartitionedTreeModel)this.treeModel).getInfector(abstractCase));
                continue;
            }
            integerArray[this.outbreak.getCaseIndex((AbstractCase)abstractCase)] = null;
        }
        return integerArray;
    }

    public AbstractCase getInfector(int n) {
        return ((PartitionedTreeModel)this.treeModel).getInfector(this.getOutbreak().getCase(n));
    }

    protected class Treelet
    extends FlexibleTree {
        private double zeroHeight;

        protected Treelet(FlexibleTree flexibleTree, double d) {
            super(flexibleTree);
            this.zeroHeight = d;
        }

        protected double getZeroHeight() {
            return this.zeroHeight;
        }

        protected void setZeroHeight(double d) {
            this.zeroHeight = this.zeroHeight;
        }
    }
}

