/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import java.util.Set;

public class AncestralTrait
implements Loggable {
    private final Tree tree;
    private final TreeTrait ancestralTrait;
    private final String name;
    private Set<String> leafSet = null;

    public AncestralTrait(String string, TreeTrait treeTrait, Tree tree, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        this.name = string;
        this.tree = tree;
        this.ancestralTrait = treeTrait;
        if (taxonList != null) {
            this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public String getAncestralState() {
        NodeRef nodeRef;
        if (this.leafSet != null) {
            nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
            if (nodeRef == null) {
                throw new RuntimeException("No node found that is MRCA of " + this.leafSet);
            }
        } else {
            nodeRef = this.tree.getRoot();
        }
        return this.ancestralTrait.getTraitString(this.tree, nodeRef);
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[]{new LogColumn.Abstract(this.name){

            @Override
            protected String getFormattedValue() {
                return AncestralTrait.this.getAncestralState();
            }
        }};
        return logColumnArray;
    }
}

