/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.continuous.GaussianProcessFromTree;
import dr.inference.distribution.DeterminentalPointProcessPrior;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.AdaptableSizeFastMatrixParameter;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixSizePrior;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.factorAnalysis.LatentFactorModelPrecisionGibbsOperator;
import dr.math.MathUtils;

public class FactorRJMCMCOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    GaussianProcessFromTree randomTree;
    AdaptableSizeFastMatrixParameter factors;
    AdaptableSizeFastMatrixParameter loadings;
    AdaptableSizeFastMatrixParameter cutoffs;
    AdaptableSizeFastMatrixParameter loadingsSparsity;
    AbstractModelLikelihood lfm;
    DeterminentalPointProcessPrior sparsityPrior;
    Likelihood loadingsPrior;
    int chainLength;
    CompoundParameter traitsTemp;
    double sizeParam;
    private double[] separator;
    SimpleMCMCOperator loadingsOperator;
    SimpleMCMCOperator factorOperator;
    SimpleMCMCOperator sparsityOperator;
    SimpleMCMCOperator NOp;
    AdaptableSizeFastMatrixParameter storedFactors;
    AdaptableSizeFastMatrixParameter storedLoadings;
    AdaptableSizeFastMatrixParameter storedCutoffs;
    AdaptableSizeFastMatrixParameter storedLoadingsSparsity;
    MatrixSizePrior rowPrior;
    LatentFactorModelPrecisionGibbsOperator precisionGibbsOperator;
    private final int BASE_SIZE = 1000;
    private final double MIN_WEIGHT = 0.01;
    private int callCount = 0;
    double callWeighting = 1.0;
    public static final boolean DEBUG = false;

    public FactorRJMCMCOperator(double d, double d2, int n, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter2, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter3, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter4, AbstractModelLikelihood abstractModelLikelihood, DeterminentalPointProcessPrior determinentalPointProcessPrior, Likelihood likelihood, SimpleMCMCOperator simpleMCMCOperator, SimpleMCMCOperator simpleMCMCOperator2, SimpleMCMCOperator simpleMCMCOperator3, SimpleMCMCOperator simpleMCMCOperator4, MatrixSizePrior matrixSizePrior, LatentFactorModelPrecisionGibbsOperator latentFactorModelPrecisionGibbsOperator) {
        this.setWeight(d);
        this.factors = adaptableSizeFastMatrixParameter;
        this.loadings = adaptableSizeFastMatrixParameter2;
        this.cutoffs = adaptableSizeFastMatrixParameter3;
        this.loadingsSparsity = adaptableSizeFastMatrixParameter4;
        this.sparsityPrior = determinentalPointProcessPrior;
        this.lfm = abstractModelLikelihood;
        this.sizeParam = d2;
        this.chainLength = n;
        this.NOp = simpleMCMCOperator4;
        if (adaptableSizeFastMatrixParameter != null) {
            this.storedFactors = new AdaptableSizeFastMatrixParameter(adaptableSizeFastMatrixParameter.getId() + ".stored", 1, 1, adaptableSizeFastMatrixParameter.getMaxRowDimension(), adaptableSizeFastMatrixParameter.getMaxColumnDimension(), 1.0, false);
        }
        this.storedLoadings = new AdaptableSizeFastMatrixParameter(adaptableSizeFastMatrixParameter2.getId() + ".stored", 1, 1, adaptableSizeFastMatrixParameter2.getMaxRowDimension(), adaptableSizeFastMatrixParameter2.getMaxColumnDimension(), 1.0, false);
        if (adaptableSizeFastMatrixParameter3 != null) {
            this.storedCutoffs = new AdaptableSizeFastMatrixParameter(adaptableSizeFastMatrixParameter3.getId() + ".stored", 1, 1, adaptableSizeFastMatrixParameter3.getMaxRowDimension(), adaptableSizeFastMatrixParameter3.getMaxColumnDimension(), 1.0, false);
        }
        if (adaptableSizeFastMatrixParameter4 != null) {
            this.storedLoadingsSparsity = new AdaptableSizeFastMatrixParameter(adaptableSizeFastMatrixParameter4.getId() + ".stored", 1, 1, adaptableSizeFastMatrixParameter4.getMaxRowDimension(), adaptableSizeFastMatrixParameter4.getMaxColumnDimension(), 1.0, false);
        }
        this.loadingsOperator = simpleMCMCOperator;
        this.factorOperator = simpleMCMCOperator2;
        this.sparsityOperator = simpleMCMCOperator3;
        this.rowPrior = matrixSizePrior;
        this.loadingsPrior = likelihood;
        this.precisionGibbsOperator = latentFactorModelPrecisionGibbsOperator;
        this.storeDimensions();
    }

    @Override
    public String getOperatorName() {
        return "FactorRJMCMCOperator";
    }

    @Override
    public double doOperation() {
        boolean bl = true;
        if (this.callCount < 1000 || bl) {
            this.performOperation();
        } else {
            this.callWeighting *= 0.99;
            if (this.callWeighting < 0.01) {
                this.callWeighting = 0.01;
            }
            if (this.callWeighting > MathUtils.nextDouble()) {
                this.performOperation();
            }
        }
        ++this.callCount;
        return 0.0;
    }

    private void performOperation() {
        boolean bl;
        String string = "";
        double d = MathUtils.nextDouble();
        double d2 = 0.0;
        double d3 = this.lfm.getLogLikelihood() * (1.0 - this.sizeParam) + this.rowPrior.getSizeLogLikelihood();
        this.storeDimensions();
        this.storeValues();
        int n = this.loadings.getColumnDimension();
        if ((d > 0.5 || n == 1) && n != this.loadings.getMaxColumnDimension()) {
            if (this.loadings.getColumnDimension() == 1) {
                d2 = -Math.log(2.0);
            }
            if (this.loadings.getColumnDimension() == this.loadings.getMaxColumnDimension() - 1) {
                d2 = Math.log(2.0);
            }
            if (this.factors != null) {
                this.factors.setRowDimension(this.factors.getRowDimension() + 1);
            }
            this.loadings.setColumnDimension(this.loadings.getColumnDimension() + 1);
            if (this.loadingsSparsity != null) {
                this.loadingsSparsity.setColumnDimension(this.loadingsSparsity.getColumnDimension() + 1);
            }
            if (this.cutoffs != null) {
                this.cutoffs.setColumnDimension(this.cutoffs.getColumnDimension() + 1);
            }
            bl = true;
        } else {
            if (this.loadings.getColumnDimension() == this.loadings.getMaxColumnDimension()) {
                d2 = -Math.log(2.0);
            }
            if (n == 2) {
                d2 = Math.log(2.0);
            }
            if (this.factors != null) {
                this.factors.setRowDimension(this.factors.getRowDimension() - 1);
            }
            this.loadings.setColumnDimension(this.loadings.getColumnDimension() - 1);
            if (this.loadingsSparsity != null) {
                this.loadingsSparsity.setColumnDimension(this.loadingsSparsity.getColumnDimension() - 1);
            }
            if (this.cutoffs != null) {
                this.cutoffs.setColumnDimension(this.cutoffs.getColumnDimension() - 1);
            }
            bl = false;
        }
        this.lfm.acceptModelState();
        if (this.sparsityPrior != null) {
            this.sparsityPrior.acceptModelState();
        }
        this.iterate();
        string = "";
        double d4 = this.lfm.getLogLikelihood() * (1.0 - this.sizeParam) + this.rowPrior.getSizeLogLikelihood();
        d = MathUtils.nextDouble();
        double d5 = d2 + d4 - d3;
        d5 = Math.min(Math.exp(d5), 1.0);
        boolean bl2 = false;
        if (!(!(d < d5) || bl2 && bl)) {
            this.lfm.acceptModelState();
            this.lfm.makeDirty();
            if (this.sparsityPrior != null) {
                this.sparsityPrior.acceptModelState();
                this.sparsityPrior.makeDirty();
            }
            if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                ((AbstractModelLikelihood)this.loadingsPrior).acceptModelState();
                this.loadingsPrior.makeDirty();
            }
        } else {
            this.restoreDimensions();
            this.restoreValues();
            if (this.sparsityPrior != null) {
                this.sparsityPrior.makeDirty();
            }
            this.lfm.makeDirty();
            if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                this.loadingsPrior.makeDirty();
            }
            if (this.factors != null) {
                this.factors.storeParameterValues();
            }
            this.loadings.storeParameterValues();
            if (this.loadingsSparsity != null) {
                this.loadingsSparsity.storeParameterValues();
            }
            if (this.cutoffs != null) {
                this.cutoffs.storeParameterValues();
            }
            this.lfm.acceptModelState();
            this.lfm.storeModelState();
        }
    }

    private void iterate() {
        if (this.factorOperator != null) {
            this.factorOperator.setPathParameter(this.sizeParam);
        }
        if (this.loadingsOperator instanceof GibbsOperator) {
            this.loadingsOperator.setPathParameter(this.sizeParam);
        }
        if (this.precisionGibbsOperator != null) {
            this.precisionGibbsOperator.setPathParameter(this.sizeParam);
        }
        this.separator = new double[4];
        double d = 0.0;
        if (this.factorOperator != null) {
            d = this.factors.getColumnDimension() * this.chainLength;
        }
        double d2 = 0.0;
        d2 = this.loadingsOperator instanceof GibbsOperator ? (double)(this.loadings.getColumnDimension() * this.chainLength) : (double)(this.loadings.getColumnDimension() * this.loadings.getRowDimension() * this.chainLength);
        double d3 = 0.0;
        if (this.sparsityOperator != null) {
            d3 = this.loadings.getRowDimension() * this.loadings.getColumnDimension() * this.chainLength;
        }
        double d4 = 0.0;
        if (this.NOp != null) {
            d4 = this.loadings.getRowDimension() * this.loadings.getColumnDimension() * this.chainLength;
        }
        double d5 = 0.0;
        if (this.precisionGibbsOperator != null) {
            d5 = this.chainLength;
        }
        double d6 = d + d2 + d3 + d4 + d5;
        this.separator[0] = d / d6;
        this.separator[1] = (d + d2) / d6;
        this.separator[2] = (d + d2 + d3) / d6;
        this.separator[3] = (d + d2 + d3 + d4) / d6;
        int n = 0;
        while ((double)n < d6) {
            double d7;
            double d8 = MathUtils.nextDouble();
            if (d8 < this.separator[0]) {
                this.factorOperator.doOperation();
            } else if (d8 < this.separator[1]) {
                if (this.loadingsOperator instanceof GibbsOperator) {
                    this.loadingsOperator.doOperation();
                } else {
                    this.lfm.storeModelState();
                    if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                        ((AbstractModelLikelihood)this.loadingsPrior).storeModelState();
                    }
                    d7 = -this.lfm.getLogLikelihood() * this.sizeParam - this.loadingsPrior.getLogLikelihood();
                    d7 += this.loadingsOperator.doOperation();
                    d7 += this.lfm.getLogLikelihood() * this.sizeParam + this.loadingsPrior.getLogLikelihood();
                    d7 = Math.min(1.0, Math.exp(d7));
                    if (MathUtils.nextDouble() > d7 || Double.isNaN(this.loadingsPrior.getLogLikelihood())) {
                        this.lfm.restoreModelState();
                        if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                            ((AbstractModelLikelihood)this.loadingsPrior).restoreModelState();
                        }
                    } else {
                        this.lfm.acceptModelState();
                        if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                            ((AbstractModelLikelihood)this.loadingsPrior).acceptModelState();
                        }
                    }
                }
            } else if (d8 < this.separator[2]) {
                this.lfm.storeModelState();
                this.sparsityPrior.storeModelState();
                d7 = -this.lfm.getLogLikelihood() * this.sizeParam - this.sparsityPrior.getLogLikelihood();
                d7 += this.sparsityOperator.doOperation();
                d7 += this.lfm.getLogLikelihood() * this.sizeParam + this.sparsityPrior.getLogLikelihood();
                d7 = Math.min(1.0, Math.exp(d7));
                if (MathUtils.nextDouble() > d7 || Double.isNaN(this.sparsityPrior.getLogLikelihood())) {
                    this.lfm.restoreModelState();
                    this.sparsityPrior.restoreModelState();
                } else {
                    this.lfm.acceptModelState();
                    this.sparsityPrior.acceptModelState();
                }
            } else if (d8 < this.separator[3]) {
                this.lfm.storeModelState();
                if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                    ((AbstractModelLikelihood)this.loadingsPrior).storeModelState();
                }
                d7 = -this.lfm.getLogLikelihood() * this.sizeParam - this.loadingsPrior.getLogLikelihood();
                d7 += this.NOp.doOperation();
                d7 += this.lfm.getLogLikelihood() * this.sizeParam + this.loadingsPrior.getLogLikelihood();
                d7 = Math.min(1.0, Math.exp(d7));
                if (MathUtils.nextDouble() > d7 || Double.isNaN(this.loadingsPrior.getLogLikelihood())) {
                    this.lfm.restoreModelState();
                    if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                        ((AbstractModelLikelihood)this.loadingsPrior).restoreModelState();
                    }
                } else {
                    this.lfm.acceptModelState();
                    if (this.loadingsPrior instanceof AbstractModelLikelihood) {
                        ((AbstractModelLikelihood)this.loadingsPrior).acceptModelState();
                    }
                }
            } else if (this.precisionGibbsOperator != null) {
                this.precisionGibbsOperator.doOperation();
            }
            ++n;
        }
        if (this.factorOperator != null) {
            this.factorOperator.setPathParameter(1.0);
        }
        if (this.loadingsOperator instanceof GibbsOperator) {
            this.loadingsOperator.setPathParameter(1.0);
        }
        if (this.precisionGibbsOperator != null) {
            this.precisionGibbsOperator.setPathParameter(1.0);
        }
    }

    private void storeDimensions() {
        if (this.factors != null) {
            this.storedFactors.setRowDimension(this.factors.getRowDimension());
            this.storedFactors.setColumnDimension(this.factors.getColumnDimension());
        }
        this.storedLoadings.setRowDimension(this.loadings.getRowDimension());
        this.storedLoadings.setColumnDimension(this.loadings.getColumnDimension());
        if (this.loadingsSparsity != null) {
            this.storedLoadingsSparsity.setRowDimension(this.loadingsSparsity.getRowDimension());
            this.storedLoadingsSparsity.setColumnDimension(this.loadingsSparsity.getColumnDimension());
        }
        if (this.cutoffs != null) {
            this.storedCutoffs.setRowDimension(this.cutoffs.getRowDimension());
            this.storedCutoffs.setColumnDimension(this.cutoffs.getColumnDimension());
        }
    }

    private void restoreDimensions() {
        if (this.factors != null) {
            this.factors.setRowDimension(this.storedFactors.getRowDimension());
            this.factors.setColumnDimension(this.storedFactors.getColumnDimension());
        }
        this.loadings.setRowDimension(this.storedLoadings.getRowDimension());
        this.loadings.setColumnDimension(this.storedLoadings.getColumnDimension());
        if (this.loadingsSparsity != null) {
            this.loadingsSparsity.setRowDimension(this.storedLoadingsSparsity.getRowDimension());
            this.loadingsSparsity.setColumnDimension(this.storedLoadingsSparsity.getColumnDimension());
        }
        if (this.cutoffs != null) {
            this.cutoffs.setRowDimension(this.storedCutoffs.getRowDimension());
            this.cutoffs.setColumnDimension(this.storedCutoffs.getColumnDimension());
        }
    }

    private void storeValues() {
        int n;
        if (this.factors != null) {
            for (n = 0; n < this.factors.getDimension(); ++n) {
                this.storedFactors.setParameterValue(n, this.factors.getParameterValue(n));
            }
        }
        for (n = 0; n < this.loadings.getDimension(); ++n) {
            this.storedLoadings.setParameterValue(n, this.loadings.getParameterValue(n));
            if (this.loadingsSparsity != null) {
                this.storedLoadingsSparsity.setParameterValue(n, this.loadingsSparsity.getParameterValue(n));
            }
            if (this.storedCutoffs == null) continue;
            this.storedCutoffs.setParameterValue(n, this.cutoffs.getParameterValue(n));
        }
    }

    private void restoreValues() {
        int n;
        if (this.factors != null) {
            for (n = 0; n < this.factors.getDimension(); ++n) {
                this.factors.setParameterValue(n, this.storedFactors.getParameterValue(n));
            }
        }
        for (n = 0; n < this.loadings.getDimension(); ++n) {
            this.loadings.setParameterValue(n, this.storedLoadings.getParameterValue(n));
            if (this.loadingsSparsity != null) {
                this.loadingsSparsity.setParameterValue(n, this.storedLoadingsSparsity.getParameterValue(n));
            }
            if (this.cutoffs == null) continue;
            this.cutoffs.setParameterValue(n, this.storedCutoffs.getParameterValue(n));
        }
    }
}

