/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.DrugEra;

public class DrugEraCheck
extends BaseCorelatedCriteriaCheck {
    private static final String MISSING_DAYS_INFO = "Using drug era at %s criteria on medical claims (e.g., biologics) may not be accurate due to missing days supply information";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.INFO;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        Operations.match(criteria.criteria).isA(DrugEra.class).then(c -> Operations.match(criteria).when(drugEra -> Objects.isNull(drugEra.startWindow.start) && Objects.isNull(drugEra.startWindow.end) && Objects.isNull(drugEra.endWindow.start)).then(() -> reporter.add(MISSING_DAYS_INFO, groupName)));
    }
}

