/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.List;
import java.util.Objects;
import org.ohdsi.circe.check.Warning;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.warnings.IncompleteRuleWarning;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.InclusionRule;

public class IncompleteRuleCheck
extends BaseCheck {
    @Override
    protected WarningReporter getReporter(WarningSeverity severity, List<Warning> warnings) {
        return (name, params) -> warnings.add(new IncompleteRuleWarning(this.defineSeverity(), name));
    }

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        if (Objects.nonNull(expression.inclusionRules)) {
            expression.inclusionRules.forEach(rule -> this.checkInclusionRule((InclusionRule)rule, reporter));
        }
    }

    private void checkInclusionRule(InclusionRule rule, WarningReporter reporter) {
        if (rule.expression.isEmpty()) {
            reporter.add(rule.name, new Object[0]);
        }
    }
}

