/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class ObservationSqlBuilder<T extends Observation>
extends CriteriaSqlBuilder<T> {
    private static final String OBSERVATION_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/observation.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("o.person_id", "o.observation_id", "o.observation_concept_id", "o.visit_occurrence_id", "o.value_as_number"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return OBSERVATION_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.observation_concept_id";
            }
            case VALUE_AS_NUMBER: {
                return "C.value_as_number";
            }
            case DURATION: {
                return "CAST(1 as int)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Observation:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((Observation)criteria).codesetId, "o.observation_concept_id", ((Observation)criteria).observationSourceConcept, "o.observation_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((Observation)criteria).first != null && ((Observation)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY o.person_id ORDER BY o.observation_date, o.observation_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((Observation)criteria).observationType != null && ((Observation)criteria).observationType.length > 0) {
            selectCols.add("o.observation_type_concept_id");
        }
        if (((Observation)criteria).valueAsString != null) {
            selectCols.add("o.value_as_string");
        }
        if (((Observation)criteria).valueAsConcept != null && ((Observation)criteria).valueAsConcept.length > 0) {
            selectCols.add("o.value_as_concept_id");
        }
        if (((Observation)criteria).qualifier != null && ((Observation)criteria).qualifier.length > 0) {
            selectCols.add("o.qualifier_concept_id");
        }
        if (((Observation)criteria).unit != null && ((Observation)criteria).unit.length > 0) {
            selectCols.add("o.unit_concept_id");
        }
        if (((Observation)criteria).providerSpecialty != null && ((Observation)criteria).providerSpecialty.length > 0) {
            selectCols.add("o.provider_id");
        }
        if (((Observation)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((Observation)criteria).dateAdjustment, ((Observation)criteria).dateAdjustment.startWith == DateAdjustment.DateType.START_DATE ? "o.observation_date" : "DATEADD(day,1,o.observation_date)", ((Observation)criteria).dateAdjustment.endWith == DateAdjustment.DateType.START_DATE ? "o.observation_date" : "DATEADD(day,1,o.observation_date)"));
        } else {
            selectCols.add("o.observation_date as start_date, DATEADD(day,1,o.observation_date) as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((Observation)criteria).age != null || ((Observation)criteria).gender != null && ((Observation)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((Observation)criteria).visitType != null && ((Observation)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((Observation)criteria).providerSpecialty != null && ((Observation)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<Long> conceptIds;
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((Observation)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((Observation)criteria).occurrenceStartDate));
        }
        if (((Observation)criteria).observationType != null && ((Observation)criteria).observationType.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).observationType);
            whereClauses.add(String.format("C.observation_type_concept_id %s in (%s)", ((Observation)criteria).observationTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Observation)criteria).valueAsNumber != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.value_as_number", ((Observation)criteria).valueAsNumber, ".4f"));
        }
        if (((Observation)criteria).valueAsString != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.value_as_string", ((Observation)criteria).valueAsString));
        }
        if (((Observation)criteria).valueAsConcept != null && ((Observation)criteria).valueAsConcept.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).valueAsConcept);
            whereClauses.add(String.format("C.value_as_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Observation)criteria).qualifier != null && ((Observation)criteria).qualifier.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).qualifier);
            whereClauses.add(String.format("C.qualifier_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Observation)criteria).unit != null && ((Observation)criteria).unit.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).unit);
            whereClauses.add(String.format("C.unit_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Observation)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.start_date) - P.year_of_birth", ((Observation)criteria).age));
        }
        if (((Observation)criteria).gender != null && ((Observation)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).gender), (String)",")));
        }
        if (((Observation)criteria).providerSpecialty != null && ((Observation)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).providerSpecialty), (String)",")));
        }
        if (((Observation)criteria).visitType != null && ((Observation)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Observation)criteria).visitType), (String)",")));
        }
        return whereClauses;
    }
}

