/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.mcmc;

import dr.inference.loggers.ArrayLogFormatter;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.Logger;
import dr.inference.loggers.MCLogger;
import dr.inference.mcmc.MCMC;
import dr.inference.mcmc.MCMCOptions;
import dr.inference.model.Likelihood;
import dr.inference.operators.OperatorSchedule;
import dr.inference.trace.Trace;
import dr.inference.trace.TraceCorrelation;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import org.ohdsi.mcmc.Analysis;

public class Runner {
    private final Likelihood joint;
    private final OperatorSchedule schedule;
    private final Logger[] logger;
    final long chainLength;
    final int burnIn;
    final int subSampleFrequency;
    int consoleWidth = 175;

    public Runner(Analysis analysis, int n, int n2, int n3, double d) {
        MathUtils.setSeed((long)Math.round(d));
        this.joint = analysis.getJoint();
        this.schedule = analysis.getSchedule();
        this.logger = this.getLogger(analysis.getLoggerColumns(), n3);
        this.chainLength = n;
        this.burnIn = n2;
        this.subSampleFrequency = n3;
    }

    private Logger[] getLogger(List<Loggable> list, int n) {
        ArrayLogFormatter arrayLogFormatter = new ArrayLogFormatter(false);
        MCLogger mCLogger = new MCLogger((LogFormatter)arrayLogFormatter, (long)n, false);
        for (Loggable loggable : list) {
            mCLogger.add(loggable);
        }
        Logger logger = new Logger(){

            public void startLogging() {
            }

            public void log(long l) {
                if (l % 10000L == 0L) {
                    this.progressPercentage(l, Runner.this.chainLength);
                }
            }

            private void progressPercentage(long l, long l2) {
                if (l > l2) {
                    throw new IllegalArgumentException();
                }
                int n = Runner.this.consoleWidth - 10;
                int n2 = (int)(100L * l / l2);
                int n3 = (int)((long)n * l / l2);
                String string = "|" + new String(new char[n3]).replace('\u0000', '=') + new String(new char[n - n3]).replace('\u0000', ' ') + "|";
                System.out.print("\r" + string + " " + n2 + "%");
                if (l == l2) {
                    System.out.print("\n");
                }
            }

            public void stopLogging() {
            }
        };
        return new Logger[]{mCLogger, logger};
    }

    public void run() {
        MCMC mCMC = new MCMC("mcmc1");
        mCMC.setShowOperatorAnalysis(false);
        mCMC.init(Runner.getOptions(this.chainLength), this.joint, this.schedule, this.logger);
        mCMC.run();
    }

    public void setConsoleWidth(int n) {
        this.consoleWidth = n;
    }

    public String[] getParameterNames() {
        List<Trace> list = this.getTraces(this.logger[0]);
        String[] stringArray = new String[list.size() - 1];
        for (int i = 1; i < list.size(); ++i) {
            Trace trace = list.get(i);
            stringArray[i - 1] = trace.getName();
        }
        return stringArray;
    }

    public double[] getTrace(int n) {
        List<Trace> list = this.getTraces(this.logger[0]);
        if (n < 0 || n >= list.size()) {
            throw new RuntimeException("Parameter index out of range. Maximum index = " + list.size());
        }
        Trace trace = list.get(n);
        int n2 = this.burnIn / this.subSampleFrequency + 1;
        List list2 = trace.getValues(n2, trace.getValueCount());
        double[] dArray = new double[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            dArray[i] = (Double)list2.get(i);
        }
        return dArray;
    }

    public void processSamples() {
        List<Trace> list = this.getTraces(this.logger[0]);
        for (int i = 1; i < list.size(); ++i) {
            Trace trace = list.get(i);
            int n = this.burnIn / this.subSampleFrequency + 1;
            List list2 = trace.getValues(n, trace.getValueCount());
            TraceCorrelation traceCorrelation = new TraceCorrelation(list2, trace.getTraceType(), (long)this.subSampleFrequency);
            System.out.println(trace.getName() + " " + traceCorrelation.getMean() + " " + traceCorrelation.getStdError() + " " + traceCorrelation.getESS() + " " + traceCorrelation.getSize());
        }
    }

    private static MCMCOptions getOptions(long l) {
        boolean bl = true;
        long l2 = l / 100L;
        double d = 0.234;
        boolean bl2 = false;
        double d2 = 1.0;
        long l3 = 1000L;
        double d3 = 0.1;
        int n = 1;
        return new MCMCOptions(l, l3, n, d3, bl, l2, d, bl2, d2);
    }

    private List<Trace> getTraces(Logger logger) {
        ArrayList<Trace> arrayList = new ArrayList<Trace>();
        if (logger instanceof MCLogger) {
            for (LogFormatter logFormatter : ((MCLogger)logger).getFormatters()) {
                if (!(logFormatter instanceof ArrayLogFormatter)) continue;
                arrayList.addAll(((ArrayLogFormatter)logFormatter).getTraces());
            }
        }
        return arrayList;
    }
}

