/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.likelihood.EmpiricalModelLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;
import org.ohdsi.metaAnalysis.ExtendingEmpiricalDataModel;

public class ProfileNormalAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter beta;
    private final OperatorSchedule schedule;

    public ProfileNormalAnalysis(EmpiricalDataModel empiricalDataModel, double d, double d2, double d3) {
        this.likelihood = new EmpiricalModelLikelihood("likelihood", empiricalDataModel);
        this.beta = empiricalDataModel.getCompoundParameter();
        for (int i = 0; i < this.beta.getDimension(); ++i) {
            this.beta.setParameterValue(i, d3);
        }
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood((Distribution)new NormalDistribution(d, d2));
        distributionLikelihood.addData((Attribute)this.beta);
        this.prior = distributionLikelihood;
        this.prior.setId("prior");
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.joint.setId("joint");
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double d4 = 1.0;
        AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (Parameter parameter : empiricalDataModel.getIndividualParameters()) {
            this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(parameter, null, 0.75, boundaryCondition, d4, adaptationMode));
        }
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> arrayList = new ArrayList<Loggable>();
        arrayList.add((Loggable)this.likelihood);
        arrayList.add((Loggable)this.prior);
        arrayList.add((Loggable)this.beta);
        return arrayList;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] stringArray) {
        int n = 1100000;
        int n2 = 100000;
        int n3 = 1000;
        ExtendingEmpiricalDataModel extendingEmpiricalDataModel = new ExtendingEmpiricalDataModel("profile.txt");
        ProfileNormalAnalysis profileNormalAnalysis = new ProfileNormalAnalysis(extendingEmpiricalDataModel, 0.0, 10.0, 0.0);
        Runner runner = new Runner(profileNormalAnalysis, n, n2, n3, 666.0);
        runner.run();
        runner.processSamples();
    }
}

