/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.list.tlong.AbstractLongList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class LongFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory1D dense = new LongFactory1D();
    public static final LongFactory1D sparse = new LongFactory1D();

    protected LongFactory1D() {
    }

    public LongMatrix1D append(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2) {
        LongMatrix1D longMatrix1D3 = this.make((int)(longMatrix1D.size() + longMatrix1D2.size()));
        longMatrix1D3.viewPart(0, (int)longMatrix1D.size()).assign(longMatrix1D);
        longMatrix1D3.viewPart((int)longMatrix1D.size(), (int)longMatrix1D2.size()).assign(longMatrix1D2);
        return longMatrix1D3;
    }

    public LongMatrix1D ascending(int n) {
        LongFunctions longFunctions = LongFunctions.longFunctions;
        return this.descending(n).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(n)));
    }

    public LongMatrix1D descending(int n) {
        LongMatrix1D longMatrix1D = this.make(n);
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            longMatrix1D.setQuick(n3, n2++);
        }
        return longMatrix1D;
    }

    public LongMatrix1D make(long[] lArray) {
        if (this == sparse) {
            return new SparseLongMatrix1D(lArray);
        }
        return new DenseLongMatrix1D(lArray);
    }

    public LongMatrix1D make(LongMatrix1D[] longMatrix1DArray) {
        if (longMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < longMatrix1DArray.length; ++i) {
            n = (int)((long)n + longMatrix1DArray[i].size());
        }
        LongMatrix1D longMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < longMatrix1DArray.length; ++i) {
            longMatrix1D.viewPart(n, (int)longMatrix1DArray[i].size()).assign(longMatrix1DArray[i]);
            n = (int)((long)n + longMatrix1DArray[i].size());
        }
        return longMatrix1D;
    }

    public LongMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseLongMatrix1D(n);
        }
        return new DenseLongMatrix1D(n);
    }

    public LongMatrix1D make(int n, long l) {
        return this.make(n).assign(l);
    }

    public LongMatrix1D make(AbstractLongList abstractLongList) {
        int n = abstractLongList.size();
        LongMatrix1D longMatrix1D = this.make(n);
        int n2 = n;
        while (--n2 >= 0) {
            longMatrix1D.set(n2, abstractLongList.get(n2));
        }
        return longMatrix1D;
    }

    public LongMatrix1D random(int n) {
        return this.make(n).assign(LongFunctions.random());
    }

    public LongMatrix1D repeat(LongMatrix1D longMatrix1D, int n) {
        int n2 = (int)longMatrix1D.size();
        LongMatrix1D longMatrix1D2 = this.make(n * n2);
        int n3 = n;
        while (--n3 >= 0) {
            longMatrix1D2.viewPart(n2 * n3, n2).assign(longMatrix1D);
        }
        return longMatrix1D2;
    }

    public LongMatrix1D sample(int n, int n2, int n3) {
        double d = 1.0E-9;
        if ((double)n3 < 0.0 - d || (double)n3 > 1.0 + d) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 1) {
            n3 = 1;
        }
        LongMatrix1D longMatrix1D = this.make(n);
        int n4 = Math.round(n * n3);
        if (n4 == 0) {
            return longMatrix1D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n4, n, new DoubleMersenneTwister());
        int n5 = n;
        while (--n5 >= 0) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            longMatrix1D.set(n5, n2);
        }
        return longMatrix1D;
    }

    public LongArrayList toList(LongMatrix1D longMatrix1D) {
        int n = (int)longMatrix1D.size();
        LongArrayList longArrayList = new LongArrayList(n);
        longArrayList.setSize(n);
        int n2 = n;
        while (--n2 >= 0) {
            longArrayList.set(n2, longMatrix1D.get(n2));
        }
        return longArrayList;
    }
}

