/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.StmProcessingFactory;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.satoolkit.special.PreprocessingSpecification;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.structural.BsmSpecification;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import java.util.Map;
import java.util.Objects;

public class StmSpecification
implements ISaSpecification,
Cloneable {
    private PreprocessingSpecification preprocessingSpec = new PreprocessingSpecification();
    private BsmSpecification decompositionSpec;
    private SaBenchmarkingSpec benchmarkingSpec;

    public StmSpecification() {
        this.preprocessingSpec.dtype = TradingDaysType.TradingDays;
        this.preprocessingSpec.ltype = LengthOfPeriodType.LeapYear;
        this.decompositionSpec = new BsmSpecification();
        this.benchmarkingSpec = new SaBenchmarkingSpec();
    }

    public PreprocessingSpecification getPreprocessingSpec() {
        return this.preprocessingSpec;
    }

    public BsmSpecification getDecompositionSpec() {
        return this.decompositionSpec;
    }

    public SaBenchmarkingSpec getBenchmarkingSpec() {
        return this.benchmarkingSpec;
    }

    public void setPreprocessingSpec(PreprocessingSpecification spec) {
        this.preprocessingSpec = spec;
    }

    public void setDecompositionSpec(BsmSpecification spec) {
        this.decompositionSpec = spec;
    }

    public void setBenchmarkingSpec(SaBenchmarkingSpec spec) {
        this.benchmarkingSpec = spec;
    }

    public String toString() {
        return StmProcessingFactory.DESCRIPTOR.name;
    }

    @Override
    public StmSpecification clone() {
        try {
            StmSpecification spec = (StmSpecification)super.clone();
            if (this.preprocessingSpec != null) {
                spec.preprocessingSpec = this.preprocessingSpec.clone();
            }
            if (this.decompositionSpec != null) {
                spec.decompositionSpec = this.decompositionSpec.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(StmSpecification other) {
        return Objects.equals(this.preprocessingSpec, other.preprocessingSpec) && Objects.equals(this.decompositionSpec, other.decompositionSpec) && Objects.equals(this.benchmarkingSpec, other.benchmarkingSpec);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof StmSpecification && this.equals((StmSpecification)obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.preprocessingSpec);
        hash = 97 * hash + Objects.hashCode(this.decompositionSpec);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet p;
        InformationSet info = new InformationSet();
        if (this.preprocessingSpec != null && (p = this.preprocessingSpec.write(verbose)) != null) {
            info.set("preprocessing", p);
        }
        if (this.decompositionSpec != null && (p = this.decompositionSpec.write(verbose)) != null) {
            info.set("decomposition", p);
        }
        if (this.benchmarkingSpec != null && (p = this.benchmarkingSpec.write(verbose)) != null) {
            info.set("benchmarking", p);
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        InformationSet p = info.getSubSet("preprocessing");
        if (p != null && !this.preprocessingSpec.read(p)) {
            return false;
        }
        InformationSet d = info.getSubSet("decomposition");
        if (d != null && !this.decompositionSpec.read(d)) {
            return false;
        }
        InformationSet b = info.getSubSet("benchmarking");
        return b == null || this.benchmarkingSpec.read(b);
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        PreprocessingSpecification.fillDictionary(InformationSet.item(prefix, "preprocessing"), dic);
        BsmSpecification.fillDictionary(InformationSet.item(prefix, "decomposition"), dic);
        SaBenchmarkingSpec.fillDictionary(InformationSet.item(prefix, "benchmarking"), dic);
    }

    public IPreprocessor buildPreprocessor(ProcessingContext context) {
        return this.preprocessingSpec == null ? null : this.preprocessingSpec.build(context);
    }

    @Override
    public String toLongString() {
        return this.toString();
    }
}

