/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms.GeneticAlgorithm;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidFitness;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class AlgorithmGAPSteady
extends GeneticAlgorithm {
    GeneticIndividual[][] population;
    int[] tournament;
    int[] tournament2;
    double[] tournamentFitness;
    double[][] fitnessCache;
    double MUTATIONPROB;
    double MUTATIONAMPL;
    double MIGRATIONPROB;
    double GACROSSOVERPROB;
    double GAMUTATIONPROB;
    double LOCALOPTPROB;
    int LOCALOPTITER;
    double[] fitnessMark;
    double[] bestFitness;
    static Randomize rand;
    int GACROSSOVERID;
    int GPCROSSOVERID;
    int GAMUTATIONID;
    int GPMUTATIONID;
    int POPULATIONSIZE;
    int LOID;

    public AlgorithmGAPSteady(GeneticIndividual initialIndividual, int pPopSize, int pTourSize, double PM, double AMP, double PMG, double pGACrossoverProb, double pGAMutationProb, int pGenerations, double pLOptProb, int NOL, int IOL, Randomize r, int pGACrossoverID, int pGPCrossoverID, int pGAMutationID, int pGPMutationID) {
        System.out.println("POP=" + pPopSize + " tournament=" + pTourSize + " PM=" + PM + " AMP=" + AMP + " PMG=" + PMG + " pGACrossoverProb=" + pGACrossoverProb + " pGAMutationProb=" + pGAMutationProb + " PNPOP=" + pGenerations + " pLOptProb=" + pLOptProb + " NOL=" + NOL + " IOL=" + IOL);
        this.GACROSSOVERID = pGACrossoverID;
        this.GAMUTATIONID = pGAMutationID;
        this.GPCROSSOVERID = pGPCrossoverID;
        this.GPMUTATIONID = pGPMutationID;
        this.MUTATIONPROB = PM;
        this.MIGRATIONPROB = PMG;
        this.GACROSSOVERPROB = pGACrossoverProb;
        this.GAMUTATIONPROB = pGAMutationProb;
        this.POPULATIONSIZE = pGenerations;
        this.MUTATIONAMPL = AMP;
        this.LOCALOPTPROB = pLOptProb;
        this.LOCALOPTITER = NOL;
        this.LOID = IOL;
        rand = r;
        this.population = new GeneticIndividual[this.POPULATIONSIZE][pPopSize];
        this.tournament = new int[pTourSize];
        this.tournament2 = new int[pTourSize];
        this.tournamentFitness = new double[pTourSize];
        this.fitnessCache = new double[this.POPULATIONSIZE][pPopSize];
        this.fitnessMark = new double[this.POPULATIONSIZE];
        this.bestFitness = new double[this.POPULATIONSIZE];
        this.fitnessMark = new double[this.POPULATIONSIZE];
        this.bestFitness = new double[this.POPULATIONSIZE];
        try {
            for (int p = 0; p < this.POPULATIONSIZE; ++p) {
                this.fitnessMark[p] = 0.0;
                this.bestFitness[p] = 0.0;
                for (int i = 0; i < pPopSize; ++i) {
                    System.out.println("Inicialiting the population[" + i + "]");
                    this.population[p][i] = initialIndividual.clone();
                    this.population[p][i].Random();
                    this.fitnessCache[p][i] = this.population[p][i].fitness();
                    int n = p;
                    this.fitnessMark[n] = this.fitnessMark[n] + this.fitnessCache[p][i];
                    if (!(this.fitnessCache[p][i] < this.bestFitness[p]) && i != 0) continue;
                    this.bestFitness[p] = this.fitnessCache[p][i];
                }
            }
        }
        catch (invalidFitness f) {
            System.out.println("Unsupported fitness function");
        }
    }

    private void sortedInsertion(int x, double valueX, int[] tournament) {
        int pos;
        for (pos = 0; tournament[pos] >= 0 && valueX > this.tournamentFitness[pos] && pos < tournament.length; ++pos) {
        }
        if (pos == tournament.length) {
            return;
        }
        for (int i = tournament.length - 1; i > pos; --i) {
            tournament[i] = tournament[i - 1];
            this.tournamentFitness[i] = this.tournamentFitness[i - 1];
        }
        tournament[pos] = x;
        this.tournamentFitness[pos] = valueX;
    }

    @Override
    public GeneticIndividual evolve(int MAXITER) throws invalidCrossover, invalidMutation, invalidOptim {
        int pTourSize = this.tournament.length;
        System.out.println("Calculating " + MAXITER + " generations ");
        try {
            for (int i = 0; i < MAXITER; ++i) {
                if (i % 100 == 0) {
                    System.out.println("Generation=" + i);
                }
                for (int p = 0; p < this.population.length; ++p) {
                    int j;
                    for (j = 0; j < pTourSize; ++j) {
                        this.tournament[j] = -1;
                    }
                    for (j = 0; j < pTourSize; ++j) {
                        int ind = 0;
                        boolean hasBeenFound = false;
                        block6: do {
                            hasBeenFound = false;
                            ind = (int)(rand.Rand() * (double)this.population[p].length);
                            for (int k = 0; k < pTourSize; ++k) {
                                if (ind != this.tournament[k]) continue;
                                hasBeenFound = true;
                                continue block6;
                            }
                        } while (hasBeenFound);
                        this.sortedInsertion(ind, this.fitnessCache[p][ind], this.tournament);
                    }
                    int tc = rand.Rand() < this.GACROSSOVERPROB ? this.GACROSSOVERID : this.GPCROSSOVERID;
                    int tm = rand.Rand() < this.GAMUTATIONPROB ? this.GAMUTATIONID : this.GPMUTATIONID;
                    this.population[p][this.tournament[0]].crossover(this.population[p][this.tournament[1]], this.population[p][this.tournament[pTourSize - 2]], this.population[p][this.tournament[pTourSize - 1]], tc);
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][this.tournament[pTourSize - 2]].mutation(this.MUTATIONAMPL, tm);
                    }
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][this.tournament[pTourSize - 1]].mutation(this.MUTATIONAMPL, tm);
                    }
                    if (rand.Rand() < this.LOCALOPTPROB) {
                        this.population[p][this.tournament[pTourSize - 2]].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    if (rand.Rand() < this.LOCALOPTPROB) {
                        this.population[p][this.tournament[pTourSize - 1]].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    if (rand.Rand() < this.MIGRATIONPROB) {
                        int j2;
                        int lTheOutput = (int)(rand.Rand() * (double)this.population.length);
                        for (j2 = 0; j2 < pTourSize; ++j2) {
                            this.tournament2[j2] = -1;
                        }
                        for (j2 = 0; j2 < pTourSize; ++j2) {
                            int ind = 0;
                            boolean hasBeenFound = false;
                            block10: do {
                                hasBeenFound = false;
                                ind = (int)(rand.Rand() * (double)this.population[lTheOutput].length);
                                for (int k = 0; k < pTourSize; ++k) {
                                    if (ind != this.tournament2[k]) continue;
                                    hasBeenFound = true;
                                    continue block10;
                                }
                            } while (hasBeenFound);
                            this.sortedInsertion(ind, this.fitnessCache[lTheOutput][ind], this.tournament2);
                        }
                        this.population[lTheOutput][this.tournament2[pTourSize - 1]] = this.population[p][this.tournament[0]].clone();
                        this.fitnessCache[lTheOutput][this.tournament2[pTourSize - 1]] = this.fitnessCache[p][this.tournament[0]];
                    }
                    this.fitnessCache[p][this.tournament[pTourSize - 2]] = this.population[p][this.tournament[pTourSize - 2]].fitness();
                    this.fitnessCache[p][this.tournament[pTourSize - 1]] = this.population[p][this.tournament[pTourSize - 1]].fitness();
                    if (this.fitnessCache[p][this.tournament[pTourSize - 2]] < this.bestFitness[p]) {
                        this.bestFitness[p] = this.fitnessCache[p][this.tournament[pTourSize - 2]];
                    }
                    if (this.fitnessCache[p][this.tournament[pTourSize - 1]] < this.bestFitness[p]) {
                        this.bestFitness[p] = this.fitnessCache[p][this.tournament[pTourSize - 1]];
                    }
                    if (i % 100 != 0) continue;
                    this.fitnessMark[p] = 0.0;
                    for (int k = 0; k < this.fitnessCache[p].length; ++k) {
                        int n = p;
                        this.fitnessMark[n] = this.fitnessMark[n] + this.fitnessCache[p][k];
                    }
                    System.out.print("Best=" + this.bestFitness[p] + " Mean=" + this.fitnessMark[p] / (double)this.population[p].length);
                    int[] whichIsMyFamily = new int[this.population[p].length];
                    int numfamilias = 0;
                    for (int j3 = 0; j3 < this.population[p].length; ++j3) {
                        if (whichIsMyFamily[j3] > 0) continue;
                        whichIsMyFamily[j3] = ++numfamilias;
                        for (int k = j3; k < this.population[p].length; ++k) {
                            if (!this.population[p][j3].g.isRelated(this.population[p][k].g)) continue;
                            whichIsMyFamily[k] = numfamilias;
                        }
                    }
                    System.out.println(" Number of families=" + numfamilias);
                }
            }
        }
        catch (invalidFitness f) {
            System.out.println("Unsupported fitness function");
        }
        int pmin = 0;
        double minfit = 0.0;
        int imin = 0;
        boolean theFirst = true;
        for (int p = 0; p < this.population.length; ++p) {
            for (int i = 0; i < this.population[p].length; ++i) {
                double fit = this.fitnessCache[p][i];
                if (!(fit < minfit) && !theFirst) continue;
                theFirst = false;
                minfit = fit;
                imin = i;
                pmin = p;
            }
        }
        System.out.println("Minimum Fitness=" + minfit);
        return this.population[pmin][imin].clone();
    }
}

