/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.problem;

import java.io.IOException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.IProblem;
import keel.Algorithms.Neural_Networks.NNEP_Common.util.normalizer.Normalizer;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractEvaluator;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;

public abstract class ProblemEvaluator<I extends IIndividual>
extends AbstractEvaluator<I>
implements IProblem {
    protected DoubleTransposedDataSet unscaledTrainData;
    protected DoubleTransposedDataSet scaledTrainData;
    protected DoubleTransposedDataSet unscaledTestData;
    protected DoubleTransposedDataSet scaledTestData;
    protected boolean dataNormalized;
    protected Normalizer normalizer;
    protected Interval inputInterval;
    protected Interval outputInterval;
    protected boolean logTransformation;
    protected double[] unscaledMin;
    protected double[] unscaledMax;

    @Override
    public DoubleTransposedDataSet getTrainData() {
        if (this.dataNormalized) {
            return this.scaledTrainData;
        }
        return this.unscaledTrainData;
    }

    @Override
    public DoubleTransposedDataSet getTestData() {
        if (this.dataNormalized) {
            return this.scaledTestData;
        }
        return this.unscaledTestData;
    }

    @Override
    public boolean isDataNormalized() {
        return this.dataNormalized;
    }

    public void setDataNormalized(boolean normalizeData) {
        this.dataNormalized = normalizeData;
    }

    @Override
    public boolean isLogTransformation() {
        return this.logTransformation;
    }

    public void setLogTransformation(boolean logTransformation) {
        this.logTransformation = logTransformation;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public DoubleTransposedDataSet getUnscaledTestData() {
        return this.unscaledTestData;
    }

    public void setUnscaledTestData(DoubleTransposedDataSet unscaledTestData) {
        this.unscaledTestData = unscaledTestData;
    }

    public DoubleTransposedDataSet getUnscaledTrainData() {
        return this.unscaledTrainData;
    }

    public void setUnscaledTrainData(DoubleTransposedDataSet unscaledTrainData) {
        this.unscaledTrainData = unscaledTrainData;
    }

    @Override
    public Interval getInputInterval() {
        return this.inputInterval;
    }

    public void setInputInterval(Interval inputInterval) {
        this.inputInterval = inputInterval;
    }

    @Override
    public Interval getOutputInterval() {
        return this.outputInterval;
    }

    public void setOutputInterval(Interval outputRange) {
        this.outputInterval = outputRange;
    }

    public double[] getUnscaledMin() {
        return this.unscaledMin;
    }

    public double[] getUnscaledMax() {
        return this.unscaledMax;
    }

    public void configure(Configuration settings) {
        this.unscaledTrainData = new DoubleTransposedDataSet();
        this.unscaledTrainData.configure(settings.subset("train-data"));
        this.unscaledTestData = new DoubleTransposedDataSet();
        this.unscaledTestData.configure(settings.subset("test-data"));
        this.normalizer = new Normalizer();
        this.dataNormalized = settings.getBoolean("[@normalize-data]", false);
        this.logTransformation = settings.getBoolean("[@log-input-data]", false);
        if (this.dataNormalized) {
            Interval interval = new Interval();
            interval.configure(settings.subset("input-interval"));
            this.setInputInterval(interval);
            interval = new Interval();
            interval.configure(settings.subset("output-interval"));
            this.setOutputInterval(interval);
        }
    }

    public void readData() throws IOException, NumberFormatException {
        try {
            this.unscaledTrainData.read();
        }
        catch (IOException e) {
            throw new IOException("trainData IOException: " + e.getLocalizedMessage());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("trainData NumberFormatException: " + e.getLocalizedMessage());
        }
        try {
            this.unscaledTestData.read();
        }
        catch (IOException e) {
            throw new IOException("testData IOException: " + e.getLocalizedMessage());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("testData NumberFormatException: " + e.getLocalizedMessage());
        }
        this.normalizeData();
    }

    public void readData(byte[] schema, IDataset traindata, IDataset testdata) {
        try {
            this.unscaledTrainData.read(schema, traindata);
        }
        catch (DatasetException e1) {
            e1.printStackTrace();
        }
        try {
            this.unscaledTestData.read(schema, testdata);
        }
        catch (DatasetException e1) {
            e1.printStackTrace();
        }
        this.normalizeData();
    }

    private void normalizeData() {
        block16: {
            int j;
            block15: {
                int i;
                if (this.dataNormalized) {
                    this.unscaledMin = new double[this.unscaledTrainData.getNofvariables()];
                    this.unscaledMax = new double[this.unscaledTrainData.getNofvariables()];
                    for (int i2 = 0; i2 < this.unscaledTrainData.getNofvariables(); ++i2) {
                        this.unscaledMax[i2] = this.unscaledTrainData.getMaxValueOf(i2);
                        double temp = this.unscaledTestData.getMaxValueOf(i2);
                        if (temp > this.unscaledMax[i2]) {
                            this.unscaledMax[i2] = temp;
                        }
                        this.unscaledMin[i2] = this.unscaledTrainData.getMinValueOf(i2);
                        temp = this.unscaledTestData.getMinValueOf(i2);
                        if (!(temp < this.unscaledMin[i2])) continue;
                        this.unscaledMin[i2] = temp;
                    }
                    double[] scaledMin = new double[this.unscaledTrainData.getNofvariables()];
                    double[] scaledMax = new double[this.unscaledTrainData.getNofvariables()];
                    for (int i3 = 0; i3 < this.unscaledTrainData.getNofvariables(); ++i3) {
                        if (i3 < this.unscaledTrainData.getNofinputs()) {
                            scaledMin[i3] = this.inputInterval.getLeft();
                            scaledMax[i3] = this.inputInterval.getRight();
                            continue;
                        }
                        scaledMin[i3] = this.outputInterval.getLeft();
                        scaledMax[i3] = this.outputInterval.getRight();
                    }
                    this.scaledTrainData = this.unscaledTrainData.copy();
                    this.normalizer.scaleDS(this.scaledTrainData, scaledMax, scaledMin, this.unscaledMax, this.unscaledMin);
                    this.scaledTestData = this.unscaledTestData.copy();
                    this.normalizer.scaleDS(this.scaledTestData, scaledMax, scaledMin, this.unscaledMax, this.unscaledMin);
                }
                int newNofinputs = 0;
                boolean[] toRemove = this.unscaledTrainData.obtainConstantsInputs();
                for (int i4 = 0; i4 < toRemove.length; ++i4) {
                    if (toRemove[i4]) continue;
                    ++newNofinputs;
                }
                this.unscaledTrainData.removeInputs(toRemove, newNofinputs);
                this.unscaledTestData.removeInputs(toRemove, newNofinputs);
                if (!this.dataNormalized) break block15;
                this.scaledTrainData.removeInputs(toRemove, newNofinputs);
                this.scaledTestData.removeInputs(toRemove, newNofinputs);
                if (!this.logTransformation) break block16;
                double[][] inputs = this.scaledTrainData.getAllInputs();
                for (i = 0; i < inputs.length; ++i) {
                    for (j = 0; j < inputs[i].length; ++j) {
                        inputs[i][j] = Math.log(inputs[i][j]);
                    }
                }
                inputs = this.scaledTestData.getAllInputs();
                for (i = 0; i < inputs.length; ++i) {
                    for (j = 0; j < inputs[i].length; ++j) {
                        inputs[i][j] = Math.log(inputs[i][j]);
                    }
                }
                break block16;
            }
            if (this.logTransformation) {
                int i;
                double[][] inputs = this.unscaledTrainData.getAllInputs();
                for (i = 0; i < inputs.length; ++i) {
                    for (j = 0; j < inputs[i].length; ++j) {
                        inputs[i][j] = Math.log(inputs[i][j]);
                    }
                }
                inputs = this.unscaledTestData.getAllInputs();
                for (i = 0; i < inputs.length; ++i) {
                    for (j = 0; j < inputs[i].length; ++j) {
                        inputs[i][j] = Math.log(inputs[i][j]);
                    }
                }
            }
        }
    }

    @Override
    public abstract void evaluate(I var1);
}

