/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.C45Rules.Extra;
import keel.Algorithms.Rule_Learning.C45Rules.IncrementalMask;
import keel.Algorithms.Rule_Learning.C45Rules.Mask;
import keel.Algorithms.Rule_Learning.C45Rules.MyDataset;
import keel.Algorithms.Rule_Learning.C45Rules.Report;
import keel.Algorithms.Rule_Learning.C45Rules.Rule;
import keel.Algorithms.Rule_Learning.C45Rules.Ruleset;
import keel.Algorithms.Rule_Learning.C45Rules.SimpleRule;
import keel.Algorithms.Rule_Learning.C45Rules.Tree;
import keel.Algorithms.Rule_Learning.C45Rules.parseParameters;
import org.core.Fichero;
import org.core.Randomize;

class C45Rules {
    MyDataset train;
    MyDataset val;
    MyDataset test;
    String outputTr;
    String outputTst;
    String outputRules;
    private Tree root;
    private Ruleset[] classification_rules;
    private String default_class_name;
    Mask[] class_filter;
    Mask[] inverse_class_filter;
    private static int GREEDY = 0;
    private static int SA = 1;
    private int SearchAlgorithm;
    private int treshold;
    private double CF;
    private int Nmax = 10;
    private int max_trials = 5;
    private double mu = 0.5;
    private double phi = 0.5;
    private double alpha = 0.5;
    Randomize rand;

    private Vector getRandomNumbers(int n, int low, int high) {
        Vector<Integer> random = new Vector<Integer>();
        int[] numbers = new int[high - low + 1];
        for (int i = low; i <= high; ++i) {
            numbers[i - low] = i;
        }
        int remained = high - low + 1;
        for (int i = 0; i < n; ++i) {
            int new_number = Randomize.Randint(1, remained);
            random.add(new Integer(numbers[new_number]));
            numbers[new_number] = numbers[remained - 1];
            --remained;
        }
        return random;
    }

    private Vector convert(Tree node, Rule base_rule, SimpleRule link_to_father, String type) {
        Rule node_rule = base_rule.getCopy();
        if (link_to_father != null) {
            node_rule.grow(link_to_father);
        }
        Vector<Rule> output = new Vector<Rule>();
        if (node.isLeaf) {
            node_rule.setType(type);
            output.add(node_rule);
        } else {
            int class_index;
            int cut_attribute = node.nodeModel.attributeIndex();
            if (cut_attribute > (class_index = this.train.getClassIndex())) {
                ++cut_attribute;
            }
            for (int i = 0; i < node.getNChildren(); ++i) {
                SimpleRule link_child = new SimpleRule();
                link_child.setAttribute(cut_attribute);
                if (this.train.getAttribute(cut_attribute).isDiscret()) {
                    link_child.setValue(i);
                    link_child.setOperator(SimpleRule.EQUAL);
                } else {
                    link_child.setValue(node.nodeModel.getCutPoint());
                    if (i == 0) {
                        link_child.setOperator(SimpleRule.LOWER);
                    } else {
                        link_child.setOperator(SimpleRule.GREATER);
                    }
                }
                String child_type = "";
                if (node.getChild((int)i).isLeaf) {
                    child_type = node.nodeModel.label(i, this.train);
                }
                Vector child_rules = this.convert(node.getChild(i), node_rule, link_child, child_type);
                output.addAll(child_rules);
            }
        }
        return output;
    }

    private Mask[] getAllMasks(Ruleset rules) {
        Mask[] output = new Mask[rules.size()];
        for (int i = 0; i < rules.size(); ++i) {
            output[i] = new Mask(this.train.size());
            this.train.filter(output[i], rules.getRule(i));
        }
        return output;
    }

    private Report allCombinations(Ruleset pool, Mask[] all_masks, int next_rule, int[] base_card, int base_card_length, double base_card_theory_cost, Mask base_mask, int class_value) {
        Mask class_mask = this.class_filter[class_value];
        Mask inverse_class_mask = this.inverse_class_filter[class_value];
        int[] new_card = new int[base_card.length];
        int new_card_length = base_card_length + 1;
        for (int i = 0; i < base_card_length; ++i) {
            new_card[i] = base_card[i];
        }
        new_card[base_card_length] = next_rule;
        Mask new_mask = base_mask.or(all_masks[next_rule]);
        int tp = new_mask.and(class_mask).getnActive();
        int fp = new_mask.and(inverse_class_mask).getnActive();
        int fn = class_mask.getnActive() - tp;
        int tn = inverse_class_mask.getnActive() - fp;
        double new_card_theory_cost = base_card_theory_cost + pool.getRule(next_rule).theoryDL(this.train);
        double new_card_value = new_card_theory_cost + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
        Report best_report = new Report(new_card, new_card_length, new_card_value);
        for (int i = next_rule + 1; i < pool.size(); ++i) {
            Report current = this.allCombinations(pool, all_masks, i, new_card, new_card_length, new_card_theory_cost, new_mask, class_value);
            if (!(current.getValue() < best_report.getValue())) continue;
            best_report = current;
        }
        return best_report;
    }

    private void doOutput(MyDataset dataset, String filename, String[] classification) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.size(); ++i) {
            String class_name = dataset.getClassAttribute().value((int)dataset.itemset(i).getClassValue());
            output = output + class_name + " " + classification[i] + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            output = output + "if(";
            for (int j = 0; j < rulesets[i].size(); ++j) {
                Rule current = rulesets[i].getRule(j);
                output = output + "(";
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                output = output + ")";
                if (j == rulesets[i].size() - 1) continue;
                output = output + " || ";
            }
            output = output + ")\n\t";
            output = output + "output=" + rulesets[i].getType() + "\nelse ";
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput2(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            for (int j = 0; j < rulesets[i].size(); ++j) {
                output = output + "if(";
                Rule current = rulesets[i].getRule(j);
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                int class_id = this.train.getClassAttribute().valueIndex(rulesets[i].getType());
                int covered = current.apply(this.train);
                int accuracy = current.apply(this.train, this.class_filter[class_id]);
                output = output + ") (" + accuracy + "/" + covered + ")\n\t";
                output = output + "output=" + rulesets[i].getType() + "\nelse ";
            }
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    public C45Rules(Tree root, parseParameters parameters) {
        this.root = root;
        String trainFileName = parameters.getTrainingInputFile();
        String valFileName = parameters.getValidationInputFile();
        String testFileName = parameters.getTestInputFile();
        this.train = new MyDataset(trainFileName, false);
        this.val = new MyDataset(valFileName, false);
        this.test = new MyDataset(testFileName, false);
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.outputRules = parameters.getOutputFile(0);
        long seed = Long.parseLong(parameters.getParameter(0));
        Randomize.setSeed(seed);
        this.treshold = Integer.parseInt(parameters.getParameter(3));
        this.CF = Double.parseDouble(parameters.getParameter(1));
        this.SearchAlgorithm = GREEDY;
        if (this.CF < 0.0 || this.CF > 1.0) {
            this.CF = 0.25;
            System.err.println("Error: confidence must be in the interval [0,1]");
            System.err.println("Using default value: 0.25");
        }
        if (this.treshold <= 0) {
            this.treshold = 10;
            System.err.println("Error: treshold must be greater than 0");
            System.err.println("Using default value: 10");
        }
        this.classification_rules = null;
        this.default_class_name = null;
    }

    public Vector treeToRules() {
        Vector output = null;
        if (!this.root.isLeaf) {
            output = this.convert(this.root, new Rule(), null, "");
        }
        return output;
    }

    public void pruneRule(Rule rule) {
        boolean seguir_podando;
        int class_value = this.train.getClassAttribute().valueIndex(rule.getType());
        Mask class_mask = this.class_filter[class_value];
        Mask inverse_class_mask = this.inverse_class_filter[class_value];
        int tp = rule.apply(this.train, class_mask);
        int fp = rule.apply(this.train, inverse_class_mask);
        double next_U = ((double)fp + Extra.AddErrs(tp + fp, fp, this.CF)) / (double)(tp + fp);
        int to_prune = -1;
        do {
            double current_U = next_U;
            seguir_podando = false;
            for (int i = 0; i < rule.size(); ++i) {
                int tp_i = rule.apply(this.train, class_mask, i);
                int fp_i = rule.apply(this.train, inverse_class_mask, i);
                double U_i = ((double)fp_i + Extra.AddErrs(tp_i + fp_i, fp_i, this.CF)) / (double)(tp_i + fp_i);
                if (!(U_i <= next_U)) continue;
                to_prune = i;
                next_U = U_i;
                seguir_podando = true;
            }
            if (!seguir_podando) continue;
            rule.prune(to_prune);
        } while (seguir_podando && rule.size() > 0);
    }

    public void removeDuplicates(Vector rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule current = (Rule)rules.elementAt(i);
            if (current.size() != 0) {
                for (int j = i + 1; j < rules.size(); ++j) {
                    if (!current.isEqual((Rule)rules.elementAt(j))) continue;
                    rules.remove(j);
                    --j;
                }
                continue;
            }
            rules.remove(i);
            --i;
        }
    }

    public Ruleset[] classifyRules(Vector rules) {
        Ruleset[] groups = new Ruleset[this.train.numClasses()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = new Ruleset();
            groups[i].setType(this.train.getAttribute(this.train.getClassIndex()).value(i));
        }
        while (rules.size() > 0) {
            String class_name = ((Rule)rules.elementAt(0)).getType();
            int class_index = this.train.getAttribute(this.train.getClassIndex()).valueIndex(class_name);
            groups[class_index].addRule((Rule)rules.elementAt(0));
            rules.remove(0);
        }
        return groups;
    }

    public Ruleset exhaustiveSearch(Ruleset rules) {
        Mask[] all_masks = this.getAllMasks(rules);
        int class_value = this.train.getClassAttribute().valueIndex(rules.getType());
        Mask blank = new Mask(this.train.size(), false);
        Report best_report = this.allCombinations(rules, all_masks, 0, new int[rules.size()], 0, 0.0, blank, class_value);
        for (int i = 1; i < rules.size(); ++i) {
            Report current = this.allCombinations(rules, all_masks, i, new int[rules.size()], 0, 0.0, blank, class_value);
            if (!(current.getValue() < best_report.getValue())) continue;
            best_report = current;
        }
        Ruleset selected_rules = new Ruleset();
        selected_rules.setType(rules.getType());
        for (int i = 0; i < best_report.length(); ++i) {
            selected_rules.addRule(rules.getRule(best_report.get(i)));
        }
        return selected_rules;
    }

    public Ruleset greedySearch(Ruleset rules) {
        Mask[] all_masks = this.getAllMasks(rules);
        int class_value = this.train.getClassAttribute().valueIndex(rules.getType());
        Mask class_mask = this.class_filter[class_value];
        Mask inverse_class_mask = this.inverse_class_filter[class_value];
        Report best_report = null;
        for (double pct = 0.1; pct <= 1.0; pct += 0.1) {
            int j;
            int[] new_card;
            int rule_index;
            int i;
            int base_length = (int)Math.ceil(pct * (double)rules.size());
            int[] base_card = new int[base_length];
            IncrementalMask base_mask = new IncrementalMask(this.train.size());
            int[] exclude_rules = new int[rules.size()];
            for (int i2 = 0; i2 < rules.size(); ++i2) {
                exclude_rules[i2] = i2;
            }
            int remained = rules.size();
            double theory_cost = 0.0;
            for (int i3 = 0; i3 < base_length; ++i3) {
                int new_number = Randomize.Randint(0, remained);
                base_card[i3] = exclude_rules[new_number];
                base_mask = base_mask.plus(all_masks[base_card[i3]]);
                exclude_rules[new_number] = exclude_rules[remained - 1];
                --remained;
                theory_cost += rules.getRule(base_card[i3]).theoryDL(this.train);
            }
            int tp = base_mask.and(class_mask).getnActive();
            int fp = base_mask.and(inverse_class_mask).getnActive();
            int fn = class_mask.getnActive() - tp;
            int tn = inverse_class_mask.getnActive() - fp;
            double base_card_value = theory_cost + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
            Report base_report = new Report(base_card, base_length, base_card_value);
            if (best_report == null || base_report.getValue() < best_report.getValue()) {
                best_report = base_report;
            }
            for (i = 0; i < base_report.length(); ++i) {
                rule_index = base_report.get(i);
                IncrementalMask without_rulei = base_mask.minus(all_masks[rule_index]);
                tp = without_rulei.and(class_mask).getnActive();
                fp = without_rulei.and(inverse_class_mask).getnActive();
                fn = class_mask.getnActive() - tp;
                tn = inverse_class_mask.getnActive() - fp;
                double theory_cost_without_i = theory_cost - rules.getRule(rule_index).theoryDL(this.train);
                double without_rulei_value = theory_cost_without_i + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
                if (!(without_rulei_value < best_report.getValue())) continue;
                new_card = new int[base_report.length() - 1];
                for (j = 0; j < i; ++j) {
                    new_card[j] = base_report.get(j);
                }
                for (j = i + 1; j < base_report.length(); ++j) {
                    new_card[j - 1] = base_report.get(j);
                }
                best_report = new Report(new_card, base_report.length() - 1, without_rulei_value);
            }
            for (i = 0; i < remained; ++i) {
                rule_index = exclude_rules[i];
                IncrementalMask with_rulei = base_mask.plus(all_masks[rule_index]);
                tp = with_rulei.and(class_mask).getnActive();
                fp = with_rulei.and(inverse_class_mask).getnActive();
                fn = class_mask.getnActive() - tp;
                tn = inverse_class_mask.getnActive() - fp;
                double theory_cost_with_i = theory_cost + rules.getRule(rule_index).theoryDL(this.train);
                double with_rulei_value = theory_cost_with_i + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
                if (!(with_rulei_value < best_report.getValue())) continue;
                new_card = new int[base_report.length() + 1];
                for (j = 0; j < base_length; ++j) {
                    new_card[j] = base_report.get(j);
                }
                new_card[base_report.length()] = rule_index;
                best_report = new Report(new_card, base_report.length() + 1, with_rulei_value);
            }
        }
        Ruleset selected_rules = new Ruleset();
        selected_rules.setType(rules.getType());
        for (int i = 0; i < best_report.length(); ++i) {
            selected_rules.addRule(rules.getRule(best_report.get(i)));
        }
        return selected_rules;
    }

    public Ruleset simulatedAnnealing(Ruleset rules, int Nmax, int max_trials, double mu, double phi, double alpha) {
        Mask[] all_masks = this.getAllMasks(rules);
        int class_value = this.train.getClassAttribute().valueIndex(rules.getType());
        Mask class_mask = this.class_filter[class_value];
        Mask inverse_class_mask = this.inverse_class_filter[class_value];
        int initial_length = Randomize.Randint(0, rules.size());
        int[] initial_card = new int[initial_length];
        IncrementalMask initial_mask = new IncrementalMask(this.train.size());
        int[] all_rules = new int[rules.size()];
        for (int i = 0; i < rules.size(); ++i) {
            all_rules[i] = i;
        }
        int remained = rules.size();
        double theory_cost = 0.0;
        for (int i = 0; i < initial_length; ++i) {
            int new_number = Randomize.Randint(0, remained);
            initial_card[i] = all_rules[new_number];
            initial_mask = initial_mask.plus(all_masks[initial_card[i]]);
            int aux = all_rules[new_number];
            all_rules[new_number] = all_rules[remained - 1];
            all_rules[remained - 1] = aux;
            --remained;
            theory_cost += rules.getRule(initial_card[i]).theoryDL(this.train);
        }
        int tp = initial_mask.and(class_mask).getnActive();
        int fp = initial_mask.and(inverse_class_mask).getnActive();
        int fn = class_mask.getnActive() - tp;
        int tn = inverse_class_mask.getnActive() - fp;
        double initial_card_value = theory_cost + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
        Report best_report = new Report(initial_card, initial_length, initial_card_value);
        IncrementalMask current_mask = initial_mask;
        double current_value = initial_card_value;
        double t = (mu - Math.log(phi)) * initial_card_value;
        boolean success = true;
        int max_succeses = 0 * max_trials;
        for (int iter = 0; iter < Nmax && success; ++iter) {
            int nsuccesses = 0;
            for (int trial = 0; trial < max_trials && nsuccesses < max_succeses; ++trial) {
                int aux;
                int next = Randomize.Randint(0, rules.size());
                int rule_index = all_rules[next];
                IncrementalMask next_mask = null;
                double new_theory_cost = theory_cost;
                if (next < remained) {
                    next_mask = current_mask.plus(all_masks[rule_index]);
                    new_theory_cost += rules.getRule(rule_index).theoryDL(this.train);
                } else {
                    next_mask = current_mask.minus(all_masks[rule_index]);
                    new_theory_cost -= rules.getRule(rule_index).theoryDL(this.train);
                }
                tp = next_mask.and(class_mask).getnActive();
                fp = next_mask.and(inverse_class_mask).getnActive();
                fn = class_mask.getnActive() - tp;
                tn = inverse_class_mask.getnActive() - fp;
                double next_value = new_theory_cost + Rule.getExceptionCost(this.train, tp, tn, fp, fn);
                double delta = next_value - current_value;
                double rand = Randomize.Rand();
                if (!(next_value < current_value) && !(rand < Math.exp(-delta / t))) continue;
                if (next < remained) {
                    aux = all_rules[next];
                    all_rules[next] = all_rules[remained - 1];
                    all_rules[remained - 1] = aux;
                    --remained;
                    current_mask = current_mask.plus(all_masks[rule_index]);
                } else {
                    aux = all_rules[next];
                    all_rules[next] = all_rules[remained];
                    all_rules[remained] = aux;
                    ++remained;
                    current_mask = current_mask.minus(all_masks[rule_index]);
                }
                if (next_value < current_value) {
                    ++nsuccesses;
                    success = true;
                }
                current_value = next_value;
                theory_cost = new_theory_cost;
                if (!(current_value < best_report.getValue())) continue;
                int[] new_best_card = new int[rules.size() - remained];
                for (int i = 0; i < rules.size() - remained; ++i) {
                    new_best_card[i] = all_rules[remained + i];
                }
                best_report = new Report(new_best_card, rules.size() - remained, current_value);
            }
            t = alpha * t;
        }
        Ruleset selected_rules = new Ruleset();
        selected_rules.setType(rules.getType());
        for (int i = 0; i < best_report.length(); ++i) {
            selected_rules.addRule(rules.getRule(best_report.get(i)));
        }
        return selected_rules;
    }

    public String sortingRulesets(Ruleset[] rulesets, Mask[] all_ruleset_masks) {
        Mask filter = new Mask(this.train.size());
        for (int i = 0; i < this.train.numClasses() - 1; ++i) {
            int class_value;
            int best_candidate = -1;
            int best_fp = this.train.size() + 1;
            for (int j = i; j < this.train.numClasses(); ++j) {
                class_value = this.train.getClassAttribute().valueIndex(rulesets[j].getType());
                Mask candidate_mask = all_ruleset_masks[class_value].and(filter);
                int candidate_fp = candidate_mask.and(this.inverse_class_filter[class_value]).getnActive();
                if (candidate_fp >= best_fp) continue;
                best_candidate = j;
                best_fp = candidate_fp;
            }
            Ruleset aux = rulesets[i];
            rulesets[i] = rulesets[best_candidate];
            rulesets[best_candidate] = aux;
            class_value = this.train.getClassAttribute().valueIndex(rulesets[i].getType());
            filter = filter.and(all_ruleset_masks[class_value]).complement();
        }
        int class_value = this.train.getClassAttribute().valueIndex(rulesets[this.train.numClasses() - 1].getType());
        filter = filter.and(all_ruleset_masks[class_value]).complement();
        int[] remained_class_frequency = this.train.getClassFequency(filter);
        int[] class_frequency = this.train.getClassFequency();
        int higher_rel_freq = -1;
        int higher_freq = -1;
        int default_class = -1;
        for (int i = 0; i < this.train.numClasses(); ++i) {
            if (remained_class_frequency[i] > higher_rel_freq) {
                higher_rel_freq = remained_class_frequency[i];
                higher_freq = class_frequency[i];
                default_class = i;
                continue;
            }
            if (remained_class_frequency[i] != higher_freq || class_frequency[i] <= higher_freq) continue;
            higher_rel_freq = remained_class_frequency[i];
            higher_freq = class_frequency[i];
            default_class = i;
        }
        return this.train.getClassAttribute().value(default_class);
    }

    public void executeAlgorithm() {
        int j;
        int class_value;
        int i;
        int i2;
        int i3;
        this.class_filter = new Mask[this.train.numClasses()];
        this.inverse_class_filter = new Mask[this.train.numClasses()];
        for (int i4 = 0; i4 < this.train.numClasses(); ++i4) {
            this.class_filter[i4] = new Mask(this.train.size());
            String class_name = this.train.getClassAttribute().value(i4);
            this.train.filterByClass(this.class_filter[i4], class_name);
            this.inverse_class_filter[i4] = this.class_filter[i4].complement();
        }
        System.out.println("1.Original Rules:");
        Vector rules = this.treeToRules();
        for (i3 = 0; i3 < rules.size(); ++i3) {
            System.out.println((Rule)rules.elementAt(i3));
        }
        System.out.println("2.Pruned Rules:");
        for (i3 = 0; i3 < rules.size(); ++i3) {
            this.pruneRule((Rule)rules.elementAt(i3));
        }
        for (i3 = 0; i3 < rules.size(); ++i3) {
            System.out.println((Rule)rules.elementAt(i3));
        }
        this.removeDuplicates(rules);
        System.out.println("3.Rules without duplicates:");
        for (i3 = 0; i3 < rules.size(); ++i3) {
            System.out.println((Rule)rules.elementAt(i3));
        }
        Ruleset[] rulesets = this.classifyRules(rules);
        System.out.println("4.Classified Rules:");
        for (int i5 = 0; i5 < this.train.numClasses(); ++i5) {
            System.out.println("Ruleset " + rulesets[i5].getType() + ":");
            for (int j2 = 0; j2 < rulesets[i5].size(); ++j2) {
                System.out.println(rulesets[i5].getRule(j2) + "->t:" + rulesets[i5].getRule(j2).theoryDL(this.train));
            }
        }
        Ruleset[] final_rulesets = new Ruleset[this.train.numClasses() + 1];
        for (i2 = 0; i2 < this.train.numClasses(); ++i2) {
            if (rulesets[i2].size() > 0) {
                if (rulesets[i2].size() < this.treshold) {
                    final_rulesets[i2] = this.exhaustiveSearch(rulesets[i2]);
                    continue;
                }
                if (this.SearchAlgorithm == GREEDY) {
                    final_rulesets[i2] = this.greedySearch(rulesets[i2]);
                    continue;
                }
                final_rulesets[i2] = this.simulatedAnnealing(rulesets[i2], this.Nmax, this.max_trials, this.mu, this.phi, this.alpha);
                continue;
            }
            final_rulesets[i2] = rulesets[i2];
        }
        System.out.println("5.Remaining Rules:");
        for (i2 = 0; i2 < this.train.numClasses(); ++i2) {
            if (final_rulesets[i2] == null) continue;
            System.out.println("Ruleset " + final_rulesets[i2].getType() + ":");
            for (int j3 = 0; j3 < final_rulesets[i2].size(); ++j3) {
                System.out.println(final_rulesets[i2].getRule(j3));
            }
        }
        Mask[] all_ruleset_masks = new Mask[this.train.numClasses()];
        for (i = 0; i < this.train.numClasses(); ++i) {
            class_value = this.train.getClassAttribute().valueIndex(final_rulesets[i].getType());
            Mask[] ruleset_mask = this.getAllMasks(final_rulesets[i]);
            all_ruleset_masks[class_value] = new Mask(this.train.size(), false);
            all_ruleset_masks[class_value] = all_ruleset_masks[class_value].or(ruleset_mask);
        }
        this.default_class_name = this.sortingRulesets(final_rulesets, all_ruleset_masks);
        System.out.println("6.Sorted Rules:");
        for (i = 0; i < this.train.numClasses(); ++i) {
            System.out.println(i + "- Ruleset: " + final_rulesets[i].getType());
            for (j = 0; j < final_rulesets[i].size(); ++j) {
                System.out.println(final_rulesets[i].getRule(j));
            }
        }
        System.out.println("Clase por defecto: " + this.default_class_name);
        for (i = 0; i < this.train.numClasses(); ++i) {
            class_value = this.train.getClassAttribute().valueIndex(final_rulesets[i].getType());
            final_rulesets[i].pulish(this.train, this.class_filter[class_value], this.inverse_class_filter[class_value]);
        }
        System.out.println("7.Polish:");
        for (i = 0; i < this.train.numClasses(); ++i) {
            System.out.println(i + "- Ruleset: " + final_rulesets[i].getType());
            for (j = 0; j < final_rulesets[i].size(); ++j) {
                System.out.println(final_rulesets[i].getRule(j));
            }
        }
        System.out.println("Clase por defecto: " + this.default_class_name);
        this.classification_rules = final_rulesets;
        Ruleset dflt = new Ruleset();
        dflt.setType(this.default_class_name);
        this.classification_rules[this.train.numClasses()] = dflt;
    }

    public void execute() {
        this.executeAlgorithm();
        String[] classification_train = this.train.classify(this.classification_rules, this.classification_rules.length);
        String[] classification_val = this.val.classify(this.classification_rules, this.classification_rules.length);
        String[] classification_test = this.test.classify(this.classification_rules, this.classification_rules.length);
        this.doOutput(this.val, this.outputTr, classification_val);
        this.doOutput(this.test, this.outputTst, classification_test);
        this.doRulesOutput2(this.outputRules, this.classification_rules);
        System.out.println("Algorithm Finished");
    }
}

