/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.keellatextables;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.keellatextables.MeasuresCalculator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResultsProccessor {
    private Document readedDocument = null;
    private HashMap<String, HashMap<String, Double>> algorithmMeasures = new HashMap();
    private HashMap<String, Double> algorithmTotalRules = new HashMap();
    private HashMap<String, Integer> algorithmSeeds = new HashMap();
    private ArrayList<String> excludedFromAverage = new ArrayList();
    private ArrayList<String> sortedMeasures = null;
    private String actualAlgorithm;
    private Integer actualRulesNumber = 0;

    public ResultsProccessor() {
        this.excludedFromAverage.add("$\\#R$");
        this.sortedMeasures = new ArrayList();
    }

    private void resetProcessor() {
        this.algorithmMeasures.clear();
    }

    public void parseXmlFile(String measuresFile, String algorithm) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.readedDocument = db.parse(measuresFile);
        this.actualAlgorithm = algorithm;
        this.parseMeasuresFile();
    }

    private void parseMeasuresFile() throws Exception {
        Element docEle = this.readedDocument.getDocumentElement();
        NodeList rules = docEle.getElementsByTagName("rule");
        this.actualRulesNumber = rules.getLength();
        Double support = 0.0;
        Double confidence = 0.0;
        Double antSupport = 0.0;
        Double conSuport = 0.0;
        Double lift = 0.0;
        Double conviction = 0.0;
        Double cf = 0.0;
        Double netConf = 0.0;
        MeasuresCalculator mc = new MeasuresCalculator();
        this.putMeasure("$\\#R$", (double)this.actualRulesNumber.intValue() * 1.0);
        this.addRulesNumberToAlgorithm(this.actualRulesNumber);
        if (rules != null && rules.getLength() > 0) {
            this.addSeed();
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                support = this.processMeasure(rule, "rule_support", "$Av_{Sup}$");
                antSupport = this.processMeasure(rule, "antecedent_support", "$Av_{AntSup}$");
                conSuport = this.processMeasure(rule, "consequent_support", "$Av_{ConSup}$");
                this.putMeasure("$Av_{Lift}$", mc.calculateLift(antSupport, conSuport, support));
                this.putMeasure("$Av_{Conf}$", mc.calculateConfidence(antSupport, conSuport, support));
                this.putMeasure("$Av_{CF}$", mc.calculateCF(antSupport, conSuport, support));
                this.putMeasure("$Av_{Conviction}$", mc.calculateConviction(antSupport, conSuport, support));
            }
        } else {
            throw new Exception("NoRules");
        }
    }

    private void putMeasure(String beautifulName, Double measureValue) {
        if (this.algorithmMeasures.containsKey(this.actualAlgorithm)) {
            if (!this.algorithmMeasures.get(this.actualAlgorithm).containsKey(beautifulName)) {
                this.algorithmMeasures.get(this.actualAlgorithm).put(beautifulName, measureValue);
            } else {
                Double newValue = this.algorithmMeasures.get(this.actualAlgorithm).get(beautifulName) + measureValue;
                this.algorithmMeasures.get(this.actualAlgorithm).put(beautifulName, newValue);
            }
        } else {
            HashMap<String, Double> tmp = new HashMap<String, Double>();
            tmp.put(beautifulName, measureValue);
            this.algorithmMeasures.put(this.actualAlgorithm, tmp);
        }
        if (!this.sortedMeasures.contains(beautifulName)) {
            this.sortedMeasures.add(beautifulName);
        }
    }

    private void addSeed() {
        if (this.algorithmSeeds.containsKey(this.actualAlgorithm)) {
            Integer newValue = this.algorithmSeeds.get(this.actualAlgorithm) + 1;
            this.algorithmSeeds.put(this.actualAlgorithm, newValue);
        } else {
            this.algorithmSeeds.put(this.actualAlgorithm, 1);
        }
    }

    private void calcAvgRulesBySeed() {
        for (Map.Entry<String, Integer> entry : this.algorithmSeeds.entrySet()) {
            String alg = entry.getKey();
            Integer value = entry.getValue();
            Double rules = this.algorithmMeasures.get(alg).get("$\\#R$");
            rules = rules / (double)value.intValue();
            this.algorithmMeasures.get(alg).put("$\\#R$", rules);
        }
    }

    private Double processMeasure(Element rule, String measureName, String beautifulName) {
        Double measureValue = 0.0;
        if (rule.hasAttribute(measureName)) {
            measureValue = Double.parseDouble(rule.getAttribute(measureName));
        }
        this.putMeasure(beautifulName, measureValue);
        return measureValue;
    }

    private void addRulesNumberToAlgorithm(int numRules) {
        if (this.algorithmTotalRules.containsKey(this.actualAlgorithm)) {
            Double now = this.algorithmTotalRules.get(this.actualAlgorithm) + (double)numRules;
            this.algorithmTotalRules.put(this.actualAlgorithm, now);
        } else {
            this.algorithmTotalRules.put(this.actualAlgorithm, (double)numRules * 1.0);
        }
    }

    private void calcMeans() {
        for (Map.Entry<String, HashMap<String, Double>> entry : this.algorithmMeasures.entrySet()) {
            String alg = entry.getKey();
            HashMap<String, Double> measuresFirst = entry.getValue();
            for (Map.Entry<String, Double> measure : measuresFirst.entrySet()) {
                String measureName = measure.getKey();
                if (this.excludedFromAverage.contains(measureName)) continue;
                Double measureValue = measure.getValue() / this.algorithmTotalRules.get(alg);
                this.algorithmMeasures.get(alg).put(measureName, measureValue);
            }
        }
    }

    public void writeToFile(String outName) throws FileNotFoundException, UnsupportedEncodingException {
        this.calcMeans();
        this.calcAvgRulesBySeed();
        PrintWriter writer = new PrintWriter(outName, "UTF-8");
        String tableHeader = "\\textbf{Algorithm} ";
        for (String measureName : this.sortedMeasures) {
            tableHeader = tableHeader + "& \\textbf{" + measureName + "} ";
        }
        tableHeader = tableHeader + "\\\\ \\hline \\hline";
        Integer measuresNumber = this.sortedMeasures.size();
        String tableSettings = "\\begin{table*}[ht!]\n\\centering\n\\caption[Caption]{Something}\n\\label{table:label}\n\\scalebox{0.90}{ \n";
        tableSettings = tableSettings + "\\begin{tabular}{ l | ";
        for (int i = 0; i < measuresNumber; ++i) {
            tableSettings = tableSettings + "| c ";
        }
        tableSettings = tableSettings + "";
        tableSettings = tableSettings + "} \n \\hline";
        writer.println("\\documentclass{article} \n \\begin{document} \n\n % Copy only the table to your LaTeX file");
        writer.println(tableSettings);
        writer.println(tableHeader);
        for (Map.Entry<String, HashMap<String, Double>> alg : this.algorithmMeasures.entrySet()) {
            String algName = alg.getKey();
            HashMap<String, Double> measures = alg.getValue();
            String aName = algName.substring(0, algName.length() - 1);
            int startAlgName = aName.lastIndexOf("/");
            aName = aName.substring(startAlgName + 1);
            String algContent = aName + " ";
            for (int i = 0; i < this.sortedMeasures.size(); ++i) {
                String m = String.format("%.2f", measures.get(this.sortedMeasures.get(i)));
                algContent = algContent + "& " + m + " ";
            }
            algContent = algContent + "\\\\ \\hline";
            writer.println(algContent);
        }
        writer.println("\\end{tabular}}\n\\end{table*}  \n\n \\end{document}");
        writer.flush();
        writer.close();
    }

    private String join(ArrayList<String> in, String separator) {
        String out = "";
        for (String i : in) {
            out = out + i + separator;
        }
        return out;
    }

    private ArrayList concat(ArrayList<String> a, ArrayList<String> b) {
        ArrayList<String> out = new ArrayList<String>();
        for (String i : a) {
            out.add(i);
        }
        for (String i : b) {
            out.add(i);
        }
        return out;
    }

    private static HashMap sortByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    private static HashMap sortByValuesArray(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ArrayList a1 = (ArrayList)((Map.Entry)o1).getValue();
                ArrayList a2 = (ArrayList)((Map.Entry)o2).getValue();
                return ((Comparable)a1.get(0)).compareTo(a2.get(0));
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    private String findSmallerValue(HashMap<String, String> map) {
        double valueNumber = Double.MAX_VALUE;
        String smallerElement = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == "" || !(Double.parseDouble(value) < valueNumber)) continue;
            smallerElement = key;
            valueNumber = Double.parseDouble(value);
        }
        return smallerElement;
    }
}

