/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.UniformWidth_Discretizer;

import java.util.Vector;
import keel.Algorithms.Discretizers.Basic.Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;

public class UniformWidthDiscretizer
extends Discretizer {
    double numCP;

    public UniformWidthDiscretizer(int _numCP) {
        this.numCP = _numCP > 0 ? (double)_numCP : (Parameters.numInstances / 100 > Parameters.numClasses ? (double)(Parameters.numInstances / 100) : (double)Parameters.numClasses);
    }

    @Override
    protected Vector discretizeAttribute(int attribute, int[] values, int begin, int end) {
        double min = this.realValues[attribute][values[0]];
        double max = this.realValues[attribute][values[end]];
        double intervalWidth = (max - min) / (this.numCP + 1.0);
        Vector<Double> cp = new Vector<Double>();
        double val = min;
        int i = 0;
        while ((double)i < this.numCP) {
            cp.addElement(new Double(val += intervalWidth));
            ++i;
        }
        return cp;
    }
}

