/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import javolution.lang.Reusable;
import javolution.xml.ObjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlOutputStream<T>
extends OutputStream
implements Reusable {
    static final byte END_XML = -2;
    private OutputStream _outputStream;
    private final ObjectWriter<T> _objectWriter;
    private final OutputStreamProxy _outputStreamProxy = new OutputStreamProxy();

    public XmlOutputStream() {
        this(new ObjectWriter());
    }

    public XmlOutputStream(ObjectWriter<T> objectWriter) {
        this._objectWriter = objectWriter;
    }

    public XmlOutputStream setOutputStream(OutputStream outputStream) {
        if (this._outputStream != null) {
            throw new IllegalStateException("Stream not closed or reset");
        }
        this._outputStream = outputStream;
        return this;
    }

    public void writeObject(T t) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._objectWriter.write(t, this._outputStreamProxy);
        this._outputStream.write(-2);
        this._outputStream.flush();
    }

    @Override
    public void write(int n) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(n);
    }

    @Override
    public void flush() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.flush();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.close();
            this.reset();
        }
    }

    @Override
    public void reset() {
        this._objectWriter.reset();
        this._outputStream = null;
    }

    private final class OutputStreamProxy
    extends OutputStream {
        private OutputStreamProxy() {
        }

        public void flush() throws IOException {
            XmlOutputStream.this._outputStream.flush();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            XmlOutputStream.this._outputStream.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            XmlOutputStream.this._outputStream.write(n);
        }

        public void close() throws IOException {
        }
    }
}

