/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray.mut;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.binarray.BinArrayIndividual;
import net.sourceforge.jclec.binarray.BinArrayMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SeveralLociMutator
extends BinArrayMutator
implements IConfigure {
    private static final long serialVersionUID = 3258415014955071027L;
    private int numberOfMutationPoints;
    private transient int[] mp;

    public int getNumberOfMutationPoints() {
        return this.numberOfMutationPoints;
    }

    public void setNumberOfMutationPoints(int nofmp) {
        this.numberOfMutationPoints = nofmp;
    }

    @Override
    public void configure(Configuration configuration) {
        int numberOfMutationPoints = configuration.getInt("[@number-of-mutation-points]");
        this.setNumberOfMutationPoints(numberOfMutationPoints);
    }

    public boolean equals(Object other) {
        if (other instanceof SeveralLociMutator) {
            SeveralLociMutator o = (SeveralLociMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.numberOfMutationPoints, o.numberOfMutationPoints);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append(this.numberOfMutationPoints);
        return tsb.toString();
    }

    @Override
    protected void mutateNext() {
        int gl = this.species.getGenotypeLength();
        BinArrayIndividual mutant = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        byte[] mgenome = new byte[gl];
        System.arraycopy(mutant.getGenotype(), 0, mgenome, 0, gl);
        this.setMpoints(gl);
        int i = 0;
        while (i < this.numberOfMutationPoints) {
            this.flip(mgenome, this.mp[i]);
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(mgenome));
    }

    private final void setMpoints(int gl) {
        if (this.mp == null) {
            this.mp = new int[this.numberOfMutationPoints];
        }
        int i = 0;
        while (i < this.numberOfMutationPoints) {
            boolean exit;
            block1: do {
                this.mp[i] = this.randgen.choose(0, gl);
                exit = true;
                int j = 0;
                while (j < i) {
                    if (this.mp[i] == this.mp[j]) {
                        exit = false;
                        continue block1;
                    }
                    ++j;
                }
            } while (!exit);
            ++i;
        }
    }
}

