/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.Cluster_Analysis;

import java.util.Arrays;
import java.util.Vector;
import keel.Algorithms.Discretizers.Basic.Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.LogManager;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Cluster_Analysis
extends Discretizer {
    Instance[] instances;

    @Override
    public void buildCutPoints(InstanceSet is) {
        int m;
        int l;
        boolean stop;
        int j;
        int i;
        int numReal = 0;
        double Lc = 0.0;
        this.instances = is.getInstances();
        this.classOfInstances = new int[this.instances.length];
        for (i = 0; i < this.instances.length; ++i) {
            this.classOfInstances[i] = this.instances[i].getOutputNominalValuesInt(0);
        }
        this.cutPoints = new double[Parameters.numAttributes][];
        this.realAttributes = new boolean[Parameters.numAttributes];
        this.realValues = new double[Parameters.numAttributes][];
        for (i = 0; i < this.instances.length; ++i) {
            for (j = i + 1; j < this.instances.length; ++j) {
                stop = false;
                for (l = 0; l < Attributes.getInputNumAttributes() && !stop; ++l) {
                    if (Attributes.getInputAttribute(l).getType() == 0) {
                        if (this.instances[i].getInputNominalValues(l) == this.instances[j].getInputNominalValues(l)) continue;
                        stop = true;
                        continue;
                    }
                    if (this.instances[i].getInputRealValues(l) == this.instances[j].getInputRealValues(l)) continue;
                    stop = true;
                }
                if (stop || this.instances[i].getOutputNominalValuesInt(0) == this.instances[j].getOutputNominalValuesInt(0)) continue;
                Lc += 1.0;
            }
        }
        Lc = 1.0 - Lc / (double)this.instances.length;
        for (i = 0; i < Parameters.numAttributes; ++i) {
            Attribute at = Attributes.getAttribute(i);
            if (at.getDirectionAttribute() != 1 || at.getType() != 2 && at.getType() != 1) continue;
            this.realAttributes[i] = true;
            ++numReal;
        }
        double[][] examples = new double[numReal][this.instances.length];
        double[][] examplesCopy = new double[numReal][this.instances.length];
        j = 0;
        for (i = 0; i < Parameters.numAttributes; ++i) {
            if (!this.realAttributes[i]) continue;
            for (l = 0; l < this.instances.length; ++l) {
                examplesCopy[j][l] = this.instances[l].getInputRealValues(i);
                examples[j][l] = this.instances[l].getInputRealValues(i);
                examples[j][l] = (examples[j][l] - Attributes.getAttribute(i).getMinAttribute()) / (Attributes.getAttribute(i).getMaxAttribute() - Attributes.getAttribute(i).getMinAttribute());
            }
            ++j;
        }
        double[][] distanceMatrix = new double[this.instances.length][this.instances.length];
        for (i = 0; i < this.instances.length; ++i) {
            for (j = 0; j < this.instances.length; ++j) {
                if (i == j) {
                    distanceMatrix[i][j] = Double.POSITIVE_INFINITY;
                    continue;
                }
                double distanceEu = 0.0;
                for (l = 0; l < numReal; ++l) {
                    distanceEu += (examples[l][i] - examples[l][j]) * (examples[l][i] - examples[l][j]);
                }
                distanceMatrix[i][j] = distanceEu;
                distanceMatrix[j][i] = distanceEu;
            }
        }
        int[] clusters = new int[distanceMatrix.length];
        for (i = 0; i < clusters.length; ++i) {
            clusters[i] = i;
        }
        boolean[] LcClusters = new boolean[distanceMatrix.length];
        Arrays.fill(LcClusters, true);
        stop = false;
        while (!stop) {
            double minDist = Double.POSITIVE_INFINITY;
            int posi = -1;
            int posj = -1;
            for (i = 0; i < distanceMatrix.length; ++i) {
                if (!LcClusters[i]) continue;
                for (j = i + 1; j < distanceMatrix[i].length; ++j) {
                    if (!(distanceMatrix[i][j] < minDist)) continue;
                    posi = i;
                    posj = j;
                    minDist = distanceMatrix[i][j];
                }
            }
            double LcK = 0.0;
            if (posi >= 0 && posj >= 0) {
                int cont = 0;
                for (i = 0; i < this.instances.length; ++i) {
                    if (clusters[i] != clusters[posi] && clusters[i] != clusters[posj]) continue;
                    ++cont;
                    for (j = i + 1; j < this.instances.length; ++j) {
                        if (clusters[j] != clusters[posi] && clusters[j] != clusters[posj] || this.instances[i].getOutputNominalValuesInt(0) == this.instances[j].getOutputNominalValuesInt(0)) continue;
                        LcK += 1.0;
                    }
                }
                LcK = 1.0 - LcK / (double)cont;
            } else {
                stop = true;
            }
            if (LcK < Lc && !stop) {
                for (i = 0; i < LcClusters.length; ++i) {
                    if (clusters[i] != posi) continue;
                    LcClusters[i] = false;
                }
                stop = true;
                for (i = 0; i < LcClusters.length && stop; ++i) {
                    if (!LcClusters[i]) continue;
                    stop = false;
                }
                continue;
            }
            if (stop) continue;
            for (i = 0; i < clusters.length; ++i) {
                if (clusters[i] != clusters[posj]) continue;
                clusters[i] = clusters[posi];
            }
            for (i = 0; i < distanceMatrix.length; ++i) {
                if (i != posi && i != posj) {
                    for (j = 0; j < clusters.length; ++j) {
                        if (clusters[j] != clusters[posi]) continue;
                        distanceMatrix[i][j] = 0.5 * distanceMatrix[i][posi] + 0.5 * distanceMatrix[i][posj] - 0.25 * distanceMatrix[posi][posj];
                        distanceMatrix[j][i] = 0.5 * distanceMatrix[i][posi] + 0.5 * distanceMatrix[i][posj] - 0.25 * distanceMatrix[posi][posj];
                    }
                    continue;
                }
                for (j = 0; j < clusters.length; ++j) {
                    if (clusters[j] != clusters[posi]) continue;
                    distanceMatrix[i][j] = Double.POSITIVE_INFINITY;
                    distanceMatrix[j][i] = Double.POSITIVE_INFINITY;
                }
            }
        }
        boolean[] clustersHit = new boolean[distanceMatrix.length];
        Arrays.fill(clustersHit, false);
        for (i = 0; i < clusters.length; ++i) {
            clustersHit[clusters[i]] = true;
        }
        int numClusters = 0;
        for (i = 0; i < clustersHit.length; ++i) {
            if (!clustersHit[i]) continue;
            ++numClusters;
        }
        double[][][] clusterIntervals = new double[numClusters][numReal][2];
        int[] clusterID = new int[numClusters];
        for (i = 0; i < numClusters; ++i) {
            for (j = 0; j < numReal; ++j) {
                clusterIntervals[i][j][0] = Double.POSITIVE_INFINITY;
                clusterIntervals[i][j][1] = Double.NEGATIVE_INFINITY;
            }
        }
        j = 0;
        for (i = 0; i < clustersHit.length; ++i) {
            if (!clustersHit[i]) continue;
            clusterID[j] = i;
            for (l = 0; l < clusters.length; ++l) {
                if (clusters[l] != i) continue;
                for (m = 0; m < numReal; ++m) {
                    if (examplesCopy[m][l] < clusterIntervals[j][m][0]) {
                        clusterIntervals[j][m][0] = examplesCopy[m][l];
                    }
                    if (!(examplesCopy[m][l] > clusterIntervals[j][m][1])) continue;
                    clusterIntervals[j][m][1] = examplesCopy[m][l];
                }
            }
            ++j;
        }
        boolean bHit = false;
        i = 0;
        int atreal = 0;
        int a = 0;
        while (i < Parameters.numAttributes) {
            Attribute at = Attributes.getAttribute(a);
            if (at.getDirectionAttribute() == 1) {
                if (at.getType() == 2 || at.getType() == 1) {
                    this.realValues[i] = new double[this.instances.length];
                    int[] points = new int[this.instances.length];
                    int numPoints = 0;
                    boolean[] classesHit = new boolean[Parameters.numClasses];
                    for (j = 0; j < numClusters; ++j) {
                        stop = false;
                        Arrays.fill(classesHit, false);
                        int classesCont = 0;
                        for (l = 0; l < numClusters && !stop; ++l) {
                            if (j == l || !(clusterIntervals[j][atreal][0] >= clusterIntervals[l][atreal][0]) || !(clusterIntervals[j][atreal][1] <= clusterIntervals[l][atreal][1])) continue;
                            for (m = 0; m < this.classOfInstances.length; ++m) {
                                if (clusters[m] != clusterID[j] && clusters[m] != clusterID[l]) continue;
                                classesHit[this.classOfInstances[m]] = true;
                            }
                            for (m = 0; m < classesHit.length; ++m) {
                                if (!classesHit[m]) continue;
                                ++classesCont;
                            }
                            if (classesCont > true) continue;
                            stop = true;
                        }
                        if (stop) continue;
                        points[numPoints++] = j;
                        this.realValues[i][j] = clusterIntervals[j][atreal][0];
                    }
                    m = j;
                    double max = Double.NEGATIVE_INFINITY;
                    for (j = 0; j < numClusters; ++j) {
                        if (!(clusterIntervals[j][atreal][1] > max)) continue;
                        max = clusterIntervals[j][atreal][1];
                    }
                    if (!stop) {
                        points[numPoints++] = m;
                        this.realValues[i][m] = max;
                    }
                    this.sortValues(i, points, 0, numPoints - 1);
                    Vector<Double> cp = this.discretizeAttribute(i, points, 0, numPoints - 1);
                    if (cp.size() > 0) {
                        this.cutPoints[i] = new double[cp.size()];
                        for (j = 0; j < this.cutPoints[i].length; ++j) {
                            this.cutPoints[i][j] = cp.elementAt(j);
                            LogManager.println("Cut point " + j + " of attribute " + i + " : " + this.cutPoints[i][j]);
                        }
                    } else {
                        this.cutPoints[i] = null;
                    }
                    LogManager.println("Number of cut points of attribute " + i + " : " + cp.size());
                    ++atreal;
                } else {
                    this.realAttributes[i] = false;
                }
                ++i;
            } else {
                this.iClassIndex = a;
                bHit = true;
            }
            ++a;
        }
        if (!bHit) {
            this.iClassIndex = Parameters.numAttributes;
        }
    }

    @Override
    protected Vector<Double> discretizeAttribute(int attribute, int[] values, int begin, int end) {
        int j;
        int i;
        for (i = begin; i < end; ++i) {
            if (this.realValues[attribute][values[i]] != this.realValues[attribute][values[i + 1]]) continue;
            for (j = i; j < end; ++j) {
                values[j] = values[j + 1];
            }
            --end;
        }
        int[][] cd = new int[end][Parameters.numClasses];
        for (i = 0; i < cd.length; ++i) {
            Arrays.fill(cd[i], 0);
        }
        for (i = 0; i < this.instances.length; ++i) {
            for (j = 1; j <= end; ++j) {
                if (j < end) {
                    if (!(this.instances[i].getInputRealValues(attribute) < this.realValues[attribute][values[j]]) || !(this.instances[i].getInputRealValues(attribute) >= this.realValues[attribute][values[j - 1]])) continue;
                    int[] nArray = cd[j - 1];
                    int n = this.classOfInstances[i];
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (!(this.instances[i].getInputRealValues(attribute) <= this.realValues[attribute][values[j]]) || !(this.instances[i].getInputRealValues(attribute) >= this.realValues[attribute][values[j - 1]])) continue;
                int[] nArray = cd[j - 1];
                int n = this.classOfInstances[i];
                nArray[n] = nArray[n] + 1;
            }
        }
        Vector<Double> cutPoints = new Vector<Double>();
        for (i = 1; i < end; ++i) {
            if (!(this.computeEntropy(cd[i - 1], cd[i]) > 0.0)) continue;
            cutPoints.addElement(new Double(this.realValues[attribute][values[i]]));
        }
        return cutPoints;
    }

    public double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    double computeEntropy(int[] cd1, int[] cd2) {
        int i;
        double ent = 0.0;
        int numValues = 0;
        for (i = 0; i < cd1.length; ++i) {
            numValues += cd1[i] + cd2[i];
        }
        int size = cd1.length;
        for (i = 0; i < size; ++i) {
            double prob = cd1[i] + cd2[i];
            if (!((prob /= (double)numValues) > 0.0)) continue;
            ent += prob * Math.log(prob) / Math.log(2.0);
        }
        return -ent;
    }
}

