/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import moa.gui.FileExtensionFilter;
import moa.gui.clustertab.ClusteringSetupTab;
import moa.gui.clustertab.ClusteringVisualEvalPanel;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.RunVisualizer;
import moa.gui.visualization.StreamPanel;

public class ClusteringVisualTab
extends JPanel
implements ActionListener {
    private RunVisualizer visualizer = null;
    private Thread visualizerThread = null;
    private Boolean running = false;
    private ClusteringSetupTab clusteringSetupTab = null;
    private String exportFile;
    private String screenshotFilebase;
    private JButton buttonRun;
    private JButton buttonScreenshot;
    private JButton buttonStop;
    private JButton buttonZoomInX;
    private JButton buttonZoomInY;
    private JButton buttonZoomOutX;
    private JButton buttonZoomOutY;
    private JCheckBox checkboxDrawClustering;
    private JCheckBox checkboxDrawGT;
    private JCheckBox checkboxDrawMicro;
    private JCheckBox checkboxDrawPoints;
    private ClusteringVisualEvalPanel clusteringVisualEvalPanel1;
    private JComboBox comboX;
    private JComboBox comboY;
    private GraphCanvas graphCanvas;
    private JPanel graphPanel;
    private JPanel graphPanelControlBottom;
    private JPanel graphPanelControlTop;
    private JScrollPane graphScrollPanel;
    private JLabel jLabel1;
    private JSplitPane jSplitPane1;
    private JLabel labelEvents;
    private JLabel labelNumPause;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel label_processed_points;
    private JLabel label_processed_points_value;
    private JTextField numPauseAfterPoints;
    private JPanel panelControl;
    private JPanel panelEvalOutput;
    private JPanel panelVisualWrapper;
    private JScrollPane scrollPane0;
    private JScrollPane scrollPane1;
    private JSlider speedSlider;
    private JSplitPane splitVisual;
    private StreamPanel streamPanel0;
    private StreamPanel streamPanel1;
    private JPanel topWrapper;

    public ClusteringVisualTab() {
        this.resetComponents();
    }

    private void resetComponents() {
        this.initComponents();
        this.comboY.setSelectedIndex(1);
        this.graphCanvas.setViewport(this.graphScrollPanel.getViewport());
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        ToolTipManager.sharedInstance().setInitialDelay(100);
    }

    public void setClusteringSetupTab(ClusteringSetupTab clusteringSetupTab) {
        this.clusteringSetupTab = clusteringSetupTab;
    }

    private void createVisualiterThread() {
        this.visualizer = new RunVisualizer(this, this.clusteringSetupTab);
        this.visualizerThread = new Thread(this.visualizer);
    }

    public void setDimensionComobBoxes(int numDimensions) {
        String[] dimensions = new String[numDimensions];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = "Dim " + (i + 1);
        }
        this.comboX.setModel(new DefaultComboBoxModel<String>(dimensions));
        this.comboY.setModel(new DefaultComboBoxModel<String>(dimensions));
        this.comboY.setSelectedIndex(1);
    }

    public StreamPanel getLeftStreamPanel() {
        return this.streamPanel0;
    }

    public StreamPanel getRightStreamPanel() {
        return this.streamPanel1;
    }

    public GraphCanvas getGraphCanvas() {
        return this.graphCanvas;
    }

    public ClusteringVisualEvalPanel getEvalPanel() {
        return this.clusteringVisualEvalPanel1;
    }

    public boolean isEnabledDrawPoints() {
        return this.checkboxDrawPoints.isSelected();
    }

    public boolean isEnabledDrawGroundTruth() {
        return this.checkboxDrawGT.isSelected();
    }

    public boolean isEnabledDrawMicroclustering() {
        return this.checkboxDrawMicro.isSelected();
    }

    public boolean isEnabledDrawClustering() {
        return this.checkboxDrawClustering.isSelected();
    }

    public void setProcessedPointsCounter(int value) {
        this.label_processed_points_value.setText(Integer.toString(value));
    }

    public int getPauseInterval() {
        return Integer.parseInt(this.numPauseAfterPoints.getText());
    }

    public void setPauseInterval(int pause) {
        this.numPauseAfterPoints.setText(Integer.toString(pause));
    }

    public void repaint() {
        if (this.splitVisual != null) {
            this.splitVisual.setDividerLocation(this.splitVisual.getWidth() / 2);
        }
        super.repaint();
    }

    public void toggleVisualizer(boolean internal) {
        if (this.visualizer == null) {
            this.createVisualiterThread();
        }
        if (!this.visualizerThread.isAlive()) {
            this.visualizerThread.start();
        }
        if (this.running.booleanValue()) {
            this.running = false;
            ClusteringVisualTab clusteringVisualTab = this;
            clusteringVisualTab.visualizer.pause();
            this.buttonRun.setText("Resume");
        } else {
            this.running = true;
            ClusteringVisualTab clusteringVisualTab = this;
            clusteringVisualTab.visualizer.resume();
            this.buttonRun.setText("Pause");
        }
        if (internal) {
            this.clusteringSetupTab.toggleRunMode();
        }
    }

    public void stopVisualizer() {
        this.visualizer.stop();
        this.running = false;
        this.visualizer = null;
        this.visualizerThread = null;
        this.removeAll();
        this.resetComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.topWrapper = new JPanel();
        this.panelVisualWrapper = new JPanel();
        this.splitVisual = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.streamPanel1 = new StreamPanel();
        this.scrollPane0 = new JScrollPane();
        this.streamPanel0 = new StreamPanel();
        this.panelControl = new JPanel();
        this.buttonRun = new JButton();
        this.buttonStop = new JButton();
        this.buttonScreenshot = new JButton();
        this.speedSlider = new JSlider();
        this.jLabel1 = new JLabel();
        this.comboX = new JComboBox();
        this.labelX = new JLabel();
        this.comboY = new JComboBox();
        this.labelY = new JLabel();
        this.checkboxDrawPoints = new JCheckBox();
        this.checkboxDrawGT = new JCheckBox();
        this.checkboxDrawMicro = new JCheckBox();
        this.checkboxDrawClustering = new JCheckBox();
        this.label_processed_points = new JLabel();
        this.label_processed_points_value = new JLabel();
        this.labelNumPause = new JLabel();
        this.numPauseAfterPoints = new JTextField();
        this.panelEvalOutput = new JPanel();
        this.clusteringVisualEvalPanel1 = new ClusteringVisualEvalPanel();
        this.graphPanel = new JPanel();
        this.graphPanelControlTop = new JPanel();
        this.buttonZoomInY = new JButton();
        this.buttonZoomOutY = new JButton();
        this.labelEvents = new JLabel();
        this.graphScrollPanel = new JScrollPane();
        this.graphCanvas = new GraphCanvas();
        this.graphPanelControlBottom = new JPanel();
        this.buttonZoomInX = new JButton();
        this.buttonZoomOutX = new JButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.topWrapper.setPreferredSize(new Dimension(688, 500));
        this.topWrapper.setLayout(new GridBagLayout());
        this.panelVisualWrapper.setBorder(BorderFactory.createBevelBorder(0));
        this.panelVisualWrapper.setLayout(new BorderLayout());
        this.splitVisual.setDividerLocation(403);
        this.splitVisual.setResizeWeight(1.0);
        this.streamPanel1.setPreferredSize(new Dimension(400, 250));
        GroupLayout streamPanel1Layout = new GroupLayout(this.streamPanel1);
        this.streamPanel1.setLayout(streamPanel1Layout);
        streamPanel1Layout.setHorizontalGroup(streamPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 428, Short.MAX_VALUE));
        streamPanel1Layout.setVerticalGroup(streamPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 339, Short.MAX_VALUE));
        this.scrollPane1.setViewportView(this.streamPanel1);
        this.splitVisual.setRightComponent(this.scrollPane1);
        this.scrollPane0.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                ClusteringVisualTab.this.scrollPane0MouseWheelMoved(evt);
            }
        });
        this.streamPanel0.setPreferredSize(new Dimension(400, 250));
        GroupLayout streamPanel0Layout = new GroupLayout(this.streamPanel0);
        this.streamPanel0.setLayout(streamPanel0Layout);
        streamPanel0Layout.setHorizontalGroup(streamPanel0Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        streamPanel0Layout.setVerticalGroup(streamPanel0Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 339, Short.MAX_VALUE));
        this.scrollPane0.setViewportView(this.streamPanel0);
        this.splitVisual.setLeftComponent(this.scrollPane0);
        this.panelVisualWrapper.add((Component)this.splitVisual, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 400;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topWrapper.add((Component)this.panelVisualWrapper, gridBagConstraints);
        this.panelControl.setMinimumSize(new Dimension(600, 76));
        this.panelControl.setPreferredSize(new Dimension(2000, 76));
        this.panelControl.setLayout(new GridBagLayout());
        this.buttonRun.setText("Start");
        this.buttonRun.setPreferredSize(new Dimension(70, 33));
        this.buttonRun.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ClusteringVisualTab.this.buttonRunMouseClicked(evt);
            }
        });
        this.buttonRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonRunActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 5, 1, 5);
        this.panelControl.add((Component)this.buttonRun, gridBagConstraints);
        this.buttonStop.setText("Stop");
        this.buttonStop.setPreferredSize(new Dimension(70, 33));
        this.buttonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.panelControl.add((Component)this.buttonStop, gridBagConstraints);
        this.buttonScreenshot.setText("Screenshot");
        this.buttonScreenshot.setPreferredSize(new Dimension(90, 23));
        this.buttonScreenshot.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ClusteringVisualTab.this.buttonScreenshotMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 5, 1, 5);
        this.speedSlider.setValue(100);
        this.speedSlider.setBorder(BorderFactory.createTitledBorder("Visualisation Speed"));
        this.speedSlider.setMinimumSize(new Dimension(150, 68));
        this.speedSlider.setPreferredSize(new Dimension(160, 68));
        this.speedSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ClusteringVisualTab.this.speedSliderMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 16, 1, 5);
        this.panelControl.add((Component)this.speedSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelControl.add((Component)this.jLabel1, gridBagConstraints);
        this.comboX.setModel(new DefaultComboBoxModel<String>(new String[]{"Dim 1", "Dim 2", "Dim 3", "Dim 4"}));
        this.comboX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.comboXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.comboX, gridBagConstraints);
        this.labelX.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 14, 0, 5);
        this.panelControl.add((Component)this.labelX, gridBagConstraints);
        this.comboY.setModel(new DefaultComboBoxModel<String>(new String[]{"Dim 1", "Dim 2", "Dim 3", "Dim 4"}));
        this.comboY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.comboYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.comboY, gridBagConstraints);
        this.labelY.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 14, 0, 5);
        this.panelControl.add((Component)this.labelY, gridBagConstraints);
        this.checkboxDrawPoints.setSelected(true);
        this.checkboxDrawPoints.setText("Points");
        this.checkboxDrawPoints.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.checkboxDrawPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawPoints, gridBagConstraints);
        this.checkboxDrawGT.setSelected(true);
        this.checkboxDrawGT.setText("Ground truth");
        this.checkboxDrawGT.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawGT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.checkboxDrawGTActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawGT, gridBagConstraints);
        this.checkboxDrawMicro.setSelected(true);
        this.checkboxDrawMicro.setText("Microclustering");
        this.checkboxDrawMicro.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawMicro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.checkboxDrawMicroActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawMicro, gridBagConstraints);
        this.checkboxDrawClustering.setSelected(true);
        this.checkboxDrawClustering.setText("Clustering");
        this.checkboxDrawClustering.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawClustering.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.checkboxDrawClusteringActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawClustering, gridBagConstraints);
        this.label_processed_points.setText("Processed:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.panelControl.add((Component)this.label_processed_points, gridBagConstraints);
        this.label_processed_points_value.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelControl.add((Component)this.label_processed_points_value, gridBagConstraints);
        this.labelNumPause.setText("Pause in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.panelControl.add((Component)this.labelNumPause, gridBagConstraints);
        this.numPauseAfterPoints.setHorizontalAlignment(4);
        this.numPauseAfterPoints.setText(Integer.toString(5000));
        this.numPauseAfterPoints.setMinimumSize(new Dimension(70, 25));
        this.numPauseAfterPoints.setPreferredSize(new Dimension(70, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelControl.add((Component)this.numPauseAfterPoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.topWrapper.add((Component)this.panelControl, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.topWrapper);
        this.panelEvalOutput.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.panelEvalOutput.setLayout(new GridBagLayout());
        this.clusteringVisualEvalPanel1.setMinimumSize(new Dimension(280, 118));
        this.clusteringVisualEvalPanel1.setPreferredSize(new Dimension(290, 115));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.clusteringVisualEvalPanel1, gridBagConstraints);
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.graphPanel.setPreferredSize(new Dimension(530, 115));
        this.graphPanel.setLayout(new GridBagLayout());
        this.graphPanelControlTop.setLayout(new GridBagLayout());
        this.buttonZoomInY.setText("Zoom in Y");
        this.buttonZoomInY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonZoomInYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomInY, gridBagConstraints);
        this.buttonZoomOutY.setText("Zoom out Y");
        this.buttonZoomOutY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonZoomOutYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomOutY, gridBagConstraints);
        this.labelEvents.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.labelEvents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.graphPanel.add((Component)this.graphPanelControlTop, gridBagConstraints);
        this.graphCanvas.setPreferredSize(new Dimension(500, 111));
        GroupLayout graphCanvasLayout = new GroupLayout(this.graphCanvas);
        this.graphCanvas.setLayout(graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.graphScrollPanel.setViewportView(this.graphCanvas);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.graphPanel.add((Component)this.graphScrollPanel, gridBagConstraints);
        this.buttonZoomInX.setText("Zoom in X");
        this.buttonZoomInX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonZoomInXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomInX);
        this.buttonZoomOutX.setText("Zoom out X");
        this.buttonZoomOutX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringVisualTab.this.buttonZoomOutXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomOutX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.graphPanel.add((Component)this.graphPanelControlBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.graphPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.panelEvalOutput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void buttonScreenshotMouseClicked(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (this.screenshotFilebase != null) {
            fileChooser.setSelectedFile(new File(this.screenshotFilebase));
        }
        if (fileChooser.showSaveDialog(this) == 0) {
            this.screenshotFilebase = fileChooser.getSelectedFile().getPath();
            this.streamPanel0.screenshot(this.screenshotFilebase + "_" + this.label_processed_points_value.getText() + "_0", true, true);
            this.streamPanel1.screenshot(this.screenshotFilebase + "_" + this.label_processed_points_value.getText() + "_1", true, true);
        }
    }

    private void buttonRunMouseClicked(MouseEvent evt) {
        this.toggleVisualizer(true);
    }

    private void speedSliderMouseDragged(MouseEvent evt) {
        this.visualizer.setSpeed((int)((double)this.speedSlider.getValue() / 6.666666666666667));
    }

    private void scrollPane0MouseWheelMoved(MouseWheelEvent evt) {
        this.streamPanel0.setZoom(evt.getX(), evt.getY(), -1 * evt.getWheelRotation(), this.scrollPane0);
    }

    private void buttonZoomInXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(false);
    }

    private void buttonZoomOutYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
    }

    private void buttonZoomOutXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(true);
    }

    private void buttonZoomInYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
    }

    private void checkboxDrawPointsActionPerformed(ActionEvent evt) {
        this.visualizer.setPointLayerVisibility(this.checkboxDrawPoints.isSelected());
    }

    private void checkboxDrawMicroActionPerformed(ActionEvent evt) {
        this.visualizer.setMicroLayerVisibility(this.checkboxDrawMicro.isSelected());
    }

    private void checkboxDrawGTActionPerformed(ActionEvent evt) {
        this.visualizer.setGroundTruthVisibility(this.checkboxDrawGT.isSelected());
    }

    private void checkboxDrawClusteringActionPerformed(ActionEvent evt) {
        this.visualizer.setMacroVisibility(this.checkboxDrawClustering.isSelected());
    }

    private void comboXActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int dim = cb.getSelectedIndex();
        this.streamPanel0.setActiveXDim(dim);
        this.streamPanel1.setActiveXDim(dim);
        if (this.visualizer != null) {
            this.visualizer.redraw();
        }
    }

    private void comboYActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int dim = cb.getSelectedIndex();
        this.streamPanel0.setActiveYDim(dim);
        this.streamPanel1.setActiveYDim(dim);
        if (this.visualizer != null) {
            this.visualizer.redraw();
        }
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
        this.stopVisualizer();
        this.clusteringSetupTab.stopRun();
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("csv export")) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter(new FileExtensionFilter("csv"));
                if (this.exportFile != null) {
                    fileChooser.setSelectedFile(new File(this.exportFile));
                }
                if (fileChooser.showSaveDialog(this) == 0) {
                    this.exportFile = fileChooser.getSelectedFile().getPath();
                    this.visualizer.exportCSV(this.exportFile);
                }
            }
            if (e.getActionCommand().equals("weka export")) {
                this.visualizer.weka();
            }
        }
    }
}

