/*
 * Decompiled with CFR 0.152.
 */
package AlgorithmTesting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class DataSetupForCSVFile {
    private final ArrayList<double[]> X_y = new ArrayList();
    private int K;
    private boolean file_has_header;

    public DataSetupForCSVFile(File file, boolean bl) {
        this.file_has_header = bl;
        try {
            this.LoadDataIntoXyFormatAndFindFeatureNamesAndP(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.extractNumClassesFromDataMatrix();
    }

    private void extractNumClassesFromDataMatrix() {
        HashSet<Double> hashSet = new HashSet<Double>();
        for (double[] dArray : this.X_y) {
            double d = dArray[dArray.length - 1];
            hashSet.add(d);
        }
        this.K = hashSet.size();
    }

    private void LoadDataIntoXyFormatAndFindFeatureNamesAndP(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split(",");
            if (n != 0 || !this.file_has_header) {
                double[] dArray = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[i] = Double.NaN;
                    }
                }
                this.X_y.add(dArray);
            }
            ++n;
        }
        bufferedReader.close();
    }

    public int getK() {
        return this.K;
    }

    public ArrayList<double[]> getX_y() {
        return this.X_y;
    }
}

