# start the RNG with a seed for reproducibility
set.seed(0)
xy<-calculateCircle(0,0,200,50,randomDist=TRUE,noiseFun=function(x) (x+rnorm(1,mean=0,sd=50)))
plot(xy[,1],xy[,2],xlim=c(-250,250),ylim=c(-250,250));par(new=TRUE)
c1 <- CircleFitByTaubin(xy)
xyc1<-calculateCircle(c1[1],c1[2],c1[3])
plot(xyc1[,1],xyc1[,2],xlim=c(-250,250),ylim=c(-250,250),col='red',type='l');par(new=TRUE)
c2 <- CircleFitByPratt(xy)
xyc2<-calculateCircle(c2[1],c2[2],c2[3])
plot(xyc2[,1],xyc2[,2],xlim=c(-250,250),ylim=c(-250,250),col='blue',type='l');par(new=TRUE)
c3 <- CircleFitByKasa(xy)
xyc3<-calculateCircle(c3[1],c3[2],c3[3])
plot(xyc3[,1],xyc3[,2],xlim=c(-250,250),ylim=c(-250,250),col='green',type='l');par(new=TRUE)
c4 <- LMcircleFit(xy)
xyc4<-calculateCircle(c4[1],c4[2],c4[3])
plot(xyc4[,1],xyc4[,2],xlim=c(-250,250),ylim=c(-250,250),col='cyan',type='l');par(new=TRUE)
c5 <- CircleFitBySpath(xy)
xyc5<-calculateCircle(c5[1],c5[2],c5[3])
plot(xyc5[,1],xyc5[,2],xlim=c(-250,250),ylim=c(-250,250),col='magenta',type='l');par(new=TRUE)
c6 <- CircleFitByLandau(xy)
xyc6<-calculateCircle(c6[1],c6[2],c6[3])
plot(xyc6[,1],xyc6[,2],xlim=c(-250,250),ylim=c(-250,250),col='purple',type='l');par(new=TRUE)
c7 <- LMreducedCircleFit(xy)
xyc7<-calculateCircle(c7[1],c7[2],c7[3])
plot(xyc7[,1],xyc7[,2],xlim=c(-250,250),ylim=c(-250,250),col='pink',type='l');par(new=TRUE)

# plot the center for each fitted circle
plot(0,0,xlim=c(-250,250),ylim=c(-250,250),pch=4);par(new=TRUE)
plot(c1[1],c1[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='red');par(new=TRUE)
plot(c1[1],c2[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='blue');par(new=TRUE)
plot(c1[1],c3[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='green');par(new=TRUE)
plot(c1[1],c4[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='cyan');par(new=TRUE)
plot(c1[1],c5[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='magenta');par(new=TRUE)
plot(c1[1],c6[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='purple');par(new=TRUE)
plot(c1[1],c7[2],xlim=c(-250,250),ylim=c(-250,250),pch=3,col='pink')

estimateInitialGuessCircle(xy)
# -13.74472 -23.17132 214.88157
