/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.eval;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.corehunter.data.FrequencyGenotypeData;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;

public abstract class AllelicDiversityEvaluation
implements Evaluation {
    private final double[][] origAverageGenotype;
    private double[][] averageGenotype;
    private final int numSelected;

    public AllelicDiversityEvaluation(Collection<Integer> ids, FrequencyGenotypeData data) {
        this.numSelected = ids.size();
        int numMarkers = data.getNumberOfMarkers();
        this.origAverageGenotype = new double[numMarkers][];
        for (int m = 0; m < numMarkers; ++m) {
            int numAlleles = data.getNumberOfAlleles(m);
            this.origAverageGenotype[m] = new double[numAlleles];
            if (this.numSelected <= 0) continue;
            for (int a = 0; a < numAlleles; ++a) {
                double avgFreq;
                double freqSum = 0.0;
                for (int id : ids) {
                    freqSum += this.frequency(data, id, m, a);
                }
                this.origAverageGenotype[m][a] = avgFreq = freqSum / (double)this.numSelected;
            }
        }
        this.resolveMissingValues();
    }

    public AllelicDiversityEvaluation(AllelicDiversityEvaluation curEval, Set<Integer> add, Set<Integer> remove, FrequencyGenotypeData data) {
        int origNumSelected = curEval.numSelected;
        this.numSelected = origNumSelected + add.size() - remove.size();
        if (this.numSelected == 0) {
            this.origAverageGenotype = this.init2Darray(curEval.origAverageGenotype);
        } else {
            this.origAverageGenotype = this.copy2Darray(curEval.origAverageGenotype);
            for (int m = 0; m < this.origAverageGenotype.length; ++m) {
                int a = 0;
                while (a < this.origAverageGenotype[m].length) {
                    if (origNumSelected > 0) {
                        double[] dArray = this.origAverageGenotype[m];
                        int n = a;
                        dArray[n] = dArray[n] * (double)origNumSelected;
                    }
                    for (int id : add) {
                        double[] dArray = this.origAverageGenotype[m];
                        int n = a;
                        dArray[n] = dArray[n] + this.frequency(data, id, m, a);
                    }
                    for (int id : remove) {
                        double[] dArray = this.origAverageGenotype[m];
                        int n = a;
                        dArray[n] = dArray[n] - this.frequency(data, id, m, a);
                    }
                    double[] dArray = this.origAverageGenotype[m];
                    int n = a++;
                    dArray[n] = dArray[n] / (double)this.numSelected;
                }
            }
        }
        this.resolveMissingValues();
    }

    private double frequency(FrequencyGenotypeData data, int id, int m, int a) {
        double freq = data.getAlleleFrequency(id, m, a);
        return Double.isNaN(freq) ? 0.0 : freq;
    }

    private void resolveMissingValues() {
        if (this.numSelected > 0) {
            this.averageGenotype = this.copy2Darray(this.origAverageGenotype);
            for (int m = 0; m < this.averageGenotype.length; ++m) {
                double[] alleleFreqs = this.averageGenotype[m];
                int mostCommonAllele = 0;
                double mostCommonAlleleFreq = alleleFreqs[0];
                double freqSum = alleleFreqs[0];
                for (int a = 1; a < alleleFreqs.length; ++a) {
                    freqSum += alleleFreqs[a];
                    if (!(alleleFreqs[a] > mostCommonAlleleFreq)) continue;
                    mostCommonAllele = a;
                    mostCommonAlleleFreq = alleleFreqs[a];
                }
                int n = mostCommonAllele;
                alleleFreqs[n] = alleleFreqs[n] + (1.0 - freqSum);
            }
        } else {
            this.averageGenotype = this.init2Darray(this.origAverageGenotype);
        }
    }

    private double[][] init2Darray(double[][] template) {
        double[][] array = new double[template.length][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new double[template[i].length];
        }
        return array;
    }

    private double[][] copy2Darray(double[][] toCopy) {
        double[][] copy = new double[toCopy.length][];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = Arrays.copyOf(toCopy[i], toCopy[i].length);
        }
        return copy;
    }

    public double[][] getAverageGenotype() {
        return this.averageGenotype;
    }

    public int getNumSelected() {
        return this.numSelected;
    }
}

