/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.problems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.constraints.Constraint;
import org.jamesframework.core.problems.constraints.PenalizingConstraint;
import org.jamesframework.core.problems.constraints.validations.PenalizingValidation;
import org.jamesframework.core.problems.constraints.validations.SimpleValidation;
import org.jamesframework.core.problems.constraints.validations.UnanimousValidation;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.objectives.evaluations.PenalizedEvaluation;
import org.jamesframework.core.problems.sol.RandomSolutionGenerator;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.neigh.Move;

public class GenericProblem<SolutionType extends Solution, DataType>
implements Problem<SolutionType> {
    private Objective<? super SolutionType, ? super DataType> objective;
    private DataType data;
    private final List<Constraint<? super SolutionType, ? super DataType>> mandatoryConstraints;
    private final List<Constraint<? super SolutionType, ? super DataType>> mandatoryConstraintsView;
    private final List<PenalizingConstraint<? super SolutionType, ? super DataType>> penalizingConstraints;
    private final List<PenalizingConstraint<? super SolutionType, ? super DataType>> penalizingConstraintsView;
    private RandomSolutionGenerator<? extends SolutionType, ? super DataType> randomSolutionGenerator;

    public GenericProblem(DataType data, Objective<? super SolutionType, ? super DataType> objective, RandomSolutionGenerator<? extends SolutionType, ? super DataType> randomSolutionGenerator) {
        if (objective == null) {
            throw new NullPointerException("Error while creating generic problem: null not allowed for objective.");
        }
        if (randomSolutionGenerator == null) {
            throw new NullPointerException("Error while creating generic problem: null not allowed for random solution generator.");
        }
        this.data = data;
        this.objective = objective;
        this.randomSolutionGenerator = randomSolutionGenerator;
        this.mandatoryConstraints = new ArrayList<Constraint<? super SolutionType, ? super DataType>>();
        this.penalizingConstraints = new ArrayList<PenalizingConstraint<? super SolutionType, ? super DataType>>();
        this.mandatoryConstraintsView = Collections.unmodifiableList(this.mandatoryConstraints);
        this.penalizingConstraintsView = Collections.unmodifiableList(this.penalizingConstraints);
    }

    public Objective<? super SolutionType, ? super DataType> getObjective() {
        return this.objective;
    }

    public void setObjective(Objective<? super SolutionType, ? super DataType> objective) {
        if (objective == null) {
            throw new NullPointerException("Error while setting objective: null is not allowed.");
        }
        this.objective = objective;
    }

    public RandomSolutionGenerator<? extends SolutionType, ? super DataType> getRandomSolutionGenerator() {
        return this.randomSolutionGenerator;
    }

    public void setRandomSolutionGenerator(RandomSolutionGenerator<? extends SolutionType, ? super DataType> randomSolutionGenerator) {
        if (randomSolutionGenerator == null) {
            throw new NullPointerException("Error while setting random solution generator: null is not allowed");
        }
        this.randomSolutionGenerator = randomSolutionGenerator;
    }

    public DataType getData() {
        return this.data;
    }

    public void setData(DataType data) {
        this.data = data;
    }

    public void addMandatoryConstraint(Constraint<? super SolutionType, ? super DataType> constraint) {
        this.mandatoryConstraints.add(constraint);
    }

    public boolean removeMandatoryConstraint(Constraint<? super SolutionType, ? super DataType> constraint) {
        return this.mandatoryConstraints.remove(constraint);
    }

    public List<Constraint<? super SolutionType, ? super DataType>> getMandatoryConstraints() {
        return this.mandatoryConstraintsView;
    }

    public void addPenalizingConstraint(PenalizingConstraint<? super SolutionType, ? super DataType> constraint) {
        this.penalizingConstraints.add(constraint);
    }

    public boolean removePenalizingConstraint(PenalizingConstraint<? super SolutionType, ? super DataType> constraint) {
        return this.penalizingConstraints.remove(constraint);
    }

    public List<PenalizingConstraint<? super SolutionType, ? super DataType>> getPenalizingConstraints() {
        return this.penalizingConstraintsView;
    }

    @Override
    public Validation validate(SolutionType solution) {
        if (this.mandatoryConstraints.isEmpty()) {
            return SimpleValidation.PASSED;
        }
        if (this.mandatoryConstraints.size() == 1) {
            return this.mandatoryConstraints.get(0).validate(solution, this.data);
        }
        UnanimousValidation val = new UnanimousValidation();
        this.mandatoryConstraints.stream().allMatch(c -> {
            Validation cval = c.validate(solution, this.data);
            val.addValidation(c, cval);
            return cval.passed();
        });
        return val;
    }

    @Override
    public Validation validate(Move<? super SolutionType> move, SolutionType curSolution, Validation curValidation) {
        if (this.mandatoryConstraints.isEmpty()) {
            return SimpleValidation.PASSED;
        }
        if (this.mandatoryConstraints.size() == 1) {
            return this.mandatoryConstraints.get(0).validate(move, curSolution, curValidation, this.data);
        }
        UnanimousValidation curUnanimousVal = (UnanimousValidation)curValidation;
        UnanimousValidation newUnanimousVal = new UnanimousValidation();
        this.mandatoryConstraints.stream().allMatch(c -> {
            Validation curval = curUnanimousVal.getValidation(c);
            if (curval == null) {
                curval = c.validate(curSolution, this.data);
            }
            Validation newval = c.validate(move, curSolution, curval, this.data);
            newUnanimousVal.addValidation(c, newval);
            return newval.passed();
        });
        return newUnanimousVal;
    }

    public Collection<Constraint<? super SolutionType, ? super DataType>> getViolatedConstraints(SolutionType solution) {
        return Stream.concat(this.mandatoryConstraints.stream(), this.penalizingConstraints.stream()).filter(c -> !c.validate(solution, this.data).passed()).collect(Collectors.toSet());
    }

    @Override
    public Evaluation evaluate(SolutionType solution) {
        if (this.penalizingConstraints.isEmpty()) {
            return this.objective.evaluate(solution, this.data);
        }
        Evaluation eval = this.objective.evaluate(solution, this.data);
        PenalizedEvaluation penEval = new PenalizedEvaluation(eval, this.isMinimizing());
        this.penalizingConstraints.forEach(pc -> penEval.addPenalizingValidation(pc, (PenalizingValidation)pc.validate((Solution)solution, (Object)this.data)));
        return penEval;
    }

    @Override
    public Evaluation evaluate(Move<? super SolutionType> move, SolutionType curSolution, Evaluation curEvaluation) {
        if (this.penalizingConstraints.isEmpty()) {
            return this.objective.evaluate(move, curSolution, curEvaluation, this.data);
        }
        PenalizedEvaluation curPenalizedEval = (PenalizedEvaluation)curEvaluation;
        Evaluation curEval = curPenalizedEval.getEvaluation();
        Evaluation newEval = this.objective.evaluate(move, curSolution, curEval, this.data);
        PenalizedEvaluation newPenalizedEval = new PenalizedEvaluation(newEval, this.isMinimizing());
        this.penalizingConstraints.forEach(pc -> {
            PenalizingValidation curVal = curPenalizedEval.getPenalizingValidation(pc);
            Validation newVal = pc.validate(move, (Solution)curSolution, (Validation)curVal, (Object)this.data);
            newPenalizedEval.addPenalizingValidation(pc, (PenalizingValidation)newVal);
        });
        return newPenalizedEval;
    }

    @Override
    public SolutionType createRandomSolution(Random rnd) {
        return this.randomSolutionGenerator.create(rnd, this.data);
    }

    @Override
    public boolean isMinimizing() {
        return this.objective.isMinimizing();
    }
}

