/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.problems.sol;

import org.jamesframework.core.exceptions.SolutionCopyException;

public abstract class Solution {
    public static <T extends Solution> T checkedCopy(T solution) {
        Solution copy = solution.copy();
        if (copy == null) {
            throw new SolutionCopyException("Deep copy of solution of type " + solution.getClass().getSimpleName() + " failed. " + "Calling copy() yields null.");
        }
        Class<?> origClass = solution.getClass();
        Class<?> copyClass = copy.getClass();
        if (copyClass == origClass) {
            return (T)copy;
        }
        try {
            Class<?> declaringClassOfCopy = origClass.getMethod("copy", new Class[0]).getDeclaringClass();
            if (declaringClassOfCopy != origClass) {
                throw new SolutionCopyException("Deep copy of solution of type " + origClass.getSimpleName() + " failed. " + "Calling copy() yields a solution of type " + copyClass.getSimpleName() + ", not " + origClass.getSimpleName() + ". Expected cause of this type mismatch: " + origClass.getSimpleName() + " does not directly implement method copy() but " + "inherits an undesired implementation from super class " + declaringClassOfCopy.getSimpleName() + ".");
            }
            throw new SolutionCopyException("Deep copy of solution of type " + origClass.getSimpleName() + " failed. " + "Calling copy() yields a solution of type " + copyClass.getSimpleName() + ", not " + origClass.getSimpleName() + ". Expected cause of this type mismatch: " + "faulty implementation of copy() in " + origClass.getSimpleName() + ", " + "does not return solution of type " + origClass.getSimpleName() + ".");
        }
        catch (NoSuchMethodException noSuchMethodEx) {
            throw new Error("Solution without method 'copy()': this should never happen; if it does, there is a serious bug in Solution.", noSuchMethodEx);
        }
    }

    public abstract Solution copy();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

