/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.merger;

import choco.cp.common.util.preprocessor.merger.IntegerVariableMerger;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.variables.scheduling.TaskVariable;
import gnu.trove.THashSet;
import java.util.Set;

public class TaskVariableMerger {
    public IntegerVariableMerger start;
    public IntegerVariableMerger duration;
    public IntegerVariableMerger end;
    private Set<String> optionsSet = new THashSet<String>();

    public TaskVariableMerger() {
    }

    public TaskVariableMerger(TaskVariable v) {
        this();
        this.start = new IntegerVariableMerger(v.start());
        this.duration = new IntegerVariableMerger(v.duration());
        this.end = new IntegerVariableMerger(v.end());
        this.optionsSet.addAll(v.getOptions());
    }

    public void copy(TaskVariableMerger toCopy) {
        this.start = toCopy.start;
        this.duration = toCopy.duration;
        this.end = toCopy.end;
        this.optionsSet = toCopy.optionsSet;
    }

    public TaskVariable create() {
        return new TaskVariable(StringUtils.randomName(), this.start.create(), this.duration.create(), this.end.create());
    }

    public boolean intersection(TaskVariable d) {
        if (this.start == null) {
            this.start = new IntegerVariableMerger(d.start());
        } else if (!this.start.intersection(d.start())) {
            return false;
        }
        if (this.duration == null) {
            this.duration = new IntegerVariableMerger(d.duration());
        } else if (!this.duration.intersection(d.duration())) {
            return false;
        }
        if (this.end == null) {
            this.end = new IntegerVariableMerger(d.end());
        } else if (!this.end.intersection(d.end())) {
            return false;
        }
        THashSet<String> toptionsSet = new THashSet<String>();
        if (d.getOptions().contains("cp:decision") || this.optionsSet.contains("cp:decision")) {
            toptionsSet.add("cp:decision");
        }
        if (d.getOptions().contains("cp:no_decision") || this.optionsSet.contains("cp:no_decision")) {
            toptionsSet.add("cp:no_decision");
        }
        if (d.getOptions().contains("cp:objective") || this.optionsSet.contains("cp:objective")) {
            toptionsSet.add("cp:objective");
        }
        this.optionsSet = toptionsSet;
        return true;
    }
}

