/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.TerminateToolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmdLineTool {
    protected CmdLineTool() {
    }

    public String getName() {
        if (this.getClass().getName().endsWith("Tool")) {
            return this.getClass().getSimpleName().substring(0, this.getClass().getSimpleName().length() - 4);
        }
        return this.getClass().getSimpleName();
    }

    public boolean hasParams() {
        return true;
    }

    protected <T> String getBasicHelp(Class<T> argProxyInterface) {
        return this.getBasicHelp(new Class[]{argProxyInterface});
    }

    protected <T> String getBasicHelp(Class<T> ... argProxyInterfaces) {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(argProxyInterfaces);
    }

    public abstract String getHelp();

    protected <T> T validateAndParseParams(String[] args, Class<T> argProxyInterface) {
        String errorMessage = ArgumentParser.validateArgumentsLoudly(args, argProxyInterface);
        if (null != errorMessage) {
            throw new TerminateToolException(1, errorMessage + "\n" + this.getHelp());
        }
        return ArgumentParser.parse(args, argProxyInterface);
    }

    public String getShortDescription() {
        return "";
    }
}

