/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToStringSampleStream
extends FilterObjectStream<File, String> {
    private final Charset encoding;

    public FileToStringSampleStream(ObjectStream<File> samples, Charset encoding) {
        super(samples);
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File textFile, Charset encoding) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(textFile), encoding));
        StringBuilder text = new StringBuilder();
        try {
            int length;
            char[] buffer = new char[1024];
            while ((length = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                text.append(buffer, 0, length);
            }
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException e) {}
        }
        return text.toString();
    }

    @Override
    public String read() throws IOException {
        File sampleFile = (File)this.samples.read();
        if (sampleFile != null) {
            return FileToStringSampleStream.readFile(sampleFile, this.encoding);
        }
        return null;
    }
}

