/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

public class StringPattern {
    private static final int INITAL_CAPITAL_LETTER = 1;
    private static final int ALL_CAPITAL_LETTER = 2;
    private static final int ALL_LOWERCASE_LETTER = 4;
    private static final int ALL_LETTERS = 8;
    private static final int ALL_DIGIT = 16;
    private static final int CONTAINS_PERIOD = 32;
    private static final int CONTAINS_COMMA = 64;
    private static final int CONTAINS_SLASH = 128;
    private static final int CONTAINS_DIGIT = 256;
    private static final int CONTAINS_HYPHEN = 512;
    private static final int CONTAINS_LETTERS = 1024;
    private static final int CONTAINS_UPPERCASE = 2048;
    private final int pattern;
    private final int digits;

    private StringPattern(int pattern, int digits) {
        this.pattern = pattern;
        this.digits = digits;
    }

    public boolean isAllLetter() {
        return (this.pattern & 8) > 0;
    }

    public boolean isInitialCapitalLetter() {
        return (this.pattern & 1) > 0;
    }

    public boolean isAllCapitalLetter() {
        return (this.pattern & 2) > 0;
    }

    public boolean isAllLowerCaseLetter() {
        return (this.pattern & 4) > 0;
    }

    public boolean isAllDigit() {
        return (this.pattern & 0x10) > 0;
    }

    public int digits() {
        return this.digits;
    }

    public boolean containsPeriod() {
        return (this.pattern & 0x20) > 0;
    }

    public boolean containsComma() {
        return (this.pattern & 0x40) > 0;
    }

    public boolean containsSlash() {
        return (this.pattern & 0x80) > 0;
    }

    public boolean containsDigit() {
        return (this.pattern & 0x100) > 0;
    }

    public boolean containsHyphen() {
        return (this.pattern & 0x200) > 0;
    }

    public boolean containsLetters() {
        return (this.pattern & 0x400) > 0;
    }

    public static StringPattern recognize(String token) {
        int pattern = 30;
        int digits = 0;
        block6: for (int i = 0; i < token.length(); ++i) {
            boolean isLetter;
            char ch = token.charAt(i);
            int letterType = Character.getType(ch);
            boolean bl = isLetter = letterType == 1 || letterType == 2 || letterType == 3 || letterType == 4 || letterType == 5;
            if (isLetter) {
                pattern |= 0x400;
                pattern &= 0xFFFFFFEF;
                if (letterType == 1) {
                    if (i == 0) {
                        pattern |= 1;
                    }
                    pattern |= 0x800;
                    pattern &= 0xFFFFFFFB;
                    continue;
                }
                pattern &= 0xFFFFFFFD;
                continue;
            }
            pattern &= 0xFFFFFFF7;
            pattern &= 0xFFFFFFFD;
            pattern &= 0xFFFFFFFB;
            if (letterType == 9) {
                pattern |= 0x100;
                ++digits;
            } else {
                pattern &= 0xFFFFFFEF;
            }
            switch (ch) {
                case ',': {
                    pattern |= 0x40;
                    continue block6;
                }
                case '.': {
                    pattern |= 0x20;
                    continue block6;
                }
                case '/': {
                    pattern |= 0x80;
                    continue block6;
                }
                case '-': {
                    pattern |= 0x200;
                    continue block6;
                }
            }
        }
        return new StringPattern(pattern, digits);
    }
}

