/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.file_chooser.ADirectoryParser;
import com.qarks.util.ui.swing.file_chooser.FileCellRenderer;
import com.qarks.util.ui.swing.file_chooser.FileDragHandler;
import com.qarks.util.ui.swing.file_chooser.FileProvider;
import com.qarks.util.ui.swing.file_chooser.FileSystemParserTreeModel;
import com.qarks.util.ui.swing.file_chooser.FileSystemParserUtility;
import com.qarks.util.ui.swing.file_chooser.FileTreeNode;
import com.qarks.util.ui.swing.file_chooser.IFileSystemParser;
import com.qarks.util.ui.swing.file_chooser.PathDoesNotExistException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileSystemParser
extends JTree
implements Runnable,
TreeWillExpandListener,
TreeSelectionListener,
IFileSystemParser,
FileProvider {
    private File mCurFile;
    private FileSystemView mFileSystemView;
    private FileView mFileView;
    private FileSystemParserTreeModel mTreeModel = null;
    private Timer mWorkingTimer = null;
    private ActionListener mWorkingAction = null;
    private FileTreeNode mRootNode = null;
    private FileTreeNode[] mSelectedNodes = null;
    private ADirectoryParser mDirectoryParser = null;
    private boolean mVisible = false;
    private boolean mSetCurDirRequested = false;

    public FileSystemParser(FileSystemView fileSystemView, FileView fileView, ADirectoryParser aDirectoryParser) {
        this.mFileSystemView = fileSystemView;
        this.mFileView = fileView;
        this.mDirectoryParser = aDirectoryParser;
        this.mWorkingAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileSystemParser.this.setCursor(Cursor.getPredefinedCursor(3));
                if (FileSystemParser.this.mDirectoryParser != null) {
                    FileSystemParser.this.mDirectoryParser.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        this.mWorkingTimer = new Timer(200, this.mWorkingAction);
        this.mWorkingTimer.setRepeats(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 116) {
                    FileSystemParser.this.refresh();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FileTreeNode[] fileTreeNodeArray;
                if (mouseEvent.getClickCount() > 1 && (fileTreeNodeArray = FileSystemParser.this.getSelectedNodes()).length == 1) {
                    FileTreeNode fileTreeNode = fileTreeNodeArray[0];
                    TreePath treePath = FileSystemParser.this.getTreePath(fileTreeNode);
                    if (FileSystemParser.this.isExpanded(treePath)) {
                        FileSystemParser.this.collapsePath(treePath);
                    } else {
                        FileSystemParser.this.fillAndExpandNode(fileTreeNodeArray[0]);
                    }
                }
            }
        });
        File[] fileArray = this.mFileSystemView.getRoots();
        this.mRootNode = new FileTreeNode(fileArray);
        Vector<FileTreeNode> vector = new Vector<FileTreeNode>();
        for (int i = 0; i < fileArray.length; ++i) {
            FileTreeNode fileTreeNode = new FileTreeNode(this.mFileView, fileArray[i]);
            vector.addElement(fileTreeNode);
            this.mRootNode.add(fileTreeNode);
        }
        this.mTreeModel = new FileSystemParserTreeModel(this.mRootNode);
        super.setModel(this.mTreeModel);
        super.setRootVisible(false);
        super.setShowsRootHandles(true);
        super.setCellRenderer(new FileCellRenderer(this.mFileView));
        super.addTreeWillExpandListener(this);
        super.addTreeSelectionListener(this);
        super.setRowHeight(18);
        super.getSelectionModel().setSelectionMode(1);
        super.setDragEnabled(true);
        super.setTransferHandler(new FileDragHandler(this));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = FileSystemParser.this.mRootNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    FileTreeNode fileTreeNode = (FileTreeNode)FileSystemParser.this.mRootNode.getChildAt(i);
                    fileTreeNode.lookupSubDirectories();
                    FileSystemParser.this.expandNode(fileTreeNode);
                }
                FileSystemParser.this.mVisible = true;
                if (FileSystemParser.this.mSetCurDirRequested) {
                    Thread thread = new Thread(FileSystemParser.this);
                    thread.start();
                }
            }
        });
    }

    @Override
    public File[] getSelectedFiles() {
        File[] fileArray = new File[]{};
        TreePath[] treePathArray = super.getSelectionPaths();
        if (treePathArray.length > 0) {
            int n;
            Vector<File> vector = new Vector<File>();
            for (n = 0; n < treePathArray.length; ++n) {
                Object object = treePathArray[n].getLastPathComponent();
                if (!(object instanceof FileTreeNode)) continue;
                FileTreeNode fileTreeNode = (FileTreeNode)object;
                vector.addElement(fileTreeNode.getFile());
            }
            fileArray = new File[vector.size()];
            for (n = 0; n < fileArray.length; ++n) {
                fileArray[n] = (File)vector.elementAt(n);
            }
        }
        return fileArray;
    }

    private void updateCursor(boolean bl) {
        if (bl) {
            this.mWorkingTimer.start();
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.mWorkingTimer.stop();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setWorking(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateCursor(bl);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileSystemParser.this.updateCursor(bl);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void refresh() {
        this.setWorking(true);
        this.getSelectedNodes();
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (FileSystemParser.this.mSelectedNodes != null && FileSystemParser.this.mSelectedNodes.length > 0) {
                    FileSystemParser.this.mSelectedNodes[0].refresh();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                FileSystemParser.this.mTreeModel.updateTree(FileSystemParser.this.mSelectedNodes[0]);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (FileSystemParser.this.mDirectoryParser != null) {
                    FileSystemParser.this.mDirectoryParser.refreshCurrentDirectory();
                }
                FileSystemParser.this.setWorking(false);
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File file = this.mCurFile;
        try {
            if (file.exists() && file.isDirectory()) {
                FileTreeNode fileTreeNode;
                Vector<File> vector = new Vector<File>(10);
                vector.insertElementAt(file, 0);
                while ((file = FileSystemParserUtility.getInstance().getParentFile(file, false)) != null) {
                    vector.insertElementAt(file, 0);
                }
                if (vector.size() > 0 && (fileTreeNode = this.findNode(file = (File)vector.elementAt(0), this.mRootNode)) != null) {
                    if (fileTreeNode.getChildCount() == 0) {
                        fileTreeNode.lookupSubDirectories();
                        this.synchronizedExpandNode(fileTreeNode);
                    }
                    for (int i = 1; i < vector.size(); ++i) {
                        file = (File)vector.elementAt(i);
                        fileTreeNode = this.findNode(file, fileTreeNode);
                        if (fileTreeNode == null || fileTreeNode.getChildCount() != 0) continue;
                        fileTreeNode.lookupSubDirectories();
                        this.synchronizedExpandNode(fileTreeNode);
                    }
                    this.synchronizedSelectNode(fileTreeNode);
                }
            }
        }
        catch (PathDoesNotExistException pathDoesNotExistException) {
            this.addNewPath(this.mCurFile);
        }
    }

    public void setCurrentDirectory(String string) {
        this.setCurrentDirectory(new File(string));
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (file.exists()) {
            this.mCurFile = file;
            if (this.mVisible) {
                Thread thread = new Thread(this);
                thread.start();
            } else {
                this.mSetCurDirRequested = true;
            }
        }
    }

    public void addNewPath(File file) {
        FileTreeNode fileTreeNode = new FileTreeNode(this.mFileView, file);
        DefaultMutableTreeNode defaultMutableTreeNode = fileTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (this.mFileSystemView.getParentDirectory(file) != null) {
            file = this.mFileSystemView.getParentDirectory(file);
            defaultMutableTreeNode2 = new FileTreeNode(this.mFileView, file);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        defaultMutableTreeNode = null;
        boolean bl = true;
        while (bl && defaultMutableTreeNode2 != null) {
            File file2 = (File)defaultMutableTreeNode2.getUserObject();
            FileTreeNode fileTreeNode2 = this.contains(this.mRootNode, file2);
            if (fileTreeNode2 != null) {
                defaultMutableTreeNode = fileTreeNode2;
                this.expandNode(fileTreeNode2);
                if (defaultMutableTreeNode2.getChildCount() > 0) {
                    defaultMutableTreeNode2 = (FileTreeNode)defaultMutableTreeNode2.getChildAt(0);
                    continue;
                }
                defaultMutableTreeNode2 = null;
                continue;
            }
            bl = false;
            if (defaultMutableTreeNode == null) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)super.getModel();
            defaultTreeModel.reload(defaultMutableTreeNode);
            this.expandNode((FileTreeNode)defaultMutableTreeNode);
            this.selectNode(fileTreeNode);
        }
    }

    public FileTreeNode contains(FileTreeNode fileTreeNode, File file) {
        FileTreeNode fileTreeNode2 = null;
        if (fileTreeNode.getUserObject().equals(file)) {
            fileTreeNode2 = fileTreeNode;
        } else {
            for (int i = 0; fileTreeNode2 == null && i < fileTreeNode.getChildCount(); ++i) {
                fileTreeNode2 = this.contains((FileTreeNode)fileTreeNode.getChildAt(i), file);
            }
        }
        return fileTreeNode2;
    }

    public String getCurrentDirectory() {
        TreePath[] treePathArray = super.getSelectionPaths();
        if (treePathArray != null) {
            this.mSelectedNodes = new FileTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.mSelectedNodes[i] = (FileTreeNode)treePathArray[i].getLastPathComponent();
            }
            if (this.mSelectedNodes.length > 0) {
                FileTreeNode fileTreeNode = this.mSelectedNodes[0];
                File file = (File)fileTreeNode.getUserObject();
                String string = file.getAbsolutePath();
                try {
                    string = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    System.err.println("canonical path failed, using absolutePath instead");
                }
                return string;
            }
            return null;
        }
        return "";
    }

    public FileTreeNode[] getSelectedNodes() {
        TreePath[] treePathArray = super.getSelectionPaths();
        if (treePathArray != null) {
            this.mSelectedNodes = new FileTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.mSelectedNodes[i] = (FileTreeNode)treePathArray[i].getLastPathComponent();
            }
            return this.mSelectedNodes;
        }
        return new FileTreeNode[0];
    }

    public Point getSelectedItemPosition() {
        if (this.mSelectedNodes != null && this.mSelectedNodes.length > 0) {
            FileTreeNode fileTreeNode = this.mSelectedNodes[0];
            int n = 0;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            while (fileTreeNode.getParent() != null) {
                n += defaultTreeModel.getIndexOfChild(fileTreeNode.getParent(), fileTreeNode);
                fileTreeNode = (FileTreeNode)fileTreeNode.getParent();
            }
            Rectangle rectangle = super.getRowBounds(n);
            return new Point((int)rectangle.getX(), (int)rectangle.getY());
        }
        return new Point(-1, -1);
    }

    public void selectNode(FileTreeNode fileTreeNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.mSelectedNodes = new FileTreeNode[1];
            this.mSelectedNodes[0] = fileTreeNode;
            TreePath treePath = this.getTreePath(fileTreeNode);
            super.scrollPathToVisible(treePath);
            super.setSelectionPath(treePath);
        } else {
            this.synchronizedSelectNode(fileTreeNode);
        }
    }

    private void synchronizedSelectNode(FileTreeNode fileTreeNode) {
        final FileTreeNode fileTreeNode2 = fileTreeNode;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FileSystemParser.access$602(FileSystemParser.this, new FileTreeNode[1]);
                    ((FileSystemParser)FileSystemParser.this).mSelectedNodes[0] = fileTreeNode2;
                    TreePath treePath = FileSystemParser.this.getTreePath(fileTreeNode2);
                    FileSystemParser.this.scrollPathToVisible(treePath);
                    FileSystemParser.this.setSelectionPath(treePath);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void expandNode(FileTreeNode fileTreeNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            TreePath treePath = this.getTreePath(fileTreeNode);
            super.expandPath(treePath);
        } else {
            this.synchronizedExpandNode(fileTreeNode);
        }
    }

    private void synchronizedExpandNode(FileTreeNode fileTreeNode) {
        final TreePath treePath = this.getTreePath(fileTreeNode);
        try {
            final FileTreeNode fileTreeNode2 = fileTreeNode;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FileSystemParser.this.mTreeModel.updateTree(fileTreeNode2);
                    FileSystemParser.this.expandPath(treePath);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileTreeNode findNode(File file, FileTreeNode fileTreeNode) throws PathDoesNotExistException {
        FileTreeNode fileTreeNode2 = null;
        boolean bl = false;
        for (int i = 0; !bl && i < fileTreeNode.getChildCount(); ++i) {
            FileTreeNode fileTreeNode3 = (FileTreeNode)fileTreeNode.getChildAt(i);
            File file2 = (File)fileTreeNode3.getUserObject();
            bl = file2.equals(file);
            if (!bl) continue;
            fileTreeNode2 = fileTreeNode3;
        }
        if (fileTreeNode2 == null) {
            throw new PathDoesNotExistException();
        }
        return fileTreeNode2;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        FileTreeNode fileTreeNode = (FileTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        this.fillAndExpandNode(fileTreeNode);
    }

    private void fillAndExpandNode(FileTreeNode fileTreeNode) {
        final FileTreeNode fileTreeNode2 = fileTreeNode;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (fileTreeNode2.getChildCount() == 0) {
                        fileTreeNode2.lookupSubDirectories();
                        FileSystemParser.this.expandNode(fileTreeNode2);
                        FileSystemParser.this.showMaxChild(fileTreeNode2);
                    } else {
                        FileSystemParser.this.expandNode(fileTreeNode2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    FileSystemParser.this.setWorking(false);
                }
            }
        };
        this.setWorking(true);
        thread.start();
    }

    private void showMaxChild(FileTreeNode fileTreeNode) {
        final FileTreeNode fileTreeNode2 = fileTreeNode;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TreePath treePath = FileSystemParser.this.getTreePath(FileSystemParser.this.getLastChild(fileTreeNode2));
                    Rectangle rectangle = FileSystemParser.this.getPathBounds(treePath);
                    FileSystemParser.this.scrollRectToVisible(rectangle);
                    treePath = FileSystemParser.this.getTreePath(fileTreeNode2);
                    rectangle = FileSystemParser.this.getPathBounds(treePath);
                    FileSystemParser.this.scrollRectToVisible(rectangle);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FileTreeNode getLastChild(FileTreeNode fileTreeNode) {
        if (fileTreeNode.getChildCount() > 0) {
            return (FileTreeNode)fileTreeNode.getChildAt(fileTreeNode.getChildCount() - 1);
        }
        return fileTreeNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        FileTreeNode fileTreeNode = (FileTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (this.mDirectoryParser != null) {
            this.mDirectoryParser.setCurrentDirectory((File)fileTreeNode.getUserObject());
        }
    }

    public TreePath getTreePath(FileTreeNode objectArray) {
        Object[] objectArray2;
        Vector<Object[]> vector = new Vector<Object[]>(10);
        vector.insertElementAt(objectArray, 0);
        while (objectArray.getParent() != null) {
            objectArray = objectArray2 = (Object[])objectArray.getParent();
            vector.insertElementAt(objectArray2, 0);
        }
        objectArray2 = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray2[i] = vector.elementAt(i);
        }
        TreePath treePath = new TreePath(objectArray2);
        return treePath;
    }

    static /* synthetic */ FileTreeNode[] access$602(FileSystemParser fileSystemParser, FileTreeNode[] fileTreeNodeArray) {
        fileSystemParser.mSelectedNodes = fileTreeNodeArray;
        return fileTreeNodeArray;
    }
}

