/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;

public final class PDDeviceRGB
extends PDDeviceColorSpace {
    public static final PDDeviceRGB INSTANCE = new PDDeviceRGB();
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)this);
    private volatile ColorSpace awtColorSpace;

    private PDDeviceRGB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.awtColorSpace != null) {
            return;
        }
        PDDeviceRGB pDDeviceRGB = this;
        synchronized (pDDeviceRGB) {
            if (this.awtColorSpace != null) {
                return;
            }
            this.awtColorSpace = ColorSpace.getInstance(1000);
            this.awtColorSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        }
    }

    @Override
    public String getName() {
        return COSName.DEVICERGB.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        this.init();
        return this.awtColorSpace.toRGB(value);
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) throws IOException {
        this.init();
        ComponentColorModel colorModel = new ComponentColorModel(this.awtColorSpace, false, false, 1, raster.getDataBuffer().getDataType());
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        int width = image.getWidth();
        int height = image.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                dest.setRGB(x, y, image.getRGB(x, y));
            }
        }
        return dest;
    }
}

