/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.ParallelLikelihood;
import dr.inference.parallel.MPIServices;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collection;

public class ParallelCompoundLikelihood
extends CompoundLikelihood {
    public static final String PARALLEL_COMPOUND_LIKELIHOOD = "parallelCompoundLikelihood";
    public static final String LOCAL_CHECK = "doLocalCheck";
    public static final String RUN_PARALLEL = "doInParallel";
    private boolean doParallel = true;
    private boolean checkLocal = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Likelihood.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return ParallelCompoundLikelihood.PARALLEL_COMPOUND_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = true;
            boolean bl2 = false;
            if (xMLObject.hasAttribute(ParallelCompoundLikelihood.LOCAL_CHECK)) {
                bl2 = xMLObject.getBooleanAttribute(ParallelCompoundLikelihood.LOCAL_CHECK);
            }
            if (xMLObject.hasAttribute(ParallelCompoundLikelihood.RUN_PARALLEL)) {
                bl = xMLObject.getBooleanAttribute(ParallelCompoundLikelihood.RUN_PARALLEL);
            }
            ArrayList<Likelihood> arrayList = new ArrayList<Likelihood>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Likelihood)) {
                    throw new XMLParseException("An element which is not a likelihood has been added to a parallelCompoundLikelihood element");
                }
                arrayList.add((Likelihood)xMLObject.getChild(i));
            }
            ParallelCompoundLikelihood parallelCompoundLikelihood = new ParallelCompoundLikelihood(arrayList, bl, bl2);
            return parallelCompoundLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "A likelihood function which is simply the product of its component likelihood functions.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return ParallelCompoundLikelihood.class;
        }
    };

    public ParallelCompoundLikelihood(Collection<Likelihood> collection, boolean bl, boolean bl2) {
        super(1, collection);
        this.doParallel = bl;
        this.checkLocal = bl2;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        if (this.doParallel) {
            d = this.getLogLikelihoodRemote();
            if (this.checkLocal) {
                super.makeDirty();
                double d2 = super.getLogLikelihood();
                System.err.printf("Local: %5.4f  Remote: %5.4f\n", d2, d);
            }
        } else {
            d = super.getLogLikelihood();
        }
        return d;
    }

    private double getLogLikelihoodRemote() {
        int n;
        double d = 0.0;
        int n2 = this.getLikelihoodCount();
        ArrayList<ParallelLikelihood> arrayList = new ArrayList<ParallelLikelihood>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            ParallelLikelihood parallelLikelihood = (ParallelLikelihood)this.getLikelihood(n);
            if (!parallelLikelihood.getLikelihoodKnown()) {
                int n3 = n + 1;
                arrayList.add(parallelLikelihood);
                arrayList2.add(n3);
                continue;
            }
            d += parallelLikelihood.getLogLikelihood();
        }
        n = arrayList.size();
        if (n == 1) {
            d += ((ParallelLikelihood)arrayList.get(0)).getLogLikelihood();
        } else if (n > 1) {
            int n4;
            int n5 = 0;
            for (ParallelLikelihood parallelLikelihood : arrayList) {
                n4 = (Integer)arrayList2.get(n5++);
                MPIServices.requestLikelihood(n4);
                ((AbstractModel)parallelLikelihood.getModel()).sendState(n4);
            }
            n5 = 0;
            for (ParallelLikelihood parallelLikelihood : arrayList) {
                n4 = (Integer)arrayList2.get(n5++);
                double d2 = MPIServices.receiveDouble(n4);
                d += d2;
                parallelLikelihood.setLikelihood(d2);
            }
        }
        return d;
    }
}

