/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;
import java.util.ArrayList;

public class LFMTargetedSearchOperator
extends SimpleMCMCOperator {
    ArrayList<MatrixParameterInterface> MatrixList;
    MatrixParameterInterface SparseMatrix;
    ArrayList<MatrixParameterInterface> FactorsMatrixList;
    MatrixParameterInterface FactorsMatrix;
    ArrayList<MatrixParameterInterface> LoadingsMatrixList;
    MatrixParameterInterface LoadingsMatrix;
    NormalDistribution error;
    MatrixParameterInterface cutoffs;
    private final double PROBABILITY = 0.9;
    private final double VAR = 0.15;
    private int lastDraw;

    public LFMTargetedSearchOperator(Double d, MatrixParameterInterface matrixParameterInterface, ArrayList<MatrixParameterInterface> arrayList, MatrixParameterInterface matrixParameterInterface2, ArrayList<MatrixParameterInterface> arrayList2, MatrixParameterInterface matrixParameterInterface3, ArrayList<MatrixParameterInterface> arrayList3, MatrixParameterInterface matrixParameterInterface4) {
        this.setWeight(d);
        this.SparseMatrix = matrixParameterInterface;
        this.MatrixList = arrayList;
        this.FactorsMatrix = matrixParameterInterface2;
        this.FactorsMatrixList = arrayList2;
        this.LoadingsMatrix = matrixParameterInterface3;
        this.LoadingsMatrixList = arrayList3;
        this.error = new NormalDistribution(0.0, 0.15);
        this.cutoffs = matrixParameterInterface4;
    }

    @Override
    public String getOperatorName() {
        return "Latent Factor Model Targeted Search Operator";
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        this.lastDraw = n2 = MathUtils.nextInt(this.MatrixList.size());
        double d = this.getHastings();
        for (n = 0; n < this.SparseMatrix.getDimension(); ++n) {
            if (MathUtils.nextDouble() < 0.9) {
                this.SparseMatrix.setParameterValue(n, this.MatrixList.get(n2).getParameterValue(n));
                continue;
            }
            this.SparseMatrix.setParameterValue(n, MathUtils.nextInt(2));
        }
        for (n = 0; n < this.FactorsMatrix.getDimension(); ++n) {
            this.FactorsMatrix.setParameterValue(n, this.FactorsMatrixList.get(n2).getParameterValue(n) + (Double)this.error.nextRandom());
        }
        for (n = 0; n < this.LoadingsMatrix.getDimension(); ++n) {
            boolean bl = true;
            int n3 = 0;
            while (bl || n3 == 10) {
                double d2 = this.LoadingsMatrixList.get(n2).getParameterValue(n) + (Double)this.error.nextRandom();
                if (-Math.sqrt(this.cutoffs.getParameterValue(n)) < d2 && Math.sqrt(this.cutoffs.getParameterValue(n)) > d2) {
                    bl = false;
                    this.LoadingsMatrix.setParameterValue(n, d2);
                    continue;
                }
                ++n3;
            }
        }
        return d -= this.getHastings();
    }

    private double getHastings() {
        int n;
        int n2;
        int n3 = this.MatrixList.size();
        double d = 0.0;
        for (n2 = 0; n2 < this.SparseMatrix.getDimension(); ++n2) {
            int n4 = 0;
            for (int i = 0; i < this.MatrixList.size(); ++i) {
                if (this.MatrixList.get(i).getParameterValue(n2) == this.SparseMatrix.getParameterValue(n2)) continue;
                ++n4;
            }
            d += Math.log((double)(n4 / n3) * 0.9 + 0.04999999999999999);
        }
        for (n2 = 0; n2 < this.FactorsMatrix.getDimension(); ++n2) {
            double d2 = 0.0;
            for (n = 0; n < this.FactorsMatrixList.size(); ++n) {
                d2 += this.error.logPdf(this.FactorsMatrix.getParameterValue(n2) - this.FactorsMatrixList.get(n).getParameterValue(n2)) - Math.log(this.FactorsMatrixList.size());
            }
            d += d2;
        }
        for (n2 = 0; n2 < this.LoadingsMatrix.getDimension(); ++n2) {
            double d3 = 0.0;
            for (n = 0; n < this.LoadingsMatrixList.size(); ++n) {
                d3 += this.error.logPdf(this.LoadingsMatrix.getParameterValue(n2) - this.LoadingsMatrixList.get(n).getParameterValue(n2)) - Math.log(this.error.cdf(Math.sqrt(this.cutoffs.getParameterValue(n2)) - this.LoadingsMatrixList.get(n).getParameterValue(n2)) - this.error.cdf(-Math.sqrt(this.cutoffs.getParameterValue(n2)) - this.LoadingsMatrixList.get(n).getParameterValue(n2))) - Math.log(this.FactorsMatrixList.size());
            }
            d += d3;
        }
        return d;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
        System.out.println(this.lastDraw);
    }
}

