/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.chol;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyLDLDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverCholLDL_D64
extends LinearSolverAbstract_D64 {
    private CholeskyDecompositionLDL_D64 decomposer;
    private int n;
    private double[] vv;
    private double[] el;
    private double[] d;

    public LinearSolverCholLDL_D64(CholeskyDecompositionLDL_D64 decomposer) {
        this.decomposer = decomposer;
    }

    public LinearSolverCholLDL_D64() {
        this.decomposer = new CholeskyDecompositionLDL_D64();
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        if (this.decomposer.decompose(A)) {
            this.n = A.numCols;
            this.vv = this.decomposer._getVV();
            this.el = this.decomposer.getL().data;
            this.d = this.decomposer.getDiagonal();
            return true;
        }
        return false;
    }

    @Override
    public double quality() {
        return Math.abs(SpecializedOps.diagProd(this.decomposer.getL()));
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        if (B.numCols != X.numCols && B.numRows != this.n && X.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int numCols = B.numCols;
        double[] dataB = B.data;
        double[] dataX = X.data;
        for (int j = 0; j < numCols; ++j) {
            int i;
            for (i = 0; i < this.n; ++i) {
                this.vv[i] = dataB[i * numCols + j];
            }
            this.solveInternal();
            for (i = 0; i < this.n; ++i) {
                dataX[i * numCols + j] = this.vv[i];
            }
        }
    }

    private void solveInternal() {
        TriangularSolver.solveL(this.el, this.vv, this.n);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.vv[n] = this.vv[n] / this.d[i];
        }
        TriangularSolver.solveTranL(this.el, this.vv, this.n);
    }

    @Override
    public void invert(DenseMatrix64F inv) {
        int k;
        double sum;
        int i;
        if (inv.numRows != this.n || inv.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        double[] a = inv.data;
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j <= i; ++j) {
                sum = i == j ? 1.0 : 0.0;
                for (k = i - 1; k >= j; --k) {
                    sum -= this.el[i * this.n + k] * a[j * this.n + k];
                }
                a[j * this.n + i] = sum;
            }
        }
        for (i = 0; i < this.n; ++i) {
            double inv_d = 1.0 / this.d[i];
            for (int j = 0; j <= i; ++j) {
                int n = j * this.n + i;
                a[n] = a[n] * inv_d;
            }
        }
        for (i = this.n - 1; i >= 0; --i) {
            for (int j = 0; j <= i; ++j) {
                sum = i < j ? 0.0 : a[j * this.n + i];
                for (k = i + 1; k < this.n; ++k) {
                    sum -= this.el[k * this.n + i] * a[j * this.n + k];
                }
                double d = sum;
                a[j * this.n + i] = d;
                a[i * this.n + j] = d;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public CholeskyLDLDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

