/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.BaseValueCheck;
import org.ohdsi.circe.check.checkers.RangeCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.InclusionRule;
import org.ohdsi.circe.cohortdefinition.ObservationFilter;
import org.ohdsi.circe.cohortdefinition.Window;

public class RangeCheck
extends BaseValueCheck {
    private static final String NEGATIVE_VALUE_ERROR = "Time window in criteria \"%s\" has negative value %d at %s";

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        super.check(expression, reporter);
        RangeCheckerFactory.getFactory(reporter, "Primary criteria").check(expression);
        if (Objects.nonNull(expression.primaryCriteria)) {
            this.checkObservationFilter(expression.primaryCriteria.observationWindow, reporter, "observation window");
        }
        RangeCheckerFactory.getFactory(reporter, "Primary criteria").checkRange(expression.censorWindow, "cohort", "censor window");
    }

    @Override
    protected void checkInclusionRules(CohortExpression expression, WarningReporter reporter) {
        super.checkInclusionRules(expression, reporter);
        for (InclusionRule rule : expression.inclusionRules) {
            if (!Objects.nonNull(rule.expression)) continue;
            for (CorelatedCriteria criteria : rule.expression.criteriaList) {
                this.checkWindow(criteria.startWindow, reporter, rule.name);
                this.checkWindow(criteria.endWindow, reporter, rule.name);
            }
        }
    }

    private void checkWindow(Window window, WarningReporter reporter, String name) {
        if (Objects.nonNull(window)) {
            if (Objects.nonNull(window.start) && Objects.nonNull(window.start.days) && window.start.days < 0) {
                reporter.add(NEGATIVE_VALUE_ERROR, name, window.start.days, "start");
            }
            if (Objects.nonNull(window.end) && Objects.nonNull(window.end.days) && window.end.days < 0) {
                reporter.add(NEGATIVE_VALUE_ERROR, name, window.end.days, "end");
            }
        }
    }

    private void checkObservationFilter(ObservationFilter filter, WarningReporter reporter, String name) {
        if (Objects.nonNull(filter)) {
            if (filter.priorDays < 0) {
                reporter.add(NEGATIVE_VALUE_ERROR, name, filter.priorDays, "prior days");
            }
            if (filter.postDays < 0) {
                reporter.add(NEGATIVE_VALUE_ERROR, name, filter.postDays, "post days");
            }
        }
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, WarningReporter reporter, String name) {
        super.checkCriteria(criteria, reporter, name);
        this.checkWindow(criteria.startWindow, reporter, name);
        this.checkWindow(criteria.endWindow, reporter, name);
    }

    @Override
    protected BaseCheckerFactory getFactory(WarningReporter reporter, String name) {
        return RangeCheckerFactory.getFactory(reporter, name);
    }
}

