/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class ProcedureOccurrenceSqlBuilder<T extends ProcedureOccurrence>
extends CriteriaSqlBuilder<T> {
    private static final String PROCEDURE_OCCURRENCE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/procedureOccurrence.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("po.person_id", "po.procedure_occurrence_id", "po.procedure_concept_id", "po.visit_occurrence_id", "po.quantity"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return PROCEDURE_OCCURRENCE_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.procedure_concept_id";
            }
            case DURATION: {
                return "CAST(1 as int)";
            }
            case QUANTITY: {
                return "C.quantity";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Procedure Occurrence:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((ProcedureOccurrence)criteria).codesetId, "po.procedure_concept_id", ((ProcedureOccurrence)criteria).procedureSourceConcept, "po.procedure_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((ProcedureOccurrence)criteria).first != null && ((ProcedureOccurrence)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY po.person_id ORDER BY po.procedure_date, po.procedure_occurrence_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((ProcedureOccurrence)criteria).procedureType != null && ((ProcedureOccurrence)criteria).procedureType.length > 0) {
            selectCols.add("po.procedure_type_concept_id");
        }
        if (((ProcedureOccurrence)criteria).modifier != null && ((ProcedureOccurrence)criteria).modifier.length > 0) {
            selectCols.add("po.modifier_concept_id");
        }
        if (((ProcedureOccurrence)criteria).providerSpecialty != null && ((ProcedureOccurrence)criteria).providerSpecialty.length > 0) {
            selectCols.add("po.provider_id");
        }
        if (((ProcedureOccurrence)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((ProcedureOccurrence)criteria).dateAdjustment, ((ProcedureOccurrence)criteria).dateAdjustment.startWith == DateAdjustment.DateType.START_DATE ? "po.procedure_date" : "DATEADD(day,1,po.procedure_date)", ((ProcedureOccurrence)criteria).dateAdjustment.endWith == DateAdjustment.DateType.START_DATE ? "po.procedure_date" : "DATEADD(day,1,po.procedure_date)"));
        } else {
            selectCols.add("po.procedure_date as start_date, DATEADD(day,1,po.procedure_date) as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((ProcedureOccurrence)criteria).age != null || ((ProcedureOccurrence)criteria).gender != null && ((ProcedureOccurrence)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((ProcedureOccurrence)criteria).visitType != null && ((ProcedureOccurrence)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((ProcedureOccurrence)criteria).providerSpecialty != null && ((ProcedureOccurrence)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<Long> conceptIds;
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((ProcedureOccurrence)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((ProcedureOccurrence)criteria).occurrenceStartDate));
        }
        if (((ProcedureOccurrence)criteria).procedureType != null && ((ProcedureOccurrence)criteria).procedureType.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((ProcedureOccurrence)criteria).procedureType);
            whereClauses.add(String.format("C.procedure_type_concept_id %s in (%s)", ((ProcedureOccurrence)criteria).procedureTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((ProcedureOccurrence)criteria).modifier != null && ((ProcedureOccurrence)criteria).modifier.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((ProcedureOccurrence)criteria).modifier);
            whereClauses.add(String.format("C.modifier_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((ProcedureOccurrence)criteria).quantity != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.quantity", ((ProcedureOccurrence)criteria).quantity));
        }
        if (((ProcedureOccurrence)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.start_date) - P.year_of_birth", ((ProcedureOccurrence)criteria).age));
        }
        if (((ProcedureOccurrence)criteria).gender != null && ((ProcedureOccurrence)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ProcedureOccurrence)criteria).gender), (String)",")));
        }
        if (((ProcedureOccurrence)criteria).providerSpecialty != null && ((ProcedureOccurrence)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ProcedureOccurrence)criteria).providerSpecialty), (String)",")));
        }
        if (((ProcedureOccurrence)criteria).visitType != null && ((ProcedureOccurrence)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ProcedureOccurrence)criteria).visitType), (String)",")));
        }
        return whereClauses;
    }
}

