/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray;

import java.util.ArrayList;
import net.sourceforge.jclec.IRecombinatorTest;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.Population;
import net.sourceforge.jclec.realarray.RealArrayIndividual;
import net.sourceforge.jclec.realarray.RealArrayIndividualSpecies;
import net.sourceforge.jclec.realarray.RealArrayRecombinator;
import net.sourceforge.jclec.realarray.SphereEvaluator;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.IRandGenFactory;
import net.sourceforge.jclec.util.random.Ranecu;
import net.sourceforge.jclec.util.range.Closure;
import net.sourceforge.jclec.util.range.IRange;
import net.sourceforge.jclec.util.range.Interval;

public abstract class RealArrayRecombinatorTest<R extends RealArrayRecombinator>
extends IRecombinatorTest<R> {
    public RealArrayRecombinatorTest(Class<R> recombinatorClass, String name) {
        super(recombinatorClass, name);
    }

    @Override
    protected void createParents() {
        this.parents = new ArrayList();
        this.parents.add(new RealArrayIndividual(new double[]{-4.5, -3.9, 2.1, 4.5}));
        this.parents.add(new RealArrayIndividual(new double[]{1.4, -2.6, 0.8, 3.3}));
    }

    @Override
    protected ISystem createContext() {
        Population pop = new Population();
        IRandGenFactory randGenFactory = new IRandGenFactory(){
            private static final long serialVersionUID = -8396371271024344889L;

            @Override
            public IRandGen createRandGen() {
                return new Ranecu(12345, 67890);
            }
        };
        pop.setRandGenFactory(randGenFactory);
        IRange[] ranges = new IRange[]{new Interval(-5.12, 5.12, Closure.ClosedClosed), new Interval(-5.12, 5.12, Closure.ClosedClosed), new Interval(-5.12, 5.12, Closure.ClosedClosed), new Interval(-5.12, 5.12, Closure.ClosedClosed)};
        RealArrayIndividualSpecies species = new RealArrayIndividualSpecies(ranges);
        pop.setSpecies(species);
        pop.setEvaluator(new SphereEvaluator());
        return pop;
    }
}

