/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.Angiulli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import moa.clusterers.outliers.Angiulli.ISBIndex;
import moa.clusterers.outliers.Angiulli.STORMBase;
import moa.clusterers.outliers.Angiulli.StreamObj;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class ApproxSTORM
extends STORMBase {
    public FloatOption radiusOption = new FloatOption("radius", 'r', "Search radius.", 0.1);
    public IntOption kOption = new IntOption("k", 't', "Parameter k.", 50);
    public IntOption queryFreqOption = new IntOption("queryFreq", 'q', "Query frequency.", 1);
    public FloatOption pOption = new FloatOption("p", 'p', "Parameter p.", 0.1);
    Set<ISBIndex.ISBNode> safe_inliers;
    int m_FractWindowSize;
    Random m_Random;

    public String getObjectInfo(Object obj) {
        int i;
        if (obj == null) {
            return null;
        }
        ISBNodeAppr node = (ISBNodeAppr)obj;
        ArrayList<String> infoTitle = new ArrayList<String>();
        ArrayList<String> infoValue = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < node.obj.dimensions(); ++i) {
            infoTitle.add("Dim" + (i + 1));
            infoValue.add(String.format("%.3f", node.obj.get(i)));
        }
        infoTitle.add("id");
        infoValue.add(String.format("%d", node.id));
        infoTitle.add("count_after");
        infoValue.add(String.format("%d", node.count_after));
        infoTitle.add("count_before");
        infoValue.add(String.format("%d", node.count_before));
        sb.append("<html>");
        sb.append("<table>");
        for (i = 0; i < infoTitle.size() && i < infoValue.size(); ++i) {
            sb.append("<tr><td><b>" + (String)infoTitle.get(i) + ":</b></td><td>" + (String)infoValue.get(i) + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    public void Init() {
        super.Init();
        this.m_WindowSize = this.windowSizeOption.getValue();
        this.m_radius = this.radiusOption.getValue();
        this.m_k = this.kOption.getValue();
        this.m_QueryFreq = this.queryFreqOption.getValue();
        this.m_FractWindowSize = (int)(this.pOption.getValue() * (double)this.m_WindowSize);
        this.Println("Init DistanceOutliersAppr:");
        this.Println("   window_size: " + this.m_WindowSize);
        this.Println("   radius: " + this.m_radius);
        this.Println("   k: " + this.m_k);
        this.Println("   query_freq: " + this.m_QueryFreq);
        this.m_Random = new Random();
        this.objId = FIRST_OBJ_ID;
        this.windowNodes = new Vector();
        this.ISB = new ISBIndex(this.m_radius, this.m_k);
        this.safe_inliers = new HashSet<ISBIndex.ISBNode>();
        this.m_nBothInlierOutlier = 0;
        this.m_nOnlyInlier = 0;
        this.m_nOnlyOutlier = 0;
    }

    void AddSafeInlier(ISBIndex.ISBNode node) {
        this.safe_inliers.add(node);
    }

    ISBIndex.ISBNode GetSafeInlier(int idx) {
        ISBNodeAppr node = null;
        Iterator<ISBIndex.ISBNode> it = this.safe_inliers.iterator();
        while (idx >= 0) {
            node = (ISBNodeAppr)it.next();
            --idx;
        }
        return node;
    }

    boolean IsSafeInlier(ISBNodeAppr node) {
        return node.count_after >= (long)this.m_k;
    }

    void PrintSafeInliers() {
        this.Print("Safe inliers: ");
        for (ISBIndex.ISBNode node : this.safe_inliers) {
            this.Print(node.id + " ");
        }
        this.Println(" ");
    }

    void RemoveNode(ISBIndex.ISBNode node) {
        this.ISB.Remove(node);
        this.windowNodes.remove(node);
        this.safe_inliers.remove(node);
        this.RemoveExpiredOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        this.UpdateStatistics(node);
    }

    void RemoveSafeInlier(ISBIndex.ISBNode node) {
        this.ISB.Remove(node);
        this.safe_inliers.remove(node);
    }

    void DeleteExpiredNode() {
        if (this.windowNodes.size() <= 0) {
            return;
        }
        ISBIndex.ISBNode node = (ISBIndex.ISBNode)this.windowNodes.get(0);
        if (node.id < this.GetWindowStart()) {
            if (this.bTrace) {
                this.Print("Delete expired node: ");
                this.PrintNode(node);
            }
            this.RemoveNode(node);
        }
    }

    protected void ProcessNewStreamObj(Instance inst) {
        if (this.bShowProgress) {
            this.ShowProgress("Processed " + this.objId + " stream objects.");
        }
        double[] values = this.getInstanceValues(inst);
        StreamObj obj = new StreamObj(values);
        if (this.bTrace) {
            this.Println("\n- - - - - - - - - - - -\n");
        }
        this.DeleteExpiredNode();
        ISBNodeAppr nodeNew = new ISBNodeAppr(inst, obj, this.objId, this.m_k);
        if (this.bTrace) {
            this.Print("New obj: ");
            this.PrintNode(nodeNew);
        }
        Long l = this.objId;
        Long l2 = this.objId = Long.valueOf(this.objId + 1L);
        nodeNew.count_after = 1L;
        nodeNew.count_before = 0L;
        if (this.bTrace) {
            this.Println("Perform range query seach:");
        }
        ++this.nRangeQueriesExecuted;
        Vector<ISBIndex.ISBSearchResult> nodes = this.ISB.RangeSearch(nodeNew, this.m_radius);
        Long count_si_before = 0L;
        for (ISBIndex.ISBSearchResult res : nodes) {
            int nSafeInliers;
            ISBNodeAppr n = (ISBNodeAppr)res.node;
            if (this.bTrace) {
                this.Printf("   Found at d=%.2f: ", res.distance);
                this.PrintNode(res.node);
            }
            Object object = n;
            Long l3 = ((ISBNodeAppr)object).count_after;
            Long l4 = ((ISBNodeAppr)object).count_after = Long.valueOf(((ISBNodeAppr)object).count_after + 1L);
            if (this.IsSafeInlier(n)) {
                if (this.bTrace) {
                    this.Println("   Safe inlier: id=" + n.id);
                }
                this.AddSafeInlier(n);
                object = count_si_before;
                l3 = count_si_before = Long.valueOf(count_si_before + 1L);
            }
            if ((nSafeInliers = this.safe_inliers.size()) > this.m_FractWindowSize) {
                int idx = this.m_Random.nextInt(nSafeInliers);
                ISBIndex.ISBNode si = this.GetSafeInlier(idx);
                if (this.bTrace) {
                    this.Println("   Remove random safe inlier: id=" + si.id);
                }
                this.RemoveSafeInlier(si);
            }
            object = nodeNew;
            l3 = ((ISBNodeAppr)object).count_before;
            l4 = ((ISBNodeAppr)object).count_before = Long.valueOf(((ISBNodeAppr)object).count_before + 1L);
        }
        int nSafeInliers = this.safe_inliers.size();
        if (nSafeInliers > 0) {
            nodeNew.fract_before = (double)count_si_before.longValue() / (double)nSafeInliers;
        } else {
            if (this.bTrace) {
                this.Println("Set fract before: no safe inliers yet, set 0.");
            }
            nodeNew.fract_before = 0.0;
        }
        if (this.bTrace) {
            this.Println("Node: ");
            this.Println("   count_after=" + nodeNew.count_after);
            this.Println("   count_before=" + nodeNew.count_before);
            this.Printf("   fract_before=%.3f\n", nodeNew.fract_before);
            this.Println("Insert new node to ISB.");
        }
        this.ISB.Insert(nodeNew);
        this.windowNodes.add(nodeNew);
        if (this.bTrace) {
            this.PrintWindow();
            this.PrintSafeInliers();
        }
        if (this.CanSearch()) {
            this.SearchOutliers();
        } else {
            this.UpdateNodeStatistics(nodeNew);
        }
    }

    void SearchOutliers() {
        if (this.bTrace) {
            this.Println("Invoke query: ");
        }
        for (int i = 0; i < this.windowNodes.size(); ++i) {
            ISBNodeAppr node = (ISBNodeAppr)this.windowNodes.get(i);
            if (this.bTrace) {
                this.Print("   Process node: ");
                this.PrintNode(node);
            }
            this.UpdateNodeType(node);
        }
    }

    void UpdateNodeType(ISBNodeAppr node) {
        double succ_neighs = node.count_after.longValue();
        if (this.bTrace) {
            this.Println("      succ_neighs: " + succ_neighs);
        }
        double prec_neighs = node.fract_before * (double)Math.abs(node.id + (long)this.m_WindowSize - this.GetWindowEnd());
        if (this.bTrace) {
            this.Println("      prec_neighs: " + prec_neighs);
        }
        if (succ_neighs + prec_neighs < (double)this.m_k) {
            this.SaveOutlier(node);
            if (this.bTrace) {
                this.Print("*** Outlier: ");
                this.PrintNode(node);
            }
        } else {
            this.RemoveOutlier(node);
        }
    }

    void UpdateNodeStatistics(ISBNodeAppr node) {
        double prec_neighs;
        double succ_neighs = node.count_after.longValue();
        if (succ_neighs + (prec_neighs = node.fract_before * (double)Math.abs(node.id + (long)this.m_WindowSize - this.GetWindowEnd())) < (double)this.m_k) {
            ++node.nOutlier;
        } else {
            ++node.nInlier;
        }
    }

    public class ISBNodeAppr
    extends ISBIndex.ISBNode {
        public Long count_after;
        public Long count_before;
        public double fract_before;

        public ISBNodeAppr(Instance inst, StreamObj obj, Long id, int k) {
            super(inst, obj, id);
            ApproxSTORM.this.m_k = k;
            this.count_after = 0L;
            this.count_before = 0L;
            this.fract_before = 0.0;
        }
    }
}

