/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.Clusterer;
import moa.gui.GUIUtils;
import moa.gui.OptionEditComponent;
import moa.options.ClassOption;
import moa.streams.clustering.ClusteringStream;

public class ClusteringAlgoPanel
extends JPanel
implements ActionListener {
    protected List<OptionEditComponent> editComponents = new LinkedList<OptionEditComponent>();
    private ClassOption streamOption = new ClassOption("Stream", 's', "", ClusteringStream.class, "RandomRBFGeneratorEvents");
    private ClassOption algorithmOption0 = new ClassOption("Algorithm0", 'a', "Algorithm to use.", Clusterer.class, "ClusterGenerator");
    private ClassOption algorithmOption1 = new ClassOption("Algorithm1", 'c', "Comparison algorithm", Clusterer.class, "", "clustream.WithKmeans");

    public ClusteringAlgoPanel() {
        this.initComponents();
    }

    public void renderAlgoPanel() {
        this.setLayout(new BorderLayout());
        ArrayList<ClassOption> options = new ArrayList<ClassOption>();
        options.add(this.streamOption);
        options.add(this.algorithmOption0);
        options.add(this.algorithmOption1);
        JPanel optionsPanel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        optionsPanel.setLayout(gbLayout);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.fill = 0;
        gbcLabel.anchor = 13;
        gbcLabel.weightx = 0.0;
        gbcLabel.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gbcOption = new GridBagConstraints();
        gbcOption.gridx = 1;
        gbcOption.fill = 2;
        gbcOption.anchor = 10;
        gbcOption.weightx = 1.0;
        gbcOption.insets = new Insets(5, 5, 5, 0);
        JLabel labelStream = new JLabel("Stream");
        labelStream.setToolTipText("Stream to use.");
        optionsPanel.add((Component)labelStream, gbcLabel);
        JComponent editorStream = this.streamOption.getEditComponent();
        labelStream.setLabelFor(editorStream);
        this.editComponents.add((OptionEditComponent)((Object)editorStream));
        optionsPanel.add((Component)editorStream, gbcOption);
        JLabel labelAlgo0 = new JLabel("Algorithm1");
        labelAlgo0.setToolTipText("Algorithm to use.");
        optionsPanel.add((Component)labelAlgo0, gbcLabel);
        JComponent editorAlgo0 = this.algorithmOption0.getEditComponent();
        labelAlgo0.setLabelFor(editorAlgo0);
        this.editComponents.add((OptionEditComponent)((Object)editorAlgo0));
        optionsPanel.add((Component)editorAlgo0, gbcOption);
        JLabel labelAlgo1 = new JLabel("Algorithm2");
        labelAlgo1.setToolTipText("Comparison algorithm to use.");
        optionsPanel.add((Component)labelAlgo1, gbcLabel);
        JComponent editorAlgo1 = this.algorithmOption1.getEditComponent();
        labelAlgo1.setLabelFor(editorAlgo1);
        this.editComponents.add((OptionEditComponent)((Object)editorAlgo1));
        optionsPanel.add((Component)editorAlgo1, gbcOption);
        GridBagConstraints gbcClearButton = new GridBagConstraints();
        gbcClearButton.gridx = 2;
        gbcClearButton.gridy = 2;
        gbcClearButton.fill = 0;
        gbcClearButton.anchor = 10;
        gbcClearButton.insets = new Insets(5, 0, 5, 5);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(this);
        clearButton.setActionCommand("clear");
        optionsPanel.add((Component)clearButton, gbcClearButton);
        this.add(optionsPanel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("clear")) {
            this.algorithmOption1.setValueViaCLIString("None");
            this.editComponents.get(2).setEditState("None");
        }
    }

    public AbstractClusterer getClusterer0() {
        AbstractClusterer c = null;
        this.applyChanges();
        try {
            c = (AbstractClusterer)ClassOption.cliStringToObject(this.algorithmOption0.getValueAsCLIString(), Clusterer.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(ClusteringAlgoPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return c;
    }

    public AbstractClusterer getClusterer1() {
        AbstractClusterer c = null;
        this.applyChanges();
        if (!this.algorithmOption1.getValueAsCLIString().equals("None")) {
            try {
                c = (AbstractClusterer)ClassOption.cliStringToObject(this.algorithmOption1.getValueAsCLIString(), Clusterer.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(ClusteringAlgoPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return c;
    }

    public ClusteringStream getStream() {
        ClusteringStream s = null;
        this.applyChanges();
        try {
            s = (ClusteringStream)ClassOption.cliStringToObject(this.streamOption.getValueAsCLIString(), ClusteringStream.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(ClusteringAlgoPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return s;
    }

    public String getStreamValueAsCLIString() {
        this.applyChanges();
        return this.streamOption.getValueAsCLIString();
    }

    public String getAlgorithm0ValueAsCLIString() {
        this.applyChanges();
        return this.algorithmOption0.getValueAsCLIString();
    }

    public String getAlgorithm1ValueAsCLIString() {
        this.applyChanges();
        return this.algorithmOption1.getValueAsCLIString();
    }

    public void setStreamValueAsCLIString(String s) {
        this.streamOption.setValueViaCLIString(s);
        this.editComponents.get(0).setEditState(this.streamOption.getValueAsCLIString());
    }

    public void setAlgorithm0ValueAsCLIString(String s) {
        this.algorithmOption0.setValueViaCLIString(s);
        this.editComponents.get(1).setEditState(this.algorithmOption0.getValueAsCLIString());
    }

    public void setAlgorithm1ValueAsCLIString(String s) {
        this.algorithmOption1.setValueViaCLIString(s);
        this.editComponents.get(2).setEditState(this.algorithmOption1.getValueAsCLIString());
    }

    public void applyChanges() {
        for (OptionEditComponent editor : this.editComponents) {
            try {
                editor.applyState();
            }
            catch (Exception ex) {
                GUIUtils.showExceptionDialog(this, "Problem with option " + editor.getEditedOption().getName(), ex);
            }
        }
    }

    public void setPanelTitle(String title) {
        this.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0, new Font("Tahoma", 1, 11)));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(null, "Cluster Algorithm Setup", 0, 0, new Font("Tahoma", 1, 11)));
        this.setLayout(new GridBagLayout());
    }
}

