/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.data;

import java.util.ArrayList;
import java.util.List;
import moa.recommender.rc.data.RecommenderData;
import moa.recommender.rc.utils.Updatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecommenderData
implements RecommenderData {
    private static final long serialVersionUID = -5409390358073330733L;
    protected ArrayList<Updatable> updatables = new ArrayList();
    protected boolean disableUpdates = false;

    @Override
    public void disableUpdates(boolean disable) {
        this.disableUpdates = disable;
    }

    @Override
    public void addUser(int userID, List<Integer> ratedItems, List<Double> ratings) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateNewUser(userID, ratedItems, ratings);
        }
    }

    @Override
    public void removeUser(int userID) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateRemoveUser(userID);
        }
    }

    @Override
    public void addItem(int itemID, List<Integer> ratingUsers, List<Double> ratings) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateNewItem(itemID, ratingUsers, ratings);
        }
    }

    @Override
    public void removeItem(int itemID) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateRemoveItem(itemID);
        }
    }

    @Override
    public void setRating(int userID, int itemID, double rating) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateSetRating(userID, itemID, rating);
        }
    }

    @Override
    public void removeRating(int userID, int itemID) {
        for (Updatable u : this.updatables) {
            if (this.disableUpdates) continue;
            u.updateRemoveRating(userID, itemID);
        }
    }

    @Override
    public void attachUpdatable(Updatable obj) {
        this.updatables.add(obj);
    }

    @Override
    public void clear() {
        this.updatables.clear();
        this.disableUpdates = false;
    }

    @Override
    public void close() {
    }
}

