/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class LEDGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public static final int NUM_IRRELEVANT_ATTRIBUTES = 17;
    protected static final int[][] originalInstances = new int[][]{{1, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 0, 1, 0}, {1, 1, 0, 1, 0, 1, 1}, {1, 1, 0, 1, 1, 1, 1}, {1, 0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 1, 1}};
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption noisePercentageOption = new IntOption("noisePercentage", 'n', "Percentage of noise to add to the data.", 10, 0, 100);
    public FlagOption suppressIrrelevantAttributesOption = new FlagOption("suppressIrrelevantAttributes", 's', "Reduce the data to only contain 7 relevant binary attributes.");
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;

    public String getPurposeString() {
        return "Generates a problem of predicting the digit displayed on a 7-segment LED display.";
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        FastVector<String> binaryLabels = new FastVector<String>();
        binaryLabels.addElement("0");
        binaryLabels.addElement("1");
        int numAtts = 7;
        if (!this.suppressIrrelevantAttributesOption.isSet()) {
            numAtts += 17;
        }
        for (int i = 0; i < numAtts; ++i) {
            attributes.addElement(new Attribute("att" + (i + 1), binaryLabels));
        }
        FastVector<String> classLabels = new FastVector<String>();
        for (int i = 0; i < 10; ++i) {
            classLabels.addElement(Integer.toString(i));
        }
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public Instance nextInstance() {
        int i;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setDataset(header);
        int selected = this.instanceRandom.nextInt(10);
        for (i = 0; i < 7; ++i) {
            if (1 + this.instanceRandom.nextInt(100) <= this.noisePercentageOption.getValue()) {
                inst.setValue(i, originalInstances[selected][i] == 0 ? 1.0 : 0.0);
                continue;
            }
            inst.setValue(i, (double)originalInstances[selected][i]);
        }
        if (!this.suppressIrrelevantAttributesOption.isSet()) {
            for (i = 0; i < 17; ++i) {
                inst.setValue(i + 7, (double)this.instanceRandom.nextInt(2));
            }
        }
        inst.setClassValue(selected);
        return inst;
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

