/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.clusterers.AbstractClusterer;
import moa.core.ObjectRepository;
import moa.evaluation.LearningCurve;
import moa.gui.BatchCmd;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.IntOption;
import moa.streams.clustering.ClusteringStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateClustering
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Clusterer to train.", AbstractClusterer.class, "clustream.Clustream");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", ClusteringStream.class, "RandomRBFGeneratorEvents");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000, -1, Integer.MAX_VALUE);
    public IntOption measureCollectionTypeOption = new IntOption("measureCollectionType", 'm', "Type of measure collection", 0, 0, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv reslts to.", "dumpClustering.csv", "csv", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a clusterer on a stream.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        BatchCmd.runBatch((ClusteringStream)this.getPreparedClassOption(this.streamOption), (AbstractClusterer)this.getPreparedClassOption(this.learnerOption), this.measureCollectionTypeOption.getValue(), this.instanceLimitOption.getValue(), this.dumpFileOption.getValue());
        LearningCurve learningCurve = new LearningCurve("EvaluateClustering does not support custom output file (> [filename]).\nCheck out the dump file to see the results (if you haven't specified, dumpClustering.csv by default).");
        return learningCurve;
    }
}

