## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(clinfun)
library(UnplanSimon)

## -----------------------------------------------------------------------------
library(clinfun)
# Specify the parameters and constraints
trial = ph2simon(0.25, 0.45, 0.1, 0.1)
# Print
trial

## -----------------------------------------------------------------------------
ATS_Design(n1=14,n=44,n1_star=11,n_star=41,r1=3,r=14,p0=0.25,p1=0.45,alpha=0.1)

## -----------------------------------------------------------------------------
ATS_Design(n1=14,n=44,n1_star=11,n_star=39,r1=3,r=14,p0=0.25,p1=0.45,alpha=0.1)

## -----------------------------------------------------------------------------
ATS_Design(n1=14,n=44,n1_star=11,n_star=42,r1=3,r=14,p0=0.25,p1=0.45,alpha=0.1)

## -----------------------------------------------------------------------------
ATSS_Design_Stage1(p0=0.25,p1=0.45,n1_star=11,alpha=0.1,beta=0.1)

## -----------------------------------------------------------------------------
ATSS_Design_Stage2(p0=0.25,p1=0.45,r1_star=2,n1_star=11,n_double_star=45,alpha=0.1)

## -----------------------------------------------------------------------------
ATSS_Design_Stage2(p0=0.25,p1=0.45,r1_star=2,n1_star=11,n_double_star=48,alpha=0.1)

## -----------------------------------------------------------------------------
## Our algorithm searching process
result <- data.frame(
  r_star = round(c(2.0000000, 3.0000000, 4.0000000, 5.0000000, 6.0000000, 
                   7.0000000, 8.0000000, 9.0000000, 10.0000000, 11.0000000, 
                   12.0000000, 13.0000000, 14.0000000, 15.0000000, 16.0000000)),
  alpha = round(c(0.5447991, 0.5447929, 0.5447130, 0.5442052, 0.5421068, 
                  0.5357601, 0.5207790, 0.4920445, 0.4460005, 0.3831060, 
                  0.3087428, 0.2317242, 0.1611787, 0.1035884, 0.0614173), 3),
  power = round(c(0.9347765, 0.9347765, 0.9347765, 0.9347765, 0.9347763, 
                  0.9347752, 0.9347684, 0.9347366, 0.9346115, 0.9341919, 
                  0.9329744, 0.9298792, 0.9229204, 0.9089765, 0.8839142), 3)
)
print(result)

## -----------------------------------------------------------------------------
SimonAnalysis(m=2, s=20, n1=11, n2=30, r1=2, r=14, alpha=0.088, quantile=c(0.025,0.975), CI_option = "CP", p0=0.25)
SimonAnalysis(m=2, s=20, n1=11, n2=30, r1=2, r=14, alpha=0.088, quantile=c(0.025,0.975), CI_option = "Jung", p0=0.25)
SimonAnalysis(m=2, s=20, n1=11, n2=30, r1=2, r=14, alpha=0.088, quantile=c(0.025,0.975), CI_option = "MIDp", p0=0.25)

## -----------------------------------------------------------------------------
SimonAnalysis(m=2, s=22, n1=11, n2=36, r1=2, r=15, alpha=0.1, quantile=c(0.025,0.975), CI_option = "CP", p0=0.25)
SimonAnalysis(m=2, s=22, n1=11, n2=36, r1=2, r=15, alpha=0.1, quantile=c(0.025,0.975), CI_option = "Jung", p0=0.25)
SimonAnalysis(m=2, s=22, n1=11, n2=36, r1=2, r=15, alpha=0.1, quantile=c(0.025,0.975), CI_option = "MIDp", p0=0.25)

