## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----libs, echo = F, message = F----------------------------------------------
# devtools::install_github("njlyon0/dndR", force = TRUE)
library(dndR)

## ----encounter_creator--------------------------------------------------------
# Pick a hard set of creatures for a four-person party of 3rd level characters
## Try 10 times to find the 'best' encounter
encounter_creator(party_level = 3, party_size = 4, ver = "2014", difficulty = "hard", try = 10)

# Design a moderately difficult encounter for a 3-person, 8th level party with no more than 6 creatures
encounter_creator(party_level = 8, party_size = 4, ver = "2024", difficulty = "moderate", max_creatures = 6)

## ----xp_pool-24---------------------------------------------------------------
# Calculate pool of available XP
xp_pool(party_level = 3, party_size = 4, ver = "2024", difficulty = "moderate")

## ----xp_pool-14---------------------------------------------------------------
# Calculate pool of available XP
xp_pool(party_level = 3, party_size = 4, ver = "2014", difficulty = "medium")

## ----xp_cost------------------------------------------------------------------
# Identify 'realized' XP of two monsters worth a total of 800 XP versus our party
xp_cost(monster_xp = 500, monster_count = 2, party_size = 4, ver = "2014")

