/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.");
    }

    public Object eval(Class clazz, int n, CallStack callStack, Interpreter interpreter) throws EvalError {
        int n2 = this.jjtGetNumChildren();
        int[] nArray = new int[n];
        nArray[0] = n2;
        Object object = Array.newInstance(clazz, nArray);
        int n3 = 0;
        while (n3 < n2) {
            Object object2;
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(n3);
            if (simpleNode instanceof BSHArrayInitializer) {
                if (n < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + n3, this);
                }
                object2 = ((BSHArrayInitializer)simpleNode).eval(clazz, n - 1, callStack, interpreter);
            } else {
                object2 = simpleNode.eval(callStack, interpreter);
            }
            if (object2 == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + n3, this);
            }
            Object object3 = object2 instanceof Primitive ? ((Primitive)object2).getValue() : object2;
            try {
                Array.set(object, n3, object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Interpreter.debug("illegal arg" + illegalArgumentException);
                this.throwTypeError(clazz, object2, n3);
            }
            catch (ArrayStoreException arrayStoreException) {
                Interpreter.debug("arraystore" + arrayStoreException);
                this.throwTypeError(clazz, object2, n3);
            }
            ++n3;
        }
        return object;
    }

    private void throwTypeError(Class clazz, Object object, int n) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = object instanceof Primitive ? ((Primitive)object).getType().getName() : Reflect.normalizeClassName(object.getClass());
        throw new EvalError("Incompatible type: " + string2 + " in initializer of array type: " + clazz + " at position: " + n, this);
    }
}

