/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import java.util.ArrayList;

public class SvmLight2FeatureVectorAndLabel
extends Pipe {
    private static final long serialVersionUID = 1L;

    public SvmLight2FeatureVectorAndLabel() {
        super(new Alphabet(), new LabelAlphabet());
    }

    @Override
    public Instance pipe(Instance carrier) {
        String[] terms;
        String classStr;
        String dataStr = (String)carrier.getData();
        if (dataStr.contains("#")) {
            dataStr = dataStr.substring(0, dataStr.indexOf(35));
        }
        if ((classStr = (terms = dataStr.split("\\s+"))[0]).equals("+1")) {
            classStr = "1";
        }
        Label label = ((LabelAlphabet)this.getTargetAlphabet()).lookupLabel(classStr, true);
        carrier.setTarget(label);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int termIndex = 1; termIndex < terms.length; ++termIndex) {
            if (terms[termIndex].equals("")) continue;
            String[] s = terms[termIndex].split(":");
            if (s.length != 2) {
                throw new RuntimeException("invalid format: " + terms[termIndex] + " (should be feature:value)");
            }
            String feature = s[0];
            int index = this.getDataAlphabet().lookupIndex(feature, true);
            if (index < 0) continue;
            indices.add(index);
            values.add(Double.parseDouble(s[1]));
        }
        assert (indices.size() == values.size());
        int[] indicesArr = new int[indices.size()];
        double[] valuesArr = new double[values.size()];
        for (int i = 0; i < indicesArr.length; ++i) {
            indicesArr[i] = (Integer)indices.get(i);
            valuesArr[i] = (Double)values.get(i);
        }
        FeatureVector fv = new FeatureVector(this.getDataAlphabet(), indicesArr, valuesArr);
        carrier.setData(fv);
        return carrier;
    }
}

