/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.CharSequenceReplaceHtmlEntities;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestCharSequenceReplaceHtmlEntities
extends TestCase {
    public void testReplaceAlphaEntities() {
        TestCharSequenceReplaceHtmlEntities.assertEquals("J'ai \"sorti\" le <strong>chien</strong> tout \u00e0 l'heure", this.stringCleansing("J'ai &quot;sorti&quot; le &lt;strong&gt;chien&lt;/strong&gt; tout &amp;agrave; l'heure"));
        TestCharSequenceReplaceHtmlEntities.assertEquals("Monsieur le Cur\u00e9 of the \u00abNotre-Dame-de-Gr\u00e2ce\u00bb neighborhood", this.stringCleansing("Monsieur le Cur&eacute; of the &laquo;Notre-Dame-de-Gr&acirc;ce&raquo; neighborhood"));
    }

    public void testReplaceDigitEntities() {
        TestCharSequenceReplaceHtmlEntities.assertEquals("I will display \u2702", this.stringCleansing("I will display &#9986;"));
    }

    private String stringCleansing(String str) {
        Instance instance = new Instance(str, null, null, null);
        InstanceList instances = new InstanceList(this.createPipes());
        instances.addThruPipe(instance);
        return (String)instance.getData();
    }

    private SerialPipes createPipes() {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        pipes.add(new CharSequenceReplaceHtmlEntities());
        return new SerialPipes(pipes);
    }
}

