/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Labeling;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class Instance
implements Serializable,
AlphabetCarrying,
Cloneable {
    private static Logger logger = MalletLogger.getLogger(Instance.class.getName());
    protected Object data;
    protected Object target;
    protected Object name;
    protected Object source;
    PropertyList properties = null;
    boolean locked = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Instance(Object data, Object target, Object name, Object source) {
        this.data = data;
        this.target = target;
        this.name = name;
        this.source = source;
    }

    public Object getData() {
        return this.data;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object getName() {
        return this.name;
    }

    public Object getSource() {
        return this.source;
    }

    public Alphabet getDataAlphabet() {
        if (this.data instanceof AlphabetCarrying) {
            return ((AlphabetCarrying)this.data).getAlphabet();
        }
        return null;
    }

    public Alphabet getTargetAlphabet() {
        if (this.target instanceof AlphabetCarrying) {
            return ((AlphabetCarrying)this.target).getAlphabet();
        }
        return null;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.getDataAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getDataAlphabet(), this.getTargetAlphabet()};
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        Alphabet[] oas = object.getAlphabets();
        return oas.length == 2 && oas[0].equals(this.getDataAlphabet()) && oas[1].equals(this.getDataAlphabet());
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public void unLock() {
        this.locked = false;
    }

    public Labeling getLabeling() {
        if (this.target == null || this.target instanceof Labeling) {
            return (Labeling)this.target;
        }
        throw new IllegalStateException("Target is not a Labeling; it is a " + this.target.getClass().getName());
    }

    public void setData(Object d) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.data = d;
    }

    public void setTarget(Object t) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.target = t;
    }

    public void setLabeling(Labeling l) {
        assert (this.target == null || this.target instanceof Labeling);
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.target = l;
    }

    public void setName(Object n) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.name = n;
    }

    public void setSource(Object s) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.source = s;
    }

    public void clearSource() {
        this.source = null;
    }

    public Instance shallowCopy() {
        Instance ret = new Instance(this.data, this.target, this.name, this.source);
        ret.locked = this.locked;
        ret.properties = this.properties;
        return ret;
    }

    public Object clone() {
        return this.shallowCopy();
    }

    public void setProperty(String key, Object value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    @Deprecated
    public PropertyList getProperties() {
        return this.properties;
    }

    @Deprecated
    public void setPropertyList(PropertyList p) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.properties = p;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.lookupObject(key);
    }

    public double getNumericProperty(String key) {
        return this.properties == null ? 0.0 : this.properties.lookupNumber(key);
    }

    public boolean hasProperty(String key) {
        return this.properties == null ? false : this.properties.hasProperty(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.data);
        out.writeObject(this.target);
        out.writeObject(this.name);
        out.writeObject(this.source);
        out.writeObject(this.properties);
        out.writeBoolean(this.locked);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.data = in.readObject();
        this.target = in.readObject();
        this.name = in.readObject();
        this.source = in.readObject();
        this.properties = (PropertyList)in.readObject();
        this.locked = in.readBoolean();
    }
}

