## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(metagam)

## -----------------------------------------------------------------------------
library(mgcv)
set.seed(123)
datasets <- lapply(1:5, function(x) gamSim(eg = 2, n = sample(100:1000, 1), 
                                           verbose = FALSE)$data)

## -----------------------------------------------------------------------------
knitr::kable(head(datasets[[1]]))

## -----------------------------------------------------------------------------
mod <- gam(y ~ te(x, z), data = datasets[[1]])

## -----------------------------------------------------------------------------
summary(mod)

## -----------------------------------------------------------------------------
vis.gam(mod, view = c("x", "z"), plot.type = "contour")

## -----------------------------------------------------------------------------
fits <- lapply(datasets, function(dat){
  b <- gam(y ~ te(x, z), data = dat)
  strip_rawdata(b)
})

## -----------------------------------------------------------------------------
summary(fits[[1]])

## -----------------------------------------------------------------------------
metafit <- metagam(fits, grid_size = 20)

## -----------------------------------------------------------------------------
summary(metafit)

## -----------------------------------------------------------------------------
plot(metafit)

